/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.source;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.RotationalNetworkBlock;
import eu.pb4.polyfactory.block.mechanical.source.WindmillBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.resourcepack.extras.api.ResourcePackExtras;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_156;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import xyz.nucleoid.packettweaker.PacketContext;

public class WindmillBlock
extends RotationalNetworkBlock
implements FactoryBlock,
RotationUser,
ConfigurableBlock,
class_2343,
BarrierBasedWaterloggable {
    public static final int MAX_SAILS = 8;
    public static final class_2746 BIG = class_2746.method_11825((String)"deco_big");
    public static final class_2758 SAIL_COUNT = class_2758.method_11867((String)"sails", (int)1, (int)8);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;

    public WindmillBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)SAIL_COUNT, (Comparable)Integer.valueOf(4))).method_11657((class_2769)BIG, (Comparable)Boolean.valueOf(false)));
        Model.MODEL.method_7909();
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING}).method_11667(new class_2769[]{SAIL_COUNT}).method_11667(new class_2769[]{BIG});
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        this.tickWater(state, world, tickView, pos);
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof WindmillBlockEntity) {
            WindmillBlockEntity be = (WindmillBlockEntity)class_25862;
            return be.getSails().isEmpty() ? FactoryItems.WINDMILL_SAIL.method_7854() : ((class_1799)be.getSails().get(0)).method_46651(1);
        }
        return FactoryItems.WINDMILL_SAIL.method_7854();
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8038().method_10153()));
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalDirectionNode((class_2350)state.method_11654(FACING)));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2470)rotation).method_10503(arg_0), FACING);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.transform(state, arg_0 -> ((class_2415)mirror).method_10343(arg_0), FACING);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(this, world, initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new WindmillBlockEntity(pos, state);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10161.method_9564();
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof WindmillBlockEntity) {
            WindmillBlockEntity blockEntity = (WindmillBlockEntity)class_25862;
            blockEntity.updateRotationalData(modifier, state, world, pos);
        }
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.FACING_HORIZONTAL);
    }

    public final class Model
    extends RotationAwareModel {
        public static final class_1799 MODEL = (class_1799)class_156.method_654((Object)new class_1799((class_1935)class_1802.field_18138), x -> x.method_57379(class_9334.field_54199, (Object)ResourcePackExtras.bridgeModel((class_2960)FactoryUtil.id("block/windmill_sail"))));
        public static final class_1799 MODEL_FLIP = (class_1799)class_156.method_654((Object)new class_1799((class_1935)class_1802.field_18138), x -> x.method_57379(class_9334.field_54199, (Object)ResourcePackExtras.bridgeModel((class_2960)FactoryUtil.id("block/windmill_sail_flip"))));
        private final Matrix4fStack mat = new Matrix4fStack(2);
        private final ItemDisplayElement center;
        private boolean big;
        private ItemDisplayElement[] sails;
        private WindmillBlockEntity blockEntity;

        private Model(WindmillBlock this$0, class_3218 world, class_2680 state) {
            this.big = (Boolean)state.method_11654((class_2769)BIG);
            this.updateSails((Integer)state.method_11654((class_2769)SAIL_COUNT), ((class_2350)state.method_11654(FACING)).method_10171() == class_2350.class_2352.field_11060);
            this.center = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL_SHORT, (int)this.getUpdateRate());
            this.center.setDisplaySize(3.0f, 3.0f);
            this.addElement((VirtualElement)this.center);
            this.updateAnimation(0.0f, (class_2350)state.method_11654(FACING), ((class_2350)state.method_11654(FACING)).method_10171() == class_2350.class_2352.field_11060);
        }

        private void updateSails(int count, boolean reverse) {
            int i;
            class_1799 model;
            ItemDisplayElement[] sails = new ItemDisplayElement[count];
            class_1799 class_17992 = model = reverse ? MODEL_FLIP : MODEL;
            if (this.sails != null) {
                if (this.sails.length == count) {
                    for (int i2 = 0; i2 < count; ++i2) {
                        this.sails[i2].setItem(this.colored(i2, model));
                    }
                    return;
                }
                if (this.sails.length > count) {
                    for (i = 0; i < this.sails.length; ++i) {
                        if (i < count) {
                            sails[i] = this.sails[i];
                            continue;
                        }
                        this.removeElement((VirtualElement)this.sails[i]);
                    }
                } else {
                    for (i = 0; i < count; ++i) {
                        if (i < this.sails.length) {
                            sails[i] = this.sails[i];
                            continue;
                        }
                        x = LodItemDisplayElement.createSimple((class_1799)class_1799.field_8037, (int)this.getUpdateRate());
                        x.setDisplaySize(0.0f, 0.0f);
                        sails[i] = x;
                        this.addElement((VirtualElement)x);
                    }
                }
            } else {
                for (i = 0; i < sails.length; ++i) {
                    x = LodItemDisplayElement.createSimple((class_1799)class_1799.field_8037, (int)this.getUpdateRate());
                    x.setDisplaySize(0.0f, 0.0f);
                    sails[i] = x;
                    this.addElement((VirtualElement)x);
                }
            }
            this.sails = sails;
            for (i = 0; i < count; ++i) {
                this.sails[i].setItem(this.colored(i, model));
            }
        }

        private class_1799 colored(int i, class_1799 model) {
            class_1799 c = model.method_7972();
            int color = 0xFFFFFF;
            if (this.blockEntity != null) {
                color = this.blockEntity.getSailColor(i);
            }
            c.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), (List)IntList.of((int)color)));
            return c;
        }

        private void updateAnimation(float speed, class_2350 direction, boolean reverse) {
            this.center.setYaw(direction.method_10144() - 90.0f);
            this.mat.identity();
            this.mat.rotateX(reverse ? speed : -speed);
            this.mat.pushMatrix();
            this.mat.rotateZ(-1.5707964f);
            this.mat.scale(2.0f);
            if (this.big) {
                this.mat.scale(2.0f);
            }
            this.center.setTransformation((Matrix4f)this.mat);
            this.mat.popMatrix();
            for (int i = 0; i < this.sails.length; ++i) {
                this.mat.pushMatrix();
                this.mat.rotateX((float)Math.PI * 2 / (float)this.sails.length * (float)i);
                this.mat.rotateY(-1.5707964f);
                this.sails[i].setYaw(direction.method_10144() - 90.0f);
                this.mat.translate(0.0f, 0.0f, 0.008f * (float)i);
                if (this.big) {
                    this.mat.scale(2.0f);
                }
                this.sails[i].setTransformation((Matrix4f)this.mat);
                this.mat.popMatrix();
            }
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (this.blockEntity == null) {
                WindmillBlockEntity be;
                class_2586 class_25862 = this.getAttachment().getWorld().method_8321(this.blockPos());
                this.blockEntity = class_25862 instanceof WindmillBlockEntity ? (be = (WindmillBlockEntity)class_25862) : null;
                this.updateSailsBe();
            }
            if (tick % (long)this.getUpdateRate() == 0L) {
                this.updateAnimation(this.getRotation(), (class_2350)this.blockState().method_11654(FACING), ((class_2350)this.blockState().method_11654(FACING)).method_10171() == class_2350.class_2352.field_11060);
                for (int i = 0; i < this.sails.length; ++i) {
                    if (!this.sails[i].isDirty()) continue;
                    this.sails[i].startInterpolation();
                }
                if (this.center.isDirty()) {
                    this.center.startInterpolation();
                }
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                class_2680 state = this.blockState();
                this.big = (Boolean)state.method_11654((class_2769)BIG);
                this.updateSailsBe();
                this.updateAnimation(RotationUser.getRotation((class_1937)this.getAttachment().getWorld(), this.blockPos()).rotation(), (class_2350)this.blockState().method_11654(FACING), ((class_2350)this.blockState().method_11654(FACING)).method_10171() == class_2350.class_2352.field_11060);
                for (int i = 0; i < this.sails.length; ++i) {
                    this.sails[i].setInterpolationDuration(0);
                    this.sails[i].tick();
                    this.sails[i].setInterpolationDuration(5);
                }
            }
        }

        public void updateSailsBe() {
            class_2680 state = this.blockState();
            this.updateSails((Integer)state.method_11654((class_2769)SAIL_COUNT), ((class_2350)state.method_11654(FACING)).method_10171() == class_2350.class_2352.field_11060);
        }
    }
}

