/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.other;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.block.other.ItemPackerBlock;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.PredicateLimitedSlot;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.SingleStackInventory;
import eu.pb4.polyfactory.util.storage.WrappingStorage;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_5537;
import net.minecraft.class_7225;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public class ItemPackerBlockEntity
extends LockableBlockEntity
implements BlockEntityExtraListener,
FilledStateProvider,
SingleStackInventory {
    private class_1799 itemStack = class_1799.field_8037;
    private ItemPackerBlock.Model model;
    private final InventoryStorage inventoryStorage = InventoryStorage.of((class_1263)this, null);
    @Nullable
    private Storage<ItemVariant> cachedItemStorage;

    public ItemPackerBlockEntity(class_2338 pos, class_2680 state) {
        this(FactoryBlockEntities.ITEM_PACKER, pos, state);
    }

    protected ItemPackerBlockEntity(class_2591<? extends ItemPackerBlockEntity> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        if (!this.itemStack.method_7960()) {
            nbt.method_10566("item", this.itemStack.method_57358(lookup));
        }
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11014(nbt, lookup);
        this.setStack(FactoryUtil.fromNbtStack(lookup, (class_2520)nbt.method_68568("item")));
    }

    @Override
    public class_1799 getStack() {
        return this.itemStack;
    }

    @Override
    public void setStack(class_1799 stack) {
        this.itemStack = stack;
        this.cachedItemStorage = null;
        this.method_5431();
        if (this.model != null) {
            this.model.setDisplay(this.itemStack);
        }
    }

    public void onListenerUpdate(class_2818 chunk) {
        ItemPackerBlock.Model model;
        ElementHolder elementHolder = BlockBoundAttachment.get((class_2818)chunk, (class_2338)this.field_11867).holder();
        ItemPackerBlock.Model model2 = this.model = elementHolder instanceof ItemPackerBlock.Model ? (model = (ItemPackerBlock.Model)elementHolder) : null;
        if (this.model != null) {
            this.model.setDisplay(this.itemStack);
        }
    }

    @Override
    @Nullable
    public class_2561 getFilledStateText() {
        if (this.itemStack.method_7960()) {
            return class_5244.field_39003;
        }
        return class_2561.method_43469((String)"text.polyfactory.x_out_of_y", (Object[])new Object[]{this.getFilledAmount(), this.getFillCapacity()});
    }

    @Override
    public long getFilledAmount() {
        class_1792 class_17922 = this.itemStack.method_7909();
        if (class_17922 instanceof class_5537) {
            class_5537 bundleItem = (class_5537)class_17922;
            Fraction oc = ((class_9276)this.itemStack.method_58695(class_9334.field_49650, (Object)class_9276.field_49289)).method_57428();
            return (long)oc.getNumerator() * 64L / (long)oc.getDenominator();
        }
        Storage<ItemVariant> x = this.getItemStorage();
        if (x == null) {
            return 0L;
        }
        long out = 0L;
        for (StorageView view : x) {
            out += view.getAmount();
        }
        return out;
    }

    @Override
    public long getFillCapacity() {
        class_1792 class_17922 = this.itemStack.method_7909();
        if (class_17922 instanceof class_5537) {
            class_5537 bundleItem = (class_5537)class_17922;
            return 64L;
        }
        Storage<ItemVariant> x = this.getItemStorage();
        if (x == null) {
            return 0L;
        }
        long out = 0L;
        for (StorageView view : x) {
            out += view.getCapacity();
        }
        return out;
    }

    public int method_58350(class_1799 stack) {
        return 1;
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        if (dir != null && ((class_2350)this.method_11010().method_11654(ItemPackerBlock.FACING)).method_10166() == dir.method_10166()) {
            return ItemStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)) != null;
        }
        return false;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir != null && ((class_2350)this.method_11010().method_11654(ItemPackerBlock.FACING)).method_10166() == dir.method_10166();
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return ((class_2350)this.method_11010().method_11654(ItemPackerBlock.FACING)).method_10166() == side.method_10166() ? SingleStackInventory.super.method_5494(side) : new int[]{};
    }

    private Storage<ItemVariant> getItemStorage() {
        if (this.cachedItemStorage != null) {
            return this.cachedItemStorage;
        }
        Storage storage = (Storage)ItemStorage.ITEM.find(this.itemStack, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)this.inventoryStorage.getSlot(0)));
        return WrappingStorage.withModifyCallback(storage, this::runAdvancement);
    }

    private void runAdvancement() {
        class_1657 class_16572;
        if (this.field_11863 != null && (class_16572 = FactoryUtil.getClosestPlayer(this.field_11863, this.field_11867, 16.0)) instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.ITEM_PACKER_ACCESSES);
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)this.getStack());
        }
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((self, dir) -> {
            class_2350 facing = (class_2350)self.method_11010().method_11654(ItemPackerBlock.FACING);
            if (dir != null && facing.method_10166() == dir.method_10166()) {
                return self.inventoryStorage;
            }
            return self.getItemStorage();
        }, FactoryBlockEntities.ITEM_PACKER);
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17337, player, false);
            this.setTitle(GuiTextures.CENTER_SLOT_GENERIC.apply((class_2561)ItemPackerBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlotRedirect(2, new PredicateLimitedSlot((class_1263)ItemPackerBlockEntity.this, 0, stack -> ItemStorage.ITEM.find(stack, (Object)ContainerItemContext.withConstant((class_1799)stack)) != null));
            this.open();
        }

        public void onClose() {
            super.onClose();
        }

        public void onTick() {
            if (ItemPackerBlockEntity.this.method_11015() || this.player.method_19538().method_1025(class_243.method_24953((class_2382)ItemPackerBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            super.onTick();
        }
    }
}

