/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.BoolData;
import eu.pb4.polyfactory.data.DataType;
import eu.pb4.polyfactory.data.DoubleData;
import eu.pb4.polyfactory.data.EmptyData;
import eu.pb4.polyfactory.data.LongData;
import eu.pb4.polyfactory.data.StringData;
import java.util.List;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;

public interface DataContainer
extends Comparable<DataContainer> {
    public static final MapCodec<DataContainer> MAP_CODEC = DataType.CODEC.dispatchMap("type", DataContainer::type, DataType::codec);
    public static final Codec<DataContainer> CODEC = MAP_CODEC.codec();
    public static final List<String> GENERIC_EXTRACTS = List.of("decimal", "integer", "string", "boolean", "redstone");

    public static DataContainer of(long count) {
        return new LongData(count);
    }

    public static DataContainer of(boolean count) {
        return count ? BoolData.TRUE : BoolData.FALSE;
    }

    public static DataContainer empty() {
        return EmptyData.INSTANCE;
    }

    public DataType<? extends DataContainer> type();

    public String asString();

    public long asLong();

    public double asDouble();

    default public boolean isEmpty() {
        return false;
    }

    default public int asRedstoneOutput() {
        return (int)class_3532.method_53062((long)this.asLong(), (long)0L, (long)15L);
    }

    default public char padding() {
        return ' ';
    }

    default public boolean forceRight() {
        return false;
    }

    default public DataContainer extract(String field) {
        return switch (field) {
            case "decimal" -> new DoubleData(this.asDouble());
            case "integer" -> new LongData(this.asLong());
            case "redstone" -> new LongData(this.asRedstoneOutput());
            case "string" -> new StringData(this.asString());
            case "boolean" -> BoolData.of(this.isTrue());
            case "" -> this;
            default -> DataContainer.empty();
        };
    }

    public static DataContainer fromNbt(class_2520 compound, class_7225.class_7874 lookup) {
        return (DataContainer)((Pair)CODEC.decode((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)compound).getOrThrow()).getFirst();
    }

    default public class_2520 createNbt(class_7225.class_7874 lookup) {
        return (class_2520)CODEC.encodeStart((DynamicOps)lookup.method_57093((DynamicOps)class_2509.field_11560), (Object)this).getOrThrow();
    }

    default public boolean isTrue() {
        return this.asLong() != 0L;
    }

    @Override
    default public int compareTo(DataContainer other) {
        return Long.compare(this.asLong(), other.asLong());
    }
}

