/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.DataType;
import eu.pb4.polyfactory.data.DoubleData;
import eu.pb4.polyfactory.data.StringData;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public record SoundEventData(class_6880<class_3414> soundEvent, float volume, float pitch, long seed) implements DataContainer
{
    public static MapCodec<SoundEventData> TYPE_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41172.method_40294().fieldOf("event").forGetter(SoundEventData::soundEvent), (App)Codec.FLOAT.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(SoundEventData::volume), (App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(SoundEventData::pitch), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(SoundEventData::seed)).apply((Applicative)instance, SoundEventData::new));

    public DataType<SoundEventData> type() {
        return DataType.SOUND_EVENT;
    }

    @Override
    public String asString() {
        return ((class_3414)this.soundEvent.comp_349()).comp_3319().toString();
    }

    @Override
    public long asLong() {
        return (long)this.volume;
    }

    @Override
    public double asDouble() {
        return this.volume;
    }

    @Override
    public DataContainer extract(String field) {
        return switch (field) {
            case "sound" -> new StringData(this.asString());
            case "pitch" -> new DoubleData(this.pitch);
            case "volume" -> new DoubleData(this.volume);
            default -> DataContainer.super.extract(field);
        };
    }

    @Override
    public int compareTo(@NotNull DataContainer o) {
        return Double.compare(this.volume, o.asDouble());
    }
}

