/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.DataType;
import eu.pb4.polyfactory.data.LongData;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public record StringData(String value) implements DataContainer
{
    public static MapCodec<StringData> TYPE_CODEC = Codec.STRING.xmap(StringData::new, StringData::value).fieldOf("value");
    public static final DataContainer EMPTY = new StringData("");

    public StringData(class_2960 value) {
        this(value.toString());
    }

    public static StringData ofLimited(String s) {
        return new StringData(s.substring(0, Math.min(s.length(), 512)));
    }

    public DataType<StringData> type() {
        return DataType.STRING;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public long asLong() {
        return this.value.length();
    }

    @Override
    public double asDouble() {
        return this.value.length();
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public boolean forceRight() {
        return false;
    }

    @Override
    public DataContainer extract(String field) {
        if (field.equals("length")) {
            return new LongData(this.value.length());
        }
        if (field.startsWith("charat:")) {
            try {
                int num = Integer.parseInt(field.substring("charat:".length()));
                if (num >= 0 && num < this.value.length()) {
                    return new StringData(Character.toString(this.value.charAt(num)));
                }
            }
            catch (Throwable num) {
                // empty catch block
            }
            return EMPTY;
        }
        if (field.startsWith("substring:")) {
            try {
                int end;
                String[] num = field.substring("substring:".length()).split("\\.", 2);
                int start = Integer.parseInt(num[0]);
                int n = end = num.length == 2 ? Integer.parseInt(num[1]) : this.value.length();
                if (start >= 0 && end <= this.value.length()) {
                    return new StringData(this.value.substring(start, end));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return EMPTY;
        }
        return DataContainer.super.extract(field);
    }

    @Override
    public int compareTo(@NotNull DataContainer o) {
        return this.value.compareTo(o.asString());
    }
}

