/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.datagen;

import com.google.common.hash.HashCode;
import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.font.DefaultFonts;
import eu.pb4.mapcanvas.api.utils.CanvasUtils;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.item.FactoryDebugItems;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.tool.SpoutMolds;
import eu.pb4.polyfactory.models.ConveyorModels;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.ResourceUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.extras.api.format.item.ItemAsset;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.BasicItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.CompositeItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ConditionItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.EmptyItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.ItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.RangeDispatchItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.model.SelectItemModel;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.BooleanProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.CustomModelDataFlagProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.bool.UsingItemProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.numeric.CustomModelDataFloatProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.numeric.NumericProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.DisplayContextProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.property.select.SelectProperty;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.ConstantTintSource;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.CustomModelDataTintSource;
import eu.pb4.polymer.resourcepack.extras.api.format.item.tint.PotionTintSource;
import eu.pb4.polymer.resourcepack.extras.api.format.model.ModelAsset;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

class AssetProvider
implements class_2405 {
    private final class_7784 output;

    public AssetProvider(FabricDataOutput output) {
        this.output = output;
    }

    public static void runWriters(BiConsumer<String, byte[]> assetWriter) {
        ConveyorModels.generateModels(assetWriter);
        UiResourceCreator.generateAssets(assetWriter);
        FactoryModels.COLORED_CABLE.generateModels(assetWriter);
        FactoryModels.COLORED_WALL_CABLE.generateModels(assetWriter);
        FactoryModels.PIPE.generateModels(assetWriter);
        FactoryModels.BLOCK_FLUID_TANK.generateModels(assetWriter);
        HashMap<class_2960, ItemAsset> map = new HashMap<class_2960, ItemAsset>();
        AssetProvider.createItems(map::put);
        map.forEach((id, asset) -> assetWriter.accept(AssetPaths.itemAsset((class_2960)id), asset.toJson().getBytes(StandardCharsets.UTF_8)));
        AssetProvider.createNumberButtons(assetWriter);
        MoldTextures moldTexture = new MoldTextures();
        for (SpoutMolds mold : FactoryItems.MOLDS) {
            AssetProvider.createMold(assetWriter, mold, moldTexture);
        }
    }

    private static void createMold(BiConsumer<String, byte[]> assetWriter, SpoutMolds mold, MoldTextures moldTexture) {
        BufferedImage stencil = ResourceUtils.getTexture(mold.name().method_45138("item/mold/source/"));
        class_2960 id = class_7923.field_41178.method_10221((Object)mold.mold());
        assetWriter.accept(AssetPaths.itemModel((class_2960)id), ModelAsset.builder().parent(class_2960.method_60654((String)"item/generated")).texture("layer0", id.method_45138("item/").toString()).build().toBytes());
        AssetProvider.createStencilTexture(id.method_45138("item/"), moldTexture.steelBase, moldTexture.steelBorder, stencil, assetWriter);
        id = class_7923.field_41178.method_10221((Object)mold.clay());
        assetWriter.accept(AssetPaths.itemModel((class_2960)id), ModelAsset.builder().parent(class_2960.method_60654((String)"item/generated")).texture("layer0", id.method_45138("item/").toString()).build().toBytes());
        AssetProvider.createStencilTexture(id.method_45138("item/"), moldTexture.clayBase, moldTexture.clayBorder, stencil, assetWriter);
        id = class_7923.field_41178.method_10221((Object)mold.hardened());
        assetWriter.accept(AssetPaths.itemModel((class_2960)id), ModelAsset.builder().parent(class_2960.method_60654((String)"item/generated")).texture("layer0", id.method_45138("item/").toString()).build().toBytes());
        AssetProvider.createStencilTexture(id.method_45138("item/"), moldTexture.hardenedBase, moldTexture.hardenedBorder, stencil, assetWriter);
    }

    private static void createStencilTexture(class_2960 identifier, BufferedImage base, BufferedImage border, BufferedImage stencil, BiConsumer<String, byte[]> assetWriter) {
        if (base.getWidth() != border.getWidth() || border.getWidth() != stencil.getWidth() || base.getHeight() != border.getHeight() || border.getHeight() != stencil.getHeight()) {
            throw new IllegalArgumentException("Mismatched image width and height for stenccil texture " + String.valueOf(identifier));
        }
        BufferedImage image = new BufferedImage(base.getWidth(), base.getHeight(), 2);
        for (int x = 0; x < base.getWidth(); ++x) {
            for (int y = 0; y < base.getHeight(); ++y) {
                int s = stencil.getRGB(x, y);
                if (class_9848.method_61320((int)s) == 0) {
                    image.setRGB(x, y, base.getRGB(x, y));
                    continue;
                }
                if (s != -16777216) continue;
                image.setRGB(x, y, border.getRGB(x, y));
            }
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assetWriter.accept(AssetPaths.texture((class_2960)identifier.method_48331(".png")), stream.toByteArray());
    }

    private static void createItems(final BiConsumer<class_2960, ItemAsset> consumer) {
        var fromItem = new BiConsumer<class_1792, Function<class_2960, ItemAsset>>(){

            @Override
            public void accept(class_1792 item, Function<class_2960, ItemAsset> function) {
                class_2960 id = class_7923.field_41178.method_10221((Object)item);
                consumer.accept(id, function.apply(id));
            }
        };
        for (class_1792 item : class_7923.field_41178) {
            class_2960 id2 = class_7923.field_41178.method_10221((Object)item);
            if (!id2.method_12836().equals("polyfactory")) continue;
            consumer.accept(id2, new ItemAsset((ItemModel)new BasicItemModel(id2.method_45138(item instanceof class_1747 ? "block/" : "item/")), ItemAsset.Properties.DEFAULT));
        }
        fromItem.accept(FactoryItems.WINDMILL_SAIL, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.CABLE, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.ARTIFICIAL_DYE, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new CustomModelDataTintSource(0, -1))), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.BRITTLE_POTION, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new PotionTintSource())), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.PORTABLE_REDSTONE_TRANSMITTER, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.SPRAY_CAN, id -> new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new CustomModelDataFlagProperty(0), (ItemModel)new BasicItemModel(id.method_45138("item/"), List.of(new CustomModelDataTintSource(0, -1))), (ItemModel)new BasicItemModel(id.method_45138("item/").method_48331("_empty"), List.of())), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/colored_lamp_off"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.INVERTED_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/colored_lamp_on"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.CAGED_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/caged_lamp_off"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.INVERTED_CAGED_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/caged_lamp_on"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.FIXTURE_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/fixture_lamp_off"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept((class_1792)FactoryItems.INVERTED_FIXTURE_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/fixture_lamp_on"), List.of(new ConstantTintSource(-1), new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.FAN, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("block/").method_48331("_base")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.FUNNEL, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("block/").method_48331("_out")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.SLOT_AWARE_FUNNEL, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("block/").method_48331("_out")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.FLUID_TANK, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("block/").method_48331("/single_single_single")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.INVERTED_REDSTONE_LAMP, id -> new ItemAsset((ItemModel)new BasicItemModel(class_2960.method_60656((String)"block/redstone_lamp_on")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.ELECTRIC_MOTOR, id -> new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/motor")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.DATA_MEMORY, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.EJECTOR, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/")), ItemAsset.Properties.DEFAULT));
        fromItem.accept(FactoryItems.PRESSURE_FLUID_GUN, id -> new ItemAsset((ItemModel)new ConditionItemModel((BooleanProperty)new UsingItemProperty(), (ItemModel)new BasicItemModel(id.method_45138("item/").method_48331("_active")), (ItemModel)new BasicItemModel(id.method_45138("item/"))), new ItemAsset.Properties(false)));
        for (class_1792 item : List.of(FactoryItems.TINY_POTATO_SPRING, FactoryItems.GOLDEN_TINY_POTATO_SPRING, FactoryItems.PIPE, FactoryItems.MECHANICAL_DRAIN, FactoryItems.PORTABLE_FLUID_TANK, FactoryItems.LARGE_STEEL_GEAR, FactoryItems.PUMP, FactoryItems.STEEL_BUTTON, FactoryDebugItems.ROTATION_DEBUG)) {
            fromItem.accept(item, id -> new ItemAsset((ItemModel)new BasicItemModel(id.method_45138("item/")), ItemAsset.Properties.DEFAULT));
        }
        fromItem.accept(FactoryItems.STEEL_GEAR, id -> new ItemAsset((ItemModel)SelectItemModel.builder((SelectProperty)new DisplayContextProperty()).withCase(List.of(class_811.field_4321, class_811.field_4322, class_811.field_4323, class_811.field_4320), (ItemModel)new BasicItemModel(id.method_45138("item/").method_48331("_world"))).fallback((ItemModel)new BasicItemModel(id.method_45138("item/"))).build(), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("debug_item"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("item/debug_item"), List.of(new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("-/block/windmill_sail"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/windmill_sail"), List.of(new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("-/block/windmill_sail_flip"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/windmill_sail_flip"), List.of(new CustomModelDataTintSource(0, 0xFFFFFF))), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("-/block/redstone_input_overlay"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/redstone_input_overlay"), List.of(new CustomModelDataTintSource(0, 0xFF0000))), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("-/block/redstone_output_overlay"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("block/redstone_output_overlay"), List.of(new CustomModelDataTintSource(0, 0xFF0000))), ItemAsset.Properties.DEFAULT));
        consumer.accept(ModInit.id("placeholder"), new ItemAsset((ItemModel)new BasicItemModel(ModInit.id("item/placeholder")), ItemAsset.Properties.DEFAULT));
        ArrayList<ConditionItemModel> list = new ArrayList<ConditionItemModel>();
        int[] offsets = new int[]{-54, -36, -18};
        for (int i = 0; i < 3; ++i) {
            RangeDispatchItemModel.Builder builder = RangeDispatchItemModel.builder((NumericProperty)new CustomModelDataFloatProperty(i)).scale(15.0f);
            builder.fallback((ItemModel)new EmptyItemModel());
            for (int a = 1; a <= 14; ++a) {
                builder.entry((float)a, (ItemModel)new BasicItemModel(ModInit.id("sgui/elements/gen/generic_bar_" + a + "_offset_" + offsets[i]), List.of(new CustomModelDataTintSource(i, 0xFFFFFF))));
            }
            list.add(new ConditionItemModel((BooleanProperty)new CustomModelDataFlagProperty(i), (ItemModel)new CompositeItemModel(List.of(new BasicItemModel(ModInit.id("sgui/elements/generic_bar_background_offset_" + offsets[i])), builder.build())), (ItemModel)new EmptyItemModel()));
        }
        consumer.accept((class_2960)GuiTextures.LEFT_SHIFTED_3_BARS.method_58694(class_9334.field_54199), new ItemAsset((ItemModel)new CompositeItemModel(list), new ItemAsset.Properties(false, true)));
    }

    private static void createNumberButtons(BiConsumer<String, byte[]> assetWriter) {
        BufferedImage empty = ResourceUtils.getTexture(ModInit.id("sgui/elements/numbered_buttons/empty"));
        for (int i = 0; i < 100; ++i) {
            final BufferedImage out = new BufferedImage(empty.getWidth(), empty.getHeight(), empty.getType());
            for (int x = 0; x < out.getWidth(); ++x) {
                for (int y = 0; y < out.getHeight(); ++y) {
                    out.setRGB(x, y, empty.getRGB(x, y));
                }
            }
            var proxy = new DrawableCanvas(){

                public byte getRaw(int x, int y) {
                    if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
                        return 0;
                    }
                    return CanvasUtils.findClosestRawColorARGB((int)out.getRGB(x, y));
                }

                public void setRaw(int x, int y, byte b) {
                    if (x < 0 || y < 0 || x >= this.getWidth() || y >= this.getHeight()) {
                        return;
                    }
                    CanvasColor color = CanvasColor.getFromRaw((byte)b);
                    int rgb = 0;
                    if (color == CanvasColor.WHITE_HIGH) {
                        rgb = -1;
                    } else if (color == CanvasColor.WHITE_LOW) {
                        rgb = -14540254;
                    }
                    out.setRGB(x, y, rgb);
                }

                public int getHeight() {
                    return out.getHeight();
                }

                public int getWidth() {
                    return out.getWidth();
                }
            };
            String text = String.valueOf(i);
            int width = DefaultFonts.VANILLA.getTextWidth(text, 8.0);
            DefaultFonts.VANILLA.drawText(proxy, text, proxy.getWidth() / 2 - width / 2 - 1, 4, 8.0, CanvasColor.WHITE_HIGH);
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)out, "png", buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            assetWriter.accept("assets/polyfactory/textures/sgui/elements/numbered_buttons/num_" + i + ".png", buf.toByteArray());
        }
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        BiConsumer<String, byte[]> assetWriter = (path, data) -> {
            try {
                writer.method_43346(this.output.method_45971().resolve((String)path), data, HashCode.fromBytes((byte[])data));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        };
        return CompletableFuture.runAsync(() -> AssetProvider.runWriters(assetWriter), (Executor)class_156.method_18349());
    }

    public String method_10321() {
        return "polyfactory:assets";
    }

    private static class MoldTextures {
        BufferedImage steelBase = ResourceUtils.getTexture(ModInit.id("item/mold/template/template"));
        BufferedImage steelBorder = ResourceUtils.getTexture(ModInit.id("item/mold/template/template_border"));
        BufferedImage clayBase = ResourceUtils.getTexture(ModInit.id("item/mold/template/template_clay"));
        BufferedImage clayBorder = ResourceUtils.getTexture(ModInit.id("item/mold/template/template_clay_border"));
        BufferedImage hardenedBase = ResourceUtils.getTexture(ModInit.id("item/mold/template/template_hardened"));
        BufferedImage hardenedBorder = ResourceUtils.getTexture(ModInit.id("item/mold/template/template_hardened_border"));

        private MoldTextures() {
        }
    }
}

