/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.entity.splash;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polyfactory.entity.FluidDataOwner;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.mixin.ProjectileEntityAccessor;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3966;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class SplashEntity<T>
extends class_1676
implements PolymerEntity,
FluidDataOwner<T> {
    private final FluidType<T> fluid;
    private T data;
    protected int existenceTime = 5;
    @Nullable
    private GameProfile profile;

    public SplashEntity(class_1299<? extends class_1676> entityType, class_1937 world, FluidType<T> fluidInstance) {
        super(entityType, world);
        this.fluid = fluidInstance;
        this.data = fluidInstance.defaultData();
    }

    @Override
    public void setFluidData(T data) {
        this.data = data;
    }

    @Override
    public T getFluidData() {
        return this.data;
    }

    @Override
    public FluidType<T> fluidType() {
        return this.fluid;
    }

    protected class_2561 method_23315() {
        return class_2561.method_43469((String)"entity.polyfactory.splash", (Object[])new Object[]{this.fluid.getName(this.getFluidData())});
    }

    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.data != this.fluid.defaultData()) {
            nbt.method_10566("fluid_data", (class_2520)this.fluid.dataCodec().encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), this.data).getOrThrow());
        }
    }

    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.data = nbt.method_10545("fluid_data") ? this.fluid.dataCodec().decode((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10580("fluid_data")).result().map(Pair::getFirst).orElse(this.fluid.defaultData()) : this.fluid.defaultData();
    }

    public class_2394 getBaseParticle() {
        return this.fluid.toInstance(this.data).particle();
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    protected void method_7488(class_239 hitResult) {
        class_3966 entityHitResult;
        super.method_7488(hitResult);
        if (!(hitResult.method_17783() == class_239.class_240.field_1333 || hitResult instanceof class_3966 && (entityHitResult = (class_3966)hitResult).method_17782() == this.method_24921())) {
            this.spawnDestructionParticles(hitResult.method_17784());
            this.method_31472();
        }
    }

    protected void spawnDestructionParticles(class_243 pos) {
        ((class_3218)this.method_37908()).method_65096(this.getBaseParticle(), pos.field_1352, pos.field_1351, pos.field_1350, 5, 0.0, 0.0, 0.0, this.getParticleCollisionSpeed());
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (entityHitResult.method_17782() == this.method_24921() || !this.canInteractEntity(entityHitResult.method_17782())) {
            return;
        }
        class_243 velocity = this.method_18798().method_1021(0.004);
        FactoryUtil.addSafeVelocity(entityHitResult.method_17782(), velocity);
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            FactoryUtil.sendVelocityDelta(player, velocity);
        }
    }

    public void method_5773() {
        class_239 hitResult;
        super.method_5773();
        if (this.discardInBlock(this.method_55667(), this.method_24515())) {
            this.method_31472();
        }
        if ((hitResult = class_1675.method_49997((class_1297)this, this::method_26958)).method_17783() != class_239.class_240.field_1333) {
            this.method_59860(hitResult);
        }
        this.method_26962();
        if (this.method_5805()) {
            this.spawnExistenceParticles();
            this.method_5784(class_1313.field_6308, this.method_18798());
        }
        if (this.field_6012 > this.existenceTime) {
            this.onNaturalDiscard();
            this.method_31472();
            return;
        }
        this.method_18799(this.method_18798().method_1021(0.99));
        this.method_56990();
    }

    protected void onNaturalDiscard() {
    }

    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        super.modifyRawTrackedData(data, player, initial);
        if (initial) {
            data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.TELEPORTATION_DURATION, (Object)2));
            if (!this.forceParticles()) {
                data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.BILLBOARD, (Object)((byte)class_8113.class_8114.field_42409.ordinal())));
                if (this.fluid.brightness().isPresent()) {
                    data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.BRIGHTNESS, (Object)this.fluid.brightness().get().method_48763()));
                }
                data.add(class_2945.class_7834.method_46360((class_2940)DisplayTrackedData.Item.ITEM, (Object)this.getParticleItem()));
            }
        }
    }

    protected class_1799 getParticleItem() {
        return FactoryModels.FLUID_PARTICLE.get(this.fluid, this.data);
    }

    protected boolean forceParticles() {
        return true;
    }

    protected void spawnExistenceParticles() {
        if (this.forceParticles() && this.field_6012 % 2 == 1) {
            class_243 velocity = this.method_18798();
            ((class_3218)this.method_37908()).method_65096(this.getBaseParticle(), this.method_23317(), this.method_23318(), this.method_23321(), 0, velocity.method_10216(), velocity.method_10214(), velocity.method_10215(), this.getParticleSpeed());
        }
    }

    protected boolean discardInBlock(class_2680 state, class_2338 blockPos) {
        if (state.method_26227().method_15767(class_3486.field_15518)) {
            ((class_3218)this.method_37908()).method_65096((class_2394)class_2398.field_11237, this.method_23317(), this.method_23318(), this.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
            this.method_36975();
        }
        return !state.method_26227().method_15769();
    }

    protected double getParticleSpeed() {
        return 0.48;
    }

    protected double getParticleCollisionSpeed() {
        return 0.005;
    }

    protected double method_7490() {
        return 0.01;
    }

    public boolean method_5822(boolean allowVehicles) {
        return true;
    }

    protected boolean method_26958(class_1297 entity) {
        return super.method_26958(entity) && !(entity instanceof SplashEntity);
    }

    public class_1299<?> getPolymerEntityType(PacketContext player) {
        return class_1299.field_42456;
    }

    protected class_3414 method_5625() {
        return class_3417.field_42593;
    }

    protected class_3414 method_5672() {
        return class_3417.field_42593;
    }

    protected GameProfile getProfile() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.profile = player.method_7334();
        } else if (this.profile == null) {
            UUID x = ((ProjectileEntityAccessor)((Object)this)).getOwnerUuid();
            this.profile = new GameProfile(x != null ? x : this.method_5667(), "Splash");
        }
        return this.profile;
    }

    protected boolean canDamageEntity(class_1297 entity) {
        class_1657 player;
        class_1297 class_12972;
        return CommonProtection.canDamageEntity((class_1937)this.method_37908(), (class_1297)entity, (GameProfile)this.getProfile(), (class_12972 = this.method_24921()) instanceof class_1657 ? (player = (class_1657)class_12972) : null);
    }

    protected boolean canInteractEntity(class_1297 entity) {
        class_1657 player;
        class_1297 class_12972;
        return CommonProtection.canInteractEntity((class_1937)this.method_37908(), (class_1297)entity, (GameProfile)this.getProfile(), (class_12972 = this.method_24921()) instanceof class_1657 ? (player = (class_1657)class_12972) : null);
    }

    protected boolean canBreakBlock(class_2338 pos) {
        class_1657 player;
        class_1297 class_12972;
        return CommonProtection.canBreakBlock((class_1937)this.method_37908(), (class_2338)pos, (GameProfile)this.getProfile(), (class_12972 = this.method_24921()) instanceof class_1657 ? (player = (class_1657)class_12972) : null);
    }

    protected boolean canPlaceBlock(class_2338 pos) {
        class_1657 player;
        class_1297 class_12972;
        return CommonProtection.canPlaceBlock((class_1937)this.method_37908(), (class_2338)pos, (GameProfile)this.getProfile(), (class_12972 = this.method_24921()) instanceof class_1657 ? (player = (class_1657)class_12972) : null);
    }
}

