/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.fluid;

import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidInteractionMode;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.item.tool.UniversalFluidContainerItem;
import eu.pb4.polyfactory.mixin.ServerRecipeManagerAccessor;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.recipe.fluid.FluidInteractionRecipe;
import eu.pb4.polyfactory.recipe.input.DrainInput;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1703;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public interface FluidContainerUtil {
    public static void tick(FluidContainer container, class_3218 world, class_2338 pos, float temperature, Consumer<class_1799> stack) {
        FluidContainerUtil.tick(container, world, class_243.method_24953((class_2382)pos), temperature, stack);
    }

    public static void tick(FluidContainer container, class_3218 world, class_243 pos, float temperature, Consumer<class_1799> stackConsumer) {
        Object object;
        FluidContainerInput input = FluidContainerInput.of(container, temperature);
        class_5819 random = world.field_9229;
        ArrayList<class_3545> list = new ArrayList<class_3545>();
        for (class_8786 entry : ((ServerRecipeManagerAccessor)world.method_64577()).getPreparedRecipes().method_64698(FactoryRecipeTypes.FLUID_INTERACTION)) {
            FluidInteractionRecipe recipe = (FluidInteractionRecipe)entry.comp_1933();
            if (!((FluidInteractionRecipe)entry.comp_1933()).method_8115(input, (class_1937)world)) continue;
            if (recipe.particleChance(input) < random.method_43057()) {
                class_6880<class_3414> sound;
                class_2394 particle = recipe.particle(input, random);
                if (particle != null) {
                    world.method_65096(particle, pos.method_10216(), pos.method_10214(), pos.method_10215(), 0, 0.1, 0.1, 0.1, 0.1);
                }
                if ((sound = recipe.soundEvent(input, random)) != null) {
                    world.method_60511(null, pos.method_10216(), pos.method_10214(), pos.method_10215(), sound, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            List<FluidInputStack> inputFluids = recipe.fluidInput(input, (class_7225.class_7874)world.method_30349());
            List<FluidStack<?>> outputFluids = recipe.fluidOutput(input, (class_7225.class_7874)world.method_30349());
            List<OutputStack> outputItems = recipe.itemOutput(input, (class_7225.class_7874)world.method_30349());
            ArrayList<class_1799> item = new ArrayList<class_1799>();
            for (int i = 0; i < recipe.maxApplyPerTick(); ++i) {
                for (FluidInputStack fluidInputStack : inputFluids) {
                    container.extract(fluidInputStack.instance(), fluidInputStack.used(), false);
                }
                for (FluidStack fluidStack : outputFluids) {
                    container.insert(fluidStack, false);
                }
                for (OutputStack outputStack : outputItems) {
                    for (int r = 0; r < outputStack.roll(); ++r) {
                        if (!(outputStack.chance() < random.method_43057())) continue;
                        item.add(outputStack.stack());
                        stackConsumer.accept(outputStack.stack().method_7972());
                    }
                }
                if (!recipe.method_8115(input, (class_1937)world)) break;
            }
            list.add(new class_3545((Object)entry.comp_1932(), item));
        }
        if (!list.isEmpty() && (object = FactoryUtil.getClosestPlayer((class_1937)world, class_2338.method_49638((class_2374)pos), 16.0)) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)object;
            for (class_3545 entry : list) {
                class_174.field_44587.method_51350(serverPlayer, (class_5321)entry.method_15442(), (List)entry.method_15441());
            }
        }
    }

    public static class_1799 interactWith(FluidContainer container, class_3222 player, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof UniversalFluidContainerItem) {
            UniversalFluidContainerItem item = (UniversalFluidContainerItem)class_17922;
            FluidInteractionMode mode = (FluidInteractionMode)((Object)stack.method_58695(FactoryDataComponents.FLUID_INTERACTION_MODE, (Object)FluidInteractionMode.EXTRACT));
            FluidComponent fluids = (FluidComponent)stack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
            FluidInstance<?> topFluid = container.topFluid();
            if (mode == FluidInteractionMode.EXTRACT && topFluid != null) {
                long maxAmount = item.capacity() - fluids.stored();
                long extract = container.extract(topFluid, maxAmount, false);
                stack.method_57379(FactoryDataComponents.FLUID, (Object)fluids.insert(topFluid, extract, false).component());
            } else if (mode == FluidInteractionMode.INSERT) {
                for (FluidInstance<?> fluid : fluids.fluids()) {
                    long extract;
                    long leftover = container.insert(fluid, extract = fluids.get(fluid), false);
                    if (leftover == extract) continue;
                    stack.method_57379(FactoryDataComponents.FLUID, (Object)fluids.with(fluid, leftover));
                    break;
                }
            }
            return class_1799.field_8037;
        }
        class_1799 copy = stack.method_7972();
        DrainInput input = DrainInput.of(copy, class_1799.field_8037, container, !(player instanceof FakePlayer));
        Optional optional = player.method_51469().method_64577().method_8132(FactoryRecipeTypes.DRAIN, (class_9695)input, player.method_37908());
        if (optional.isEmpty()) {
            return null;
        }
        DrainRecipe recipe = (DrainRecipe)((class_8786)optional.get()).comp_1933();
        class_1799 itemOut = recipe.method_8116(input, (class_7225.class_7874)player.method_56673());
        for (FluidStack<?> fluid : recipe.fluidInput(input)) {
            container.extract(fluid, false);
        }
        stack.method_57008(1, (class_1309)player);
        for (FluidStack<?> fluid : recipe.fluidOutput(input)) {
            container.insert(fluid, false);
        }
        player.method_17356((class_3414)recipe.soundEvent().comp_349(), class_3419.field_15245, 0.5f, 1.0f);
        return itemOut;
    }

    public static GuiElementInterface guiElement(final @Nullable FluidContainer container, final boolean interactable) {
        if (container == null) {
            return GuiElement.EMPTY;
        }
        return new GuiElementInterface(){

            public GuiElementInterface.ClickCallback getGuiCallback() {
                return interactable ? (index, type, action, gui) -> {
                    class_1703 handler = gui.getPlayer().field_7512;
                    class_1799 out = FluidContainerUtil.interactWith(container, gui.getPlayer(), handler.method_34255());
                    if (out == null) {
                        return;
                    }
                    if (handler.method_34255().method_7960()) {
                        handler.method_34254(out);
                    } else if (!out.method_7960()) {
                        if (gui.getPlayer().method_68878()) {
                            if (!gui.getPlayer().method_31548().method_7379(out)) {
                                gui.getPlayer().method_31548().method_7394(out);
                            }
                        } else {
                            gui.getPlayer().method_31548().method_7398(out);
                        }
                    }
                } : GuiElementInterface.EMPTY_CALLBACK;
            }

            public class_1799 getItemStack() {
                GuiElementBuilder b = GuiTextures.EMPTY_BUILDER.get().setName((class_2561)class_2561.method_43473().method_10852((class_2561)FactoryUtil.fluidTextGeneric(container.stored())).method_27693(" / ").method_10852((class_2561)FactoryUtil.fluidTextGeneric(container.capacity())));
                container.forEachReversed((type, amount) -> b.addLoreLine((class_2561)type.toLabeledAmount((long)amount).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false)))));
                return b.asStack();
            }
        };
    }
}

