/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.configuration;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.configuration.ClipboardData;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.ServerPlayNetExt;
import eu.pb4.sidebars.api.Sidebar;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_9020;
import net.minecraft.class_9022;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class WrenchHandler {
    private final Sidebar sidebar = new Sidebar(Sidebar.Priority.HIGH);
    private final Map<class_2248, String> currentAction = new Reference2ObjectOpenHashMap();
    private class_2680 state = class_2246.field_10124.method_9564();
    @Nullable
    private class_2338 pos;
    private List<BlockConfig<?>> actions = List.of();
    private class_1799 currentStack = class_1799.field_8037;

    public WrenchHandler(class_3244 handler) {
        this.sidebar.addPlayer(handler);
        this.sidebar.setDefaultNumberFormat((class_9022)class_9020.field_47557);
    }

    public static WrenchHandler of(class_3222 player) {
        return ((ServerPlayNetExt)player.field_13987).polyFactory$getWrenchHandler();
    }

    public void tickDisplay(class_3222 player) {
        class_239 class_2393;
        class_1799 stack = class_1799.field_8037;
        if (player.method_6047().method_31574((class_1792)FactoryItems.WRENCH) || player.method_6047().method_31574(FactoryItems.CLIPBOARD)) {
            stack = player.method_6047();
        } else if (player.method_6079().method_31574((class_1792)FactoryItems.WRENCH) || player.method_6079().method_31574(FactoryItems.CLIPBOARD)) {
            stack = player.method_6079();
        }
        boolean isWrench = stack.method_31574((class_1792)FactoryItems.WRENCH);
        if (!stack.method_7960() && (class_2393 = player.method_5745(7.0, 0.0f, false)) instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2393;
            class_2680 state = player.method_37908().method_8320(blockHitResult.method_17777());
            if (state == this.state && blockHitResult.method_17777().equals((Object)this.pos) && class_1799.method_31577((class_1799)stack, (class_1799)this.currentStack)) {
                class_2248 class_22482 = this.state.method_26204();
                if (class_22482 instanceof ConfigurableBlock) {
                    ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
                    if (isWrench) {
                        configurableBlock.wrenchTick(player, blockHitResult, this.state);
                    }
                }
                return;
            }
            this.currentStack = stack.method_7972();
            this.state = state;
            this.pos = blockHitResult.method_17777();
            class_2248 class_22483 = this.state.method_26204();
            if (class_22483 instanceof ConfigurableBlock) {
                ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22483;
                if (isWrench) {
                    configurableBlock.wrenchTick(player, blockHitResult, this.state);
                }
                this.actions = configurableBlock.getBlockConfiguration(player, blockHitResult.method_17777(), blockHitResult.method_17780(), this.state);
                String selected = this.currentAction.get(this.state.method_26204());
                HashMap<String, Object> diffMap = new HashMap<String, Object>();
                if (stack.method_57826(FactoryDataComponents.CLIPBOARD_DATA)) {
                    for (BlockConfig<?> config : this.actions) {
                        for (ClipboardData.Entry entry : ((ClipboardData)stack.method_58695(FactoryDataComponents.CLIPBOARD_DATA, (Object)ClipboardData.EMPTY)).entries()) {
                            DataResult decoded;
                            if (!config.id().equals(entry.id()) || !(decoded = config.codec().decode((DynamicOps)JavaOps.INSTANCE, entry.value())).isSuccess()) continue;
                            diffMap.put(config.id(), ((Pair)decoded.getOrThrow()).getFirst());
                        }
                    }
                }
                this.sidebar.setTitle((class_2561)class_2561.method_43469((String)"item.polyfactory.wrench.title", (Object[])new Object[]{class_2561.method_43473()}).method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10982(Boolean.valueOf(true))));
                try {
                    this.sidebar.set(b -> {
                        int size = Math.min(this.actions.size(), 15);
                        for (int i = 0; i < size; ++i) {
                            BlockConfig<?> action = this.actions.get(i);
                            class_5250 t = class_2561.method_43473();
                            if (isWrench) {
                                if (selected == null && i == 0 || action.id().equals(selected)) {
                                    t.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(GuiTextures.SPACE_1)).method_10862(UiResourceCreator.STYLE));
                                    t.method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                                } else {
                                    t.method_27693("   ");
                                }
                            }
                            t.method_10852(action.name()).method_27693(": ");
                            Object value = action.value().getValue(player.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                            class_2561 valueFrom = action.formatter().getDisplayValue(value, player.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                            if (isWrench) {
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_27692(class_124.field_1054));
                                continue;
                            }
                            if (diffMap.containsKey(action.id()) && !Objects.equals(diffMap.get(action.id()), value)) {
                                class_2561 diff = action.formatter().getDisplayValue(diffMap.get(action.id()), player.method_37908(), blockHitResult.method_17777(), blockHitResult.method_17780(), state);
                                b.add((class_2561)t, (class_2561)class_2561.method_43473().method_10852(valueFrom).method_10852((class_2561)class_2561.method_43470((String)" -> ").method_27692(class_124.field_1065)).method_10852(diff).method_27692(class_124.field_1054));
                                continue;
                            }
                            b.add((class_2561)t.method_27692(class_124.field_1080), (class_2561)class_2561.method_43473().method_10852(valueFrom).method_54663(class_9848.method_61321((int)class_124.field_1054.method_532(), (float)0.7f)));
                        }
                    });
                }
                catch (Throwable e) {
                    ModInit.LOGGER.error("Failed to create wrench display!", e);
                }
                this.sidebar.show();
            } else {
                this.actions = List.of();
                this.sidebar.hide();
            }
        } else {
            this.state = class_2246.field_10124.method_9564();
            this.pos = null;
            this.sidebar.hide();
        }
    }

    public class_1269 useAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side, boolean alt) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ConfigurableBlock)) {
            return class_1269.field_5811;
        }
        ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
        List<BlockConfig<?>> actions = configurableBlock.getBlockConfiguration(player, pos, side, this.state);
        if (actions.isEmpty()) {
            return class_1269.field_5811;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.get(0).id();
        }
        for (BlockConfig<?> act : actions) {
            BlockConfig<?> action = act;
            if (!action.id().equals(current)) continue;
            Object newValue = (alt ? action.alt() : action.action()).modifyValue(action.value().getValue(world, pos, side, state), !player.method_5715(), (class_1657)player, world, pos, side, state);
            if (action.value().setValue(newValue, world, pos, side, state)) {
                this.pos = null;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.WRENCH);
                player.method_17356(FactorySoundEvents.ITEM_WRENCH_USE, class_3419.field_15248, 0.3f, player.method_59922().method_43057() * 0.1f + 0.95f);
                return class_1269.field_52422;
            }
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public void attackAction(class_3222 player, class_1937 world, class_2338 pos, class_2350 side) {
        class_2680 state = world.method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ConfigurableBlock)) {
            return;
        }
        ConfigurableBlock configurableBlock = (ConfigurableBlock)class_22482;
        List<BlockConfig<?>> actions = configurableBlock.getBlockConfiguration(player, pos, side, this.state);
        if (actions.isEmpty()) {
            return;
        }
        String current = this.currentAction.get(state.method_26204());
        if (current == null) {
            current = actions.getFirst().id();
        }
        boolean foundCurrent = false;
        String nextAction = actions.getFirst().id();
        String previousAction = actions.getLast().id();
        for (BlockConfig<?> action : actions) {
            if (foundCurrent) {
                nextAction = action.id();
                break;
            }
            if (action.id().equals(current)) {
                foundCurrent = true;
                continue;
            }
            previousAction = action.id();
        }
        if (foundCurrent) {
            this.currentAction.put(state.method_26204(), player.method_5715() ? previousAction : nextAction);
            player.method_17356(FactorySoundEvents.ITEM_WRENCH_SWITCH, class_3419.field_15248, 0.3f, 1.0f);
            this.pos = null;
        }
    }
}

