/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.tool;

import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.tool.AbstractFilterItem;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.GuiUtils;
import eu.pb4.polyfactory.util.filter.ExactItemFilter;
import eu.pb4.polyfactory.util.filter.FilterData;
import eu.pb4.polyfactory.util.filter.ItemFilter;
import eu.pb4.polyfactory.util.filter.OneOfItemFilter;
import eu.pb4.polyfactory.util.filter.TypeItemFilter;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.GuiHelpers;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_7708;
import net.minecraft.class_9331;

public class ImprovedFilterItem
extends AbstractFilterItem {
    public ImprovedFilterItem(class_1792.class_1793 settings) {
        super(settings.method_57349(FactoryDataComponents.ITEM_FILTER_TYPE, (Object)Type.WHITELIST).method_57349(FactoryDataComponents.ITEM_FILTER_MATCH, (Object)Match.STRICT));
    }

    @Override
    public void openConfiguration(class_3222 player, class_1799 stack) {
        new Gui(player, stack);
    }

    public class_2561 method_7864(class_1799 stack) {
        List<class_1799> stacks = ImprovedFilterItem.getStacks(stack);
        if (stacks.isEmpty()) {
            return class_2561.method_43471((String)(this.method_7876() + ".empty"));
        }
        return class_2561.method_43469((String)(this.method_7876() + ".with"), (Object[])new Object[]{stacks.size() == 1 ? stacks.getFirst().method_7964() : class_2561.method_43473().method_10852(stacks.getFirst().method_7964()).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)"item.container.more_items", (Object[])new Object[]{stacks.size() - 1}))});
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> tooltip, class_1836 type) {
        super.method_67187(stack, context, displayComponent, tooltip, type);
        tooltip.accept((class_2561)((Match)((Object)stack.method_58695(FactoryDataComponents.ITEM_FILTER_MATCH, (Object)Match.STRICT))).asName().method_27692(class_124.field_1054));
        tooltip.accept((class_2561)((Type)((Object)stack.method_58695(FactoryDataComponents.ITEM_FILTER_TYPE, (Object)Type.WHITELIST))).asTooltip());
        for (class_1799 filtered : ImprovedFilterItem.getStacks(stack)) {
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852(filtered.method_7964()).method_27692(class_124.field_1080));
        }
    }

    public static List<class_1799> getStacks(class_1799 stack) {
        return (List)stack.method_58695(FactoryDataComponents.ITEM_FILTER, List.of());
    }

    @Override
    public boolean isFilterSet(class_1799 stack) {
        return !((List)stack.method_58695(FactoryDataComponents.ITEM_FILTER, List.of())).isEmpty();
    }

    @Override
    public FilterData createFilterData(class_1799 stack) {
        List data = (List)stack.method_58695(FactoryDataComponents.ITEM_FILTER, List.of());
        ArrayList<ItemFilter> list = new ArrayList<ItemFilter>(data.size());
        if (stack.method_58694(FactoryDataComponents.ITEM_FILTER_MATCH) == Match.STRICT) {
            for (class_1799 filter : data) {
                list.add(new ExactItemFilter(filter));
            }
        } else {
            for (class_1799 filter : data) {
                list.add(new TypeItemFilter(filter.method_7909()));
            }
        }
        boolean matchValue = stack.method_58694(FactoryDataComponents.ITEM_FILTER_TYPE) == Type.WHITELIST;
        return new FilterData(new OneOfItemFilter(list, matchValue), data, !matchValue);
    }

    public static enum Type implements class_3542
    {
        WHITELIST("whitelist", class_124.field_1060, GuiTextures.BUTTON_DONE),
        BLACKLIST("blacklist", class_124.field_1061, GuiTextures.BUTTON_CLOSE);

        private final String name;
        private final class_124 formatting;
        private final Supplier<GuiElementBuilder> button;

        private Type(String name, class_124 formatting, Supplier<GuiElementBuilder> button) {
            this.name = name;
            this.formatting = formatting;
            this.button = button;
        }

        public String method_15434() {
            return this.name;
        }

        public GuiElementBuilder createButton() {
            return this.button.get().setName((class_2561)this.asName()).addLoreLine((class_2561)this.asDescription().method_27692(class_124.field_1080));
        }

        public class_5250 asName() {
            return class_2561.method_43471((String)("item.polyfactory.item_filter.type." + this.name));
        }

        public class_5250 asDescription() {
            return class_2561.method_43471((String)("item.polyfactory.item_filter.type." + this.name + ".desc"));
        }

        public class_5250 asTooltip() {
            return class_2561.method_43471((String)("item.polyfactory.item_filter.type." + this.name + ".tooltip")).method_27692(this.formatting);
        }
    }

    public static enum Match implements class_3542
    {
        STRICT("strict", GuiTextures.BUTTON_ITEM_FILTER_STRICT),
        TYPE_ONLY("type_only", GuiTextures.BUTTON_ITEM_FILTER_TYPE_ONLY);

        private final String name;
        private final Supplier<GuiElementBuilder> button;

        private Match(String name, Supplier<GuiElementBuilder> button) {
            this.name = name;
            this.button = button;
        }

        public GuiElementBuilder createButton() {
            return this.button.get().setName((class_2561)this.asName()).addLoreLine((class_2561)this.asDescription().method_27692(class_124.field_1080));
        }

        public String method_15434() {
            return this.name;
        }

        public class_5250 asName() {
            return class_2561.method_43471((String)("item.polyfactory.item_filter.match." + this.name));
        }

        public class_5250 asDescription() {
            return class_2561.method_43471((String)("item.polyfactory.item_filter.match." + this.name + ".desc"));
        }
    }

    private static class Gui
    extends SimpleGui {
        private final class_1799 stack;

        public Gui(class_3222 player, final class_1799 stack) {
            super(class_3917.field_17326, player, false);
            this.stack = stack;
            this.setTitle(GuiTextures.ITEM_FILTER.apply((class_2561)class_2561.method_43471((String)stack.method_7909().method_7876())));
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    final int i = x + y * 3;
                    this.setSlot(x + 2 + y * 9, new GuiElementInterface(){

                        public class_1799 getItemStack() {
                            boolean strict = stack.method_58694(FactoryDataComponents.ITEM_FILTER_MATCH) == Match.STRICT;
                            List<class_1799> stacks = ImprovedFilterItem.getStacks(stack);
                            if (i < stacks.size()) {
                                return strict ? stacks.get(i).method_7972() : stacks.get(i).method_7909().method_7854();
                            }
                            return class_1799.field_8037;
                        }

                        public GuiElementInterface.ClickCallback getGuiCallback() {
                            return (a, b, c, d) -> this.onSetSlot(i, b);
                        }
                    });
                }
            }
            this.setSlot(6, this.createButton(FactoryDataComponents.ITEM_FILTER_MATCH, Match.values(), Match::createButton));
            this.setSlot(24, this.createButton(FactoryDataComponents.ITEM_FILTER_TYPE, Type.values(), Type::createButton));
            this.open();
        }

        private <T extends Enum<T>> GuiElementInterface createButton(class_9331<T> type, T[] values, final Function<T, GuiElementBuilder> builderFunction) {
            return new GuiElementInterface(){
                final /* synthetic */ class_9331 val$type;
                final /* synthetic */ Enum[] val$values;
                {
                    this.val$type = class_93312;
                    this.val$values = enumArray;
                }

                public class_1799 getItemStack() {
                    return ((GuiElementBuilder)builderFunction.apply((Enum)stack.method_58695(this.val$type, (Object)this.val$values[0]))).asStack();
                }

                public GuiElementInterface.ClickCallback getGuiCallback() {
                    return (i, clickType, slotActionType, slotGuiInterface) -> {
                        GuiUtils.playClickSound(player);
                        stack.method_57379(this.val$type, (Object)this.val$values[(((Enum)stack.method_58695(this.val$type, (Object)this.val$values[0])).ordinal() + 1) % this.val$values.length]);
                    };
                }
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void onSetSlot(int i, ClickType type) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>(ImprovedFilterItem.getStacks(this.stack));
            if (this.screenHandler.method_34255().method_7960()) {
                if (i >= stacks.size()) return;
                stacks.remove(i);
            } else if (i < stacks.size()) {
                stacks.set(i, this.screenHandler.method_34255().method_46651(1));
            } else {
                stacks.add(this.screenHandler.method_34255().method_46651(1));
            }
            Set dedupe = class_7708.method_47572();
            dedupe.addAll(stacks);
            stacks.clear();
            stacks.addAll(dedupe);
            this.stack.method_57379(FactoryDataComponents.ITEM_FILTER, stacks);
            GuiUtils.playClickSound(this.player);
        }

        public boolean onAnyClick(int index, ClickType type, class_1713 action) {
            if (index == -999 || index == -1) {
                return true;
            }
            ArrayList<class_1799> stacks = new ArrayList<class_1799>(ImprovedFilterItem.getStacks(this.stack));
            if (stacks.size() < 9 && type.shift && index > this.getVirtualSize()) {
                stacks.add(this.screenHandler.method_7611(index).method_7677().method_46651(1));
                Set dedupe = class_7708.method_47572();
                dedupe.addAll(stacks);
                stacks.clear();
                stacks.addAll(dedupe);
                this.stack.method_57379(FactoryDataComponents.ITEM_FILTER, stacks);
                GuiUtils.playClickSound(this.player);
            }
            if (this.screenHandler.method_7611(index).method_7677() == this.stack) {
                GuiHelpers.sendSlotUpdate((class_3222)this.player, (int)this.screenHandler.field_7763, (int)index, (class_1799)this.stack, (int)0);
                return false;
            }
            return super.onAnyClick(index, type, action);
        }
    }
}

