/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.item.tool;

import eu.pb4.polyfactory.advancement.FluidShootsCriterion;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerFromComponent;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.shooting.EntityShooterContext;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.core.api.item.PolymerItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2744;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5630;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class PressureFluidGun
extends class_1792
implements PolymerItem {
    public PressureFluidGun(class_1792.class_1793 settings) {
        super(settings);
    }

    public static boolean isUsable(class_1799 stack) {
        return stack.method_7919() < stack.method_7936() - 1;
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
        class_1309 livingEntity;
        super.method_7888(stack, world, entity, slot);
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6030() != stack) {
            this.method_7840(stack, (class_1937)world, livingEntity, 0);
        }
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        FluidInstance fluid = (FluidInstance)stack.method_58694(FactoryDataComponents.CURRENT_FLUID);
        if (fluid != null) {
            fluid.shootingBehavior().stopShooting(new EntityShooterContext(user), fluid);
            stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
        }
        return false;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        FluidInstance fluid = (FluidInstance)stack.method_58694(FactoryDataComponents.CURRENT_FLUID);
        if (fluid == null) {
            return;
        }
        EntityShooterContext ctx = new EntityShooterContext(user);
        List<FluidContainer> containers = this.findFluidContainer(user);
        if (containers.isEmpty() || !PressureFluidGun.isUsable(stack)) {
            fluid.shootingBehavior().stopShooting(ctx, fluid);
            stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
            return;
        }
        for (FluidContainer container : containers) {
            if (!fluid.shootingBehavior().canShoot(ctx, fluid, container)) continue;
            fluid.shootingBehavior().continueShooting(ctx, fluid, -remainingUseTicks, container);
            if (remainingUseTicks % 20 == 0) {
                stack.method_7970(1, user, user.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            }
            class_243 vec = ctx.rotation().method_1021(user.method_24828() ? -0.002 : -0.05);
            FactoryUtil.addSafeVelocity((class_1297)user, vec);
            if (user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                FactoryUtil.sendVelocityDelta(player, vec);
            }
            return;
        }
        fluid.shootingBehavior().stopShooting(ctx, fluid);
        stack.method_57381(FactoryDataComponents.CURRENT_FLUID);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (stack.method_57826(FactoryDataComponents.CURRENT_FLUID)) {
            return class_1269.field_21466;
        }
        List<FluidContainer> containers = this.findFluidContainer((class_1309)user);
        if (containers.isEmpty() || !PressureFluidGun.isUsable(stack)) {
            return class_1269.field_5814;
        }
        EntityShooterContext ctx = new EntityShooterContext((class_1309)user);
        for (FluidContainer container : containers) {
            for (FluidInstance<?> f : container.fluids()) {
                if (!f.shootingBehavior().canShoot(ctx, f, container)) continue;
                stack.method_57379(FactoryDataComponents.CURRENT_FLUID, f);
                user.method_6019(hand);
                f.shootingBehavior().startShooting(ctx, f, container);
                class_243 vec = ctx.rotation().method_1021(user.method_24828() ? -0.01 : -0.07);
                FactoryUtil.addSafeVelocity((class_1297)user, vec);
                if (user instanceof class_3222) {
                    class_3222 player = (class_3222)user;
                    FactoryUtil.sendVelocityDelta(player, vec);
                    FluidShootsCriterion.triggerFluidLauncher(player, stack, f);
                }
                return class_1269.field_21466;
            }
        }
        return class_1269.field_5814;
    }

    private List<FluidContainer> findFluidContainer(class_1309 user) {
        ArrayList<FluidContainer> stacks = new ArrayList<FluidContainer>();
        for (class_1304 eq : class_1304.values()) {
            class_1799 stack = user.method_6118(eq);
            FluidComponent fluid = (FluidComponent)stack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
            if (fluid.isEmpty()) continue;
            stacks.add(FluidContainerFromComponent.of(class_5630.method_32330((class_1309)user, (class_1304)eq)));
        }
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            for (int i = 0; i < player.method_31548().method_67533().size(); ++i) {
                FluidComponent fluid = (FluidComponent)player.method_31548().method_5438(i).method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
                if (fluid.isEmpty()) continue;
                stacks.add(FluidContainerFromComponent.of(class_5630.method_32328((class_1263)player.method_31548(), (int)i)));
            }
        }
        return stacks;
    }

    public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
        class_1799 out = super.getPolymerItemStack(itemStack, tooltipType, context);
        if (this.useCrossbowModel(itemStack)) {
            out.method_57379(class_9334.field_49649, (Object)class_9278.method_57439((class_1799)class_1802.field_8107.method_7854()));
        }
        out.method_57379(class_9334.field_49629, (Object)((Integer)itemStack.method_58694(class_9334.field_49629)));
        return out;
    }

    public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
        if (this.useCrossbowModel(itemStack)) {
            return class_1802.field_8399;
        }
        return class_1802.field_47315;
    }

    private boolean useCrossbowModel(class_1799 itemStack) {
        return this.useActiveModel(itemStack) && PacketContext.get().getEncodedPacket() instanceof class_2744;
    }

    private boolean useActiveModel(class_1799 itemStack) {
        return itemStack.method_57826(FactoryDataComponents.CURRENT_FLUID);
    }
}

