/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.models;

import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.filter.FilterData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_811;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class FilterIcon {
    private final List<ItemDisplayElement> elements = new ArrayList<ItemDisplayElement>();
    private final ElementHolder holder;
    private final Matrix4f transform = new Matrix4f();
    private FilterData filterData = FilterData.EMPTY_TRUE;

    public FilterIcon(ElementHolder holder) {
        this.holder = holder;
    }

    public void setFilter(FilterData data) {
        int i;
        int items;
        this.filterData = data;
        int count = items = data.icon().size();
        if (data.prevent()) {
            count *= 2;
        }
        while (this.elements.size() > count) {
            this.holder.removeElement((VirtualElement)this.elements.removeLast());
        }
        while (this.elements.size() < count) {
            this.elements.add((ItemDisplayElement)this.holder.addElement((VirtualElement)FilterIcon.createDefaultElement()));
        }
        for (i = 0; i < items; ++i) {
            this.elements.get(i).setItem(data.icon().get(i));
        }
        while (i < count) {
            this.elements.get(i).setItem(GuiTextures.ITEM_FILTER_BLOCKED);
            ++i;
        }
        this.applyTransforms();
    }

    private void applyTransforms() {
        int items = this.filterData.icon().size();
        float count = (float)items / 2.0f - 0.5f;
        Matrix4f mat = BlockModel.mat();
        mat.set((Matrix4fc)this.transform);
        if (items > 3) {
            mat.scale(3.0f / (float)items);
        }
        mat.translate(count, 0.0f, 0.0f);
        for (int i = 0; i < items; ++i) {
            this.elements.get(i).setTransformation(mat);
            if (this.filterData.prevent()) {
                mat.translate(0.0f, 0.0f, -1.0f);
                this.elements.get(i + items).setTransformation(mat);
                mat.translate(0.0f, 0.0f, 1.0f);
            }
            mat.translate(-1.0f, 0.0f, 0.0f);
        }
    }

    public void tick() {
        for (ItemDisplayElement element : this.elements) {
            element.tick();
        }
    }

    public void setTransformation(Matrix4fc matrix4fc) {
        this.transform.set(matrix4fc);
        this.applyTransforms();
    }

    public void setYaw(float yaw) {
        for (ItemDisplayElement element : this.elements) {
            element.setYaw(yaw);
        }
    }

    public void setPitch(float pitch) {
        for (ItemDisplayElement element : this.elements) {
            element.setPitch(pitch);
        }
    }

    private static ItemDisplayElement createDefaultElement() {
        ItemDisplayElement element = new ItemDisplayElement();
        element.setDisplaySize(1.0f, 1.0f);
        element.setItemDisplayContext(class_811.field_4317);
        element.setInvisible(true);
        element.setViewRange(0.3f);
        return element;
    }
}

