/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.nodes.mechanical;

import com.kneelawk.graphlib.api.graph.BlockGraph;
import com.kneelawk.graphlib.api.graph.GraphEntityContext;
import com.kneelawk.graphlib.api.graph.GraphView;
import com.kneelawk.graphlib.api.graph.LinkHolder;
import com.kneelawk.graphlib.api.graph.NodeHolder;
import com.kneelawk.graphlib.api.graph.user.BlockNode;
import com.kneelawk.graphlib.api.graph.user.GraphEntity;
import com.kneelawk.graphlib.api.graph.user.GraphEntityType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.other.MachineInfoProvider;
import eu.pb4.polyfactory.nodes.FactoryNodes;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalNode;
import eu.pb4.polyfactory.nodes.mechanical.AxleWithGearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical.GearMechanicalNode;
import eu.pb4.polyfactory.nodes.mechanical_connectors.LargeGearNode;
import eu.pb4.polyfactory.nodes.mechanical_connectors.SmallGearNode;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotationData
implements GraphEntity<RotationData> {
    public static final Codec<RotationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("Rot", (Object)Float.valueOf(0.0f)).forGetter(RotationData::rotation), (App)Codec.FLOAT.optionalFieldOf("RotVal", (Object)Float.valueOf(0.0f)).forGetter(RotationData::rotationValue)).apply((Applicative)instance, RotationData::new));
    public static final GraphEntityType<RotationData> TYPE = GraphEntityType.of((class_2960)ModInit.id("rotation_info"), CODEC, RotationData::new, RotationData::split);
    public static RotationData EMPTY = new RotationData(){

        @Override
        public void update(class_3218 world) {
        }
    };
    protected boolean overstressed = false;
    private double speed;
    private float rotationValue;
    private float rotation;
    private int lastTick = -1;
    private double stressCapacity;
    private double stressUsage;
    private GraphEntityContext ctx;
    private boolean negative;

    public RotationData() {
    }

    public RotationData(float rotation, float rotationValue) {
        this.rotation = rotation;
        this.rotationValue = rotationValue;
    }

    private static void collectGraphs(Collection<NodeHolder<GearMechanicalNode>> connectors, ObjectOpenHashSet<class_2338> checkedNodes, Long2BooleanOpenHashMap dirMap, Long2FloatOpenHashMap speedMap, MutableBoolean clogged, ArrayList<RotationData> data, boolean currentDirection, float speed) {
        for (NodeHolder<GearMechanicalNode> connection : connectors) {
            Optional self;
            Optional connectGraph = Objects.requireNonNull(FactoryNodes.ROTATIONAL_CONNECTOR.getGraphWorld((class_3218)connection.getBlockWorld())).getAllGraphsAt(connection.getBlockPos()).findFirst();
            if (!connectGraph.isPresent() || !(self = ((BlockGraph)connectGraph.get()).getNodesAt(connection.getBlockPos()).findFirst()).isPresent()) continue;
            RotationData.iterateConnectedNodes((NodeHolder<BlockNode>)((NodeHolder)self.get()), connection.getGraphWorld(), checkedNodes, dirMap, speedMap, clogged, data, currentDirection, speed);
        }
    }

    private static void iterateConnectedNodes(NodeHolder<BlockNode> blockNodeNodeHolder, GraphView graphWorld, ObjectOpenHashSet<class_2338> checkedSelf, Long2BooleanOpenHashMap dirMap, Long2FloatOpenHashMap speedMap, MutableBoolean clogged, ArrayList<RotationData> data, boolean currentDirection, float speed) {
        if (!checkedSelf.add((Object)blockNodeNodeHolder.getBlockPos())) {
            return;
        }
        for (LinkHolder conn : blockNodeNodeHolder.getConnections()) {
            Collection subConnectors;
            boolean nextDirection;
            NodeHolder x = conn.other(blockNodeNodeHolder);
            float nextGearSpeed = speed;
            if (blockNodeNodeHolder.getNode().getClass() != x.getNode().getClass()) {
                nextGearSpeed = blockNodeNodeHolder.getNode() instanceof SmallGearNode ? (nextGearSpeed *= 2.0f) : (nextGearSpeed /= 2.0f);
                nextDirection = !currentDirection;
            } else {
                BlockNode blockNode = blockNodeNodeHolder.getNode();
                if (blockNode instanceof LargeGearNode) {
                    LargeGearNode a = (LargeGearNode)blockNode;
                    class_2338 delta = blockNodeNodeHolder.getBlockPos().method_10059((class_2382)x.getBlockPos());
                    nextDirection = delta.method_30558(a.axis()) == delta.method_30558(((LargeGearNode)x.getNode()).axis()) == currentDirection;
                } else {
                    nextDirection = !currentDirection;
                }
            }
            RotationData.iterateConnectedNodes((NodeHolder<BlockNode>)x, graphWorld, checkedSelf, dirMap, speedMap, clogged, data, nextDirection, nextGearSpeed);
            Optional optionalGraph = graphWorld.getAllGraphsAt(x.getBlockPos()).findFirst();
            if (optionalGraph.isEmpty()) {
                return;
            }
            BlockGraph targetGraph = (BlockGraph)optionalGraph.get();
            if (dirMap.containsKey(targetGraph.getId())) {
                if (dirMap.get(targetGraph.getId()) == !nextDirection || !class_3532.method_15347((float)speedMap.get(targetGraph.getId()), (float)nextGearSpeed)) {
                    clogged.setTrue();
                }
            } else {
                dirMap.put(targetGraph.getId(), nextDirection);
                speedMap.put(targetGraph.getId(), nextGearSpeed);
                data.add((RotationData)targetGraph.getGraphEntity(TYPE));
            }
            if ((subConnectors = targetGraph.getCachedNodes(GearMechanicalNode.CACHE)).isEmpty()) continue;
            RotationData.collectGraphs(subConnectors, checkedSelf, dirMap, speedMap, clogged, data, nextDirection, nextGearSpeed);
        }
    }

    public double speed() {
        return this.overstressed ? 0.0 : this.speed;
    }

    public double directSpeed() {
        return this.speed;
    }

    public double stressCapacity() {
        return this.overstressed ? 0.0 : this.stressCapacity;
    }

    public double directStressCapacity() {
        return this.stressCapacity;
    }

    public double stressUsage() {
        return this.overstressed ? 0.0 : this.stressUsage;
    }

    public double directStressUsage() {
        return this.stressUsage;
    }

    public float rotation() {
        return this.rotation;
    }

    public float rotationValue() {
        return this.rotationValue;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void update(class_3218 world) {
        int currentTick = world.method_8503().method_3780();
        if (this.ctx == null || this.lastTick == currentTick) {
            return;
        }
        int delta = this.lastTick == -1 ? 1 : currentTick - this.lastTick;
        this.lastTick = currentTick;
        Collection connectors = this.ctx.getGraph().getCachedNodes(AxleWithGearMechanicalNode.CACHE);
        if (connectors.isEmpty()) {
            this.updateSelf(world, delta);
        } else {
            Long2BooleanOpenHashMap dirMap = new Long2BooleanOpenHashMap();
            Long2FloatOpenHashMap speedMap = new Long2FloatOpenHashMap();
            MutableBoolean clogged = new MutableBoolean();
            ArrayList<RotationData> rotationDataList = new ArrayList<RotationData>();
            ObjectOpenHashSet checkedNodes = new ObjectOpenHashSet();
            RotationData.collectGraphs(connectors, (ObjectOpenHashSet<class_2338>)checkedNodes, dirMap, speedMap, clogged, rotationDataList, false, 1.0f);
            if (rotationDataList.isEmpty()) {
                this.updateSelf(world, delta);
                return;
            }
            for (RotationData data : rotationDataList) {
                data.lastTick = currentTick;
            }
            if (clogged.booleanValue()) {
                for (RotationData rot : rotationDataList) {
                    rot.lastTick = currentTick;
                    rot.overstressed = true;
                    rot.speed = 0.0;
                    rot.stressUsage = 0.0;
                    rot.stressCapacity = 0.0;
                    rot.getContext().getGraph().getNodes().forEach(this::spawnSmoke);
                }
                return;
            }
            Long2DoubleOpenHashMap usage = new Long2DoubleOpenHashMap();
            State state = new State();
            for (RotationData data : rotationDataList) {
                state.flip = dirMap.get(data.getContext().getGraph().getId());
                state.multiplier = speedMap.get(data.getContext().getGraph().getId());
                data.calculateState(world, state);
                usage.put(data.getContext().getGraph().getId(), state.stressUsed);
                state.stressUsed = 0.0;
            }
            double fullStress = 0.0;
            for (RotationData data : rotationDataList) {
                double stress = usage.get(data.getContext().getGraph().getId());
                fullStress += stress / (double)speedMap.get(data.getContext().getGraph().getId());
            }
            TriState negative = state.speed == 0.0 ? TriState.DEFAULT : TriState.of((state.speed < 0.0 ? 1 : 0) != 0);
            state.multiplier = 1.0f;
            state.stressUsed = fullStress;
            float biggest = 1.0f;
            for (RotationData data : rotationDataList) {
                data.negative = negative == TriState.DEFAULT ? data.negative : dirMap.get(data.getContext().getGraph().getId()) != negative.get();
                state.multiplier = speedMap.get(data.getContext().getGraph().getId());
                biggest = Math.max(biggest, state.multiplier);
                data.applyState(state);
                if (!data.overstressed) continue;
                data.getContext().getGraph().getNodes().forEach(this::spawnSmoke);
            }
            if (this.speed == 0.0 || Math.abs(state.stressCapacity) - fullStress < 0.0) {
                return;
            }
            double speed = this.speed;
            if (this.negative) {
                speed = -speed;
            }
            double baseDelta = speed * 0.01745329238474369 * (double)delta;
            float r = Math.abs((float)((baseDelta + (double)this.rotationValue) % (double)((float)Math.PI * 2 * biggest)));
            float rotMax = 0.7853882f * (float)delta;
            for (RotationData data : rotationDataList) {
                float div = speedMap.get(data.getContext().getGraph().getId());
                data.rotationValue = (data.negative ? -r : r) / div;
                if (Math.abs(baseDelta / (double)div) < (double)rotMax) {
                    data.rotation = data.rotationValue;
                    continue;
                }
                data.rotation = (data.rotation + (data.negative ? -rotMax : rotMax)) % ((float)Math.PI * 2);
            }
        }
    }

    private void spawnSmoke(NodeHolder<BlockNode> entry) {
        if (entry.getNode() instanceof FunctionalNode) {
            class_3218 world = (class_3218)this.ctx.getBlockWorld();
            class_2338 pos = entry.getBlockPos();
            world.method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.3, 0.3, 0.3, 0.2);
        }
    }

    private void calculateState(class_3218 world, State state) {
        Collection list = this.ctx.getGraph().getCachedNodes(FunctionalDirectionNode.CACHE);
        if (list.isEmpty()) {
            return;
        }
        for (NodeHolder entries : list) {
            class_2680 blockState = world.method_8320(entries.getBlockPos());
            Object object = ((FunctionalNode)entries.getNode()).getTargetFunctional(world, entries.getBlockPos(), blockState);
            if (!(object instanceof RotationUser)) continue;
            RotationUser rotationalSource = (RotationUser)object;
            rotationalSource.updateRotationalData(state, blockState, world, entries.getBlockPos());
        }
    }

    private void applyState(State state) {
        if (state.providerCount == 0) {
            this.overstressed = false;
            this.stressCapacity = 0.0;
            this.stressUsage = 0.0;
            this.speed = 0.0;
            return;
        }
        this.stressCapacity = Math.abs(state.finalStressCapacity());
        this.stressUsage = state.finalStressUsed();
        this.overstressed = this.stressCapacity - this.stressUsage < 0.0;
        this.speed = Math.abs(state.finalSpeed() / (double)state.providerCount);
    }

    private void updateSelf(class_3218 world, float delta) {
        double speed;
        BlockGraph graph = this.ctx.getGraph();
        State state = new State();
        this.calculateState(world, state);
        this.applyState(state);
        this.negative = state.speed == 0.0 ? this.negative : state.speed < 0.0;
        double d = speed = this.speed != 0.0 ? this.speed * Math.signum(state.speed) : 0.0;
        if (this.overstressed) {
            for (NodeHolder entry : graph.getCachedNodes(FunctionalDirectionNode.CACHE)) {
                class_2338 pos = entry.getBlockPos();
                world.method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 1, 0.3, 0.3, 0.3, 0.2);
            }
            return;
        }
        double baseDelta = speed * 0.01745329238474369 * (double)delta;
        float r = (float)((baseDelta + (double)this.rotationValue) % 6.2831854820251465);
        if (this.negative) {
            r = -r;
        }
        r = Math.abs(r);
        float rotMax = 0.7853882f * delta;
        float f = this.rotationValue = this.negative ? -r : r;
        this.rotation = Math.abs(baseDelta) < (double)rotMax ? this.rotationValue : (this.rotation + (this.negative ? -rotMax : rotMax)) % ((float)Math.PI * 2);
    }

    public void onInit(@NotNull GraphEntityContext ctx) {
        this.ctx = ctx;
    }

    @NotNull
    public GraphEntityContext getContext() {
        return this.ctx;
    }

    @NotNull
    public GraphEntityType<?> getType() {
        return TYPE;
    }

    public void merge(@NotNull RotationData other) {
        if (this.ctx.getGraph().size() < other.ctx.getGraph().size()) {
            this.rotation = other.rotation;
            this.rotationValue = other.rotationValue;
        } else {
            other.rotation = this.rotation;
            other.rotationValue = this.rotationValue;
        }
    }

    @NotNull
    private RotationData split(@NotNull BlockGraph originalGraph, @NotNull BlockGraph newGraph) {
        RotationData data = new RotationData();
        data.rotation = this.rotation;
        data.rotationValue = this.rotationValue;
        data.speed = this.speed;
        return data;
    }

    public boolean isOverstressed() {
        return this.overstressed;
    }

    @Nullable
    public class_2561 getStateText() {
        if (this.overstressed) {
            return this.stressCapacity == 0.0 ? MachineInfoProvider.LOCKED_TEXT : MachineInfoProvider.OVERSTRESSED_TEXT;
        }
        return null;
    }

    public class_2561 getStateTextOrElse(class_2561 fallback) {
        class_2561 state = this.getStateText();
        return state != null ? state : fallback;
    }

    public static class State {
        public static final State EMPTY = new State();
        public static final State SPECIAL = new State();
        public boolean flip = false;
        public float multiplier = 1.0f;
        protected double speed;
        protected double stressCapacity;
        protected double stressUsed;
        protected int providerCount;
        protected int userCount;

        public void provide(double speed, double stressCapacity, boolean negative) {
            ++this.providerCount;
            if (this.flip == negative) {
                this.speed += speed * (double)this.multiplier;
                this.stressCapacity += stressCapacity / (double)this.multiplier;
            } else {
                this.speed -= speed * (double)this.multiplier;
                this.stressCapacity -= stressCapacity / (double)this.multiplier;
            }
        }

        public void stress(double stress) {
            this.stressUsed += stress;
            ++this.userCount;
        }

        public void provide(float speed, float stressCapacity, class_2350.class_2352 direction) {
            this.provide((double)speed, (double)stressCapacity, direction == class_2350.class_2352.field_11060);
        }

        public double finalStressCapacity() {
            return this.stressCapacity * (double)this.multiplier;
        }

        public double finalStressUsed() {
            return this.stressUsed * (double)this.multiplier;
        }

        public double finalSpeed() {
            return this.speed / (double)this.multiplier;
        }

        public void clear() {
            this.speed = 0.0;
            this.userCount = 0;
            this.flip = false;
            this.multiplier = 1.0f;
            this.stressCapacity = 0.0;
            this.stressUsed = 0.0;
            this.providerCount = 0;
        }
    }
}

