/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.polydex;

import eu.pb4.factorytools.api.block.MultiBlock;
import eu.pb4.factorytools.api.recipe.CountedIngredient;
import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polydex.api.v1.hover.HoverDisplayBuilder;
import eu.pb4.polydex.api.v1.hover.PolydexTarget;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.book.view.crafting.ShapelessCraftingRecipePage;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.block.other.MachineInfoProvider;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.polydex.PolydexFluidStack;
import eu.pb4.polyfactory.polydex.pages.BrewingMixerRecipePage;
import eu.pb4.polyfactory.polydex.pages.ColoringCraftingRecipePage;
import eu.pb4.polyfactory.polydex.pages.GenericMixerRecipePage;
import eu.pb4.polyfactory.polydex.pages.GrindingRecipePage;
import eu.pb4.polyfactory.polydex.pages.PressRecipePage;
import eu.pb4.polyfactory.polydex.pages.SimpleCastingRecipePage;
import eu.pb4.polyfactory.polydex.pages.SimpleCauldronCastingRecipePage;
import eu.pb4.polyfactory.polydex.pages.SimpleDrainRecipePage;
import eu.pb4.polyfactory.polydex.pages.SimpleSmelteryRecipePage;
import eu.pb4.polyfactory.polydex.pages.SimpleSpoutRecipePage;
import eu.pb4.polyfactory.polydex.pages.TransformMixerRecipePage;
import eu.pb4.polyfactory.recipe.ColoringCraftingRecipe;
import eu.pb4.polyfactory.recipe.CraftingWithLeftoverRecipe;
import eu.pb4.polyfactory.recipe.GrindingRecipe;
import eu.pb4.polyfactory.recipe.ShapelessNbtCopyRecipe;
import eu.pb4.polyfactory.recipe.casting.SimpleCastingRecipe;
import eu.pb4.polyfactory.recipe.casting.SimpleCauldronCastingRecipe;
import eu.pb4.polyfactory.recipe.drain.SimpleDrainRecipe;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import eu.pb4.polyfactory.recipe.mixing.BrewingMixingRecipe;
import eu.pb4.polyfactory.recipe.mixing.GenericMixingRecipe;
import eu.pb4.polyfactory.recipe.mixing.TransformMixingRecipe;
import eu.pb4.polyfactory.recipe.press.GenericPressRecipe;
import eu.pb4.polyfactory.recipe.smeltery.SimpleSmelteryRecipe;
import eu.pb4.polyfactory.recipe.spout.SimpleSpoutRecipe;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.GuiUtils;
import eu.pb4.polyfactory.util.BlockStateNameProvider;
import eu.pb4.polyfactory.util.DebugTextProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3902;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;

public class PolydexCompatImpl {
    private static final HoverDisplayBuilder.ComponentType MACHINE_STATE = (HoverDisplayBuilder.ComponentType)class_156.method_656(() -> {
        HoverDisplayBuilder.NAME.index();
        return HoverDisplayBuilder.ComponentType.of((class_2960)ModInit.id("machine_state"), (boolean)true);
    });
    private static final HoverDisplayBuilder.ComponentType FILLED = HoverDisplayBuilder.ComponentType.of((class_2960)ModInit.id("filled_amount"), (HoverDisplayBuilder.ComponentType.Visibility)HoverDisplayBuilder.ComponentType.Visibility.ALWAYS);
    private static final HoverDisplayBuilder.ComponentType DEBUG_DATA = HoverDisplayBuilder.ComponentType.of((class_2960)ModInit.id("debug_data"), (HoverDisplayBuilder.ComponentType.Visibility)HoverDisplayBuilder.ComponentType.Visibility.NEVER);

    public static void register() {
        PolydexPage.registerRecipeViewer(GenericPressRecipe.class, PressRecipePage::new);
        PolydexPage.registerRecipeViewer(GenericMixingRecipe.class, GenericMixerRecipePage::new);
        PolydexPage.registerRecipeViewer(TransformMixingRecipe.class, TransformMixerRecipePage::new);
        PolydexPage.registerRecipeViewer(BrewingMixingRecipe.class, BrewingMixerRecipePage::new);
        PolydexPage.registerRecipeViewer(GrindingRecipe.class, GrindingRecipePage::new);
        PolydexPage.registerRecipeViewer(ColoringCraftingRecipe.class, ColoringCraftingRecipePage::new);
        PolydexPage.registerRecipeViewer(ShapelessNbtCopyRecipe.class, x -> new ShapelessCraftingRecipePage(x));
        PolydexPage.registerRecipeViewer(SimpleSpoutRecipe.class, SimpleSpoutRecipePage::new);
        PolydexPage.registerRecipeViewer(SimpleCastingRecipe.class, SimpleCastingRecipePage::new);
        PolydexPage.registerRecipeViewer(SimpleCauldronCastingRecipe.class, SimpleCauldronCastingRecipePage::new);
        PolydexPage.registerRecipeViewer(SimpleDrainRecipe.class, SimpleDrainRecipePage::new);
        PolydexPage.registerRecipeViewer(SimpleSmelteryRecipe.class, SimpleSmelteryRecipePage::new);
        PolydexPage.registerRecipeViewer(CraftingWithLeftoverRecipe.class, x -> (PolydexPage)((Function)PolydexImpl.RECIPE_VIEWS.get(((CraftingWithLeftoverRecipe)x.comp_1933()).backingRecipe().getClass())).apply(new class_8786(x.comp_1932(), (class_1860)((CraftingWithLeftoverRecipe)x.comp_1933()).backingRecipe())));
        PolydexPage.register(PolydexCompatImpl::createPages);
        PolydexEntry.registerProvider(PolydexCompatImpl::createFluidEntries);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.SPRAY_CAN, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.CABLE, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.INVERTED_LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.FIXTURE_LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.INVERTED_FIXTURE_LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.CAGED_LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.INVERTED_CAGED_LAMP, PolydexCompatImpl::seperateColoredItems);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.BRITTLE_POTION, PolydexImpl::seperateCustomPotion);
        PolydexEntry.registerEntryCreator((class_1792)FactoryItems.PORTABLE_FLUID_TANK, PolydexCompatImpl::seperateFluidItems);
        HoverDisplayBuilder.register(PolydexCompatImpl::stateAccurateNames);
    }

    private static void createFluidEntries(MinecraftServer server, PolydexEntry.EntryConsumer consumer) {
    }

    private static void createPages(MinecraftServer server, Consumer<PolydexPage> polydexPageConsumer) {
    }

    private static PolydexEntry seperateColoredItems(class_1799 stack) {
        int color = ColoredItem.getColor(stack);
        class_1767 dye = (class_1767)DyeColorExtra.BY_COLOR.get(color);
        class_2960 baseId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        if (dye != null) {
            baseId = baseId.method_48331("/" + dye.method_15434());
        }
        return PolydexEntry.of((class_2960)baseId, (class_1799)stack, PolydexCompatImpl::isSameColoredObject);
    }

    private static boolean isSameColoredObject(PolydexEntry polydexEntry, PolydexStack<?> polydexStack) {
        Object object = polydexStack.getBacking();
        if (object instanceof class_1799) {
            class_1799 stack = (class_1799)object;
            class_1799 base = (class_1799)polydexEntry.stack().getBacking();
            if (!base.method_31574(stack.method_7909())) {
                return false;
            }
            if (ColoredItem.hasColor(base) && !ColoredItem.hasColor(stack)) {
                return true;
            }
            return ColoredItem.getColor(base) == ColoredItem.getColor(stack);
        }
        return polydexEntry.stack().matches(polydexStack, true);
    }

    private static PolydexEntry seperateFluidItems(class_1799 stack) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        FluidComponent fluids = (FluidComponent)stack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT);
        if (fluids.isEmpty()) {
            return PolydexEntry.of((class_2960)id, (class_1799)stack, PolydexCompatImpl::isSameFluidObject);
        }
        return PolydexEntry.of((class_2960)id.method_48331("/" + fluids.fluids().stream().sorted(Comparator.comparing(x -> x.getName().getString())).map(instance -> {
            String base = Objects.requireNonNull(FactoryRegistries.FLUID_TYPES.method_10221(instance.type())).method_36181();
            if (instance.type().defaultData() == class_3902.field_17274) {
                return base;
            }
            Object patt0$temp = instance.data();
            if (patt0$temp instanceof class_1844) {
                class_1844 potion = (class_1844)patt0$temp;
                if (potion.comp_2378().isPresent() && ((class_6880)potion.comp_2378().get()).method_40230().isPresent()) {
                    return base + "_" + ((class_5321)((class_6880)potion.comp_2378().get()).method_40230().get()).method_29177().method_36181();
                }
                return base + "_" + potion.hashCode();
            }
            return base + "_" + instance.hashCode();
        }).collect(Collectors.joining("/"))), (class_1799)stack, PolydexCompatImpl::isSameFluidObject);
    }

    private static boolean isSameFluidObject(PolydexEntry polydexEntry, PolydexStack<?> polydexStack) {
        Object object = polydexStack.getBacking();
        if (object instanceof class_1799) {
            class_1799 stack = (class_1799)object;
            class_1799 base = (class_1799)polydexEntry.stack().getBacking();
            if (!base.method_31574(stack.method_7909())) {
                return false;
            }
            return Objects.equals(((FluidComponent)stack.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT)).fluids(), ((FluidComponent)base.method_58695(FactoryDataComponents.FLUID, (Object)FluidComponent.DEFAULT)).fluids());
        }
        return polydexEntry.stack().matches(polydexStack, true);
    }

    private static void stateAccurateNames(HoverDisplayBuilder hoverDisplayBuilder) {
        Object provider;
        class_2561 text;
        class_2586 entity;
        class_2561 rot;
        class_2248 class_22482;
        PolydexTarget target = hoverDisplayBuilder.getTarget();
        if (target.hasTarget() && target.entity() == null && (class_22482 = target.blockState().method_26204()) instanceof BlockStateNameProvider) {
            BlockStateNameProvider provider2 = (BlockStateNameProvider)class_22482;
            hoverDisplayBuilder.setComponent(HoverDisplayBuilder.NAME, provider2.getName(target.player().method_51469(), target.pos(), target.blockState(), target.blockEntity()));
        }
        if (target.blockState().method_26204() instanceof NetworkComponent.Rotational && (rot = RotationUser.getRotation((class_1937)target.player().method_51469(), target.pos()).getStateText()) != null) {
            hoverDisplayBuilder.setComponent(MACHINE_STATE, rot);
        }
        if ((entity = target.blockEntity()) == null) {
            class_2248 class_22483 = target.blockState().method_26204();
            if (class_22483 instanceof MultiBlock) {
                MultiBlock multiBlock = (MultiBlock)class_22483;
                entity = target.player().method_51469().method_8321(multiBlock.getCenter(target.blockState(), target.pos()));
            } else if (target.blockState().method_26204() instanceof TallItemMachineBlock && target.blockState().method_11654(TallItemMachineBlock.PART) == TallItemMachineBlock.Part.TOP) {
                entity = target.player().method_51469().method_8321(target.pos().method_10074());
            }
        }
        if (entity instanceof MachineInfoProvider && (text = (provider = (MachineInfoProvider)entity).getCurrentState()) != null) {
            hoverDisplayBuilder.setComponent(MACHINE_STATE, text);
        }
        if (entity instanceof DebugTextProvider && (text = (provider = (DebugTextProvider)entity).getDebugText()) != null) {
            hoverDisplayBuilder.setComponent(DEBUG_DATA, text);
        }
        if (entity instanceof FilledStateProvider && (text = (provider = (FilledStateProvider)entity).getFilledStateText()) != null) {
            hoverDisplayBuilder.setComponent(FILLED, (class_2561)class_2561.method_43473().method_10852(text).method_54663(0xD6D6D6));
        }
    }

    public static GuiElement getButton(class_3956<?> type) {
        PolydexCategory category = PolydexCategory.of(type);
        return GuiTextures.POLYDEX_BUTTON.get().setName((class_2561)class_2561.method_43471((String)"text.polyfactory.recipes")).setCallback((index, type1, action, gui) -> {
            PolydexPageUtils.openCategoryUi((class_3222)gui.getPlayer(), (PolydexCategory)category, () -> ((SlotGuiInterface)gui).open());
            GuiUtils.playClickSound(gui.getPlayer());
        }).build();
    }

    public static List<PolydexIngredient<?>> createIngredients(CountedIngredient ... input) {
        return PolydexCompatImpl.createIngredients(List.of(input));
    }

    public static List<PolydexIngredient<?>> createIngredients(List<CountedIngredient> input) {
        ArrayList list = new ArrayList(input.size());
        for (CountedIngredient x : input) {
            list.add(PolydexIngredient.of((class_1856)x.ingredient().orElse(null), (long)Math.max(x.count(), 1), (float)1.0f));
        }
        return list;
    }

    public static List<PolydexIngredient<?>> createIngredients(List<CountedIngredient> input, List<FluidInputStack> fluids) {
        ArrayList list = new ArrayList(input.size());
        for (CountedIngredient countedIngredient : input) {
            list.add(PolydexIngredient.of((class_1856)countedIngredient.ingredient().orElse(null), (long)Math.max(countedIngredient.count(), 1), (float)1.0f));
        }
        for (FluidInputStack fluidInputStack : fluids) {
            list.add((PolydexIngredient<?>)new PolydexFluidStack(fluidInputStack.instance(), fluidInputStack.required(), 1.0f));
        }
        return list;
    }

    public static List<PolydexIngredient<?>> createIngredientsReg(List<CountedIngredient> input, List<FluidStack<?>> fluids) {
        ArrayList list = new ArrayList(input.size());
        for (CountedIngredient countedIngredient : input) {
            list.add(PolydexIngredient.of((class_1856)countedIngredient.ingredient().orElse(null), (long)Math.max(countedIngredient.count(), 1), (float)1.0f));
        }
        for (FluidStack fluidStack : fluids) {
            list.add((PolydexIngredient<?>)new PolydexFluidStack(fluidStack.instance(), fluidStack.amount(), 1.0f));
        }
        return list;
    }

    public static List<PolydexStack<FluidInstance<?>>> createFluids(List<FluidStack<?>> fluids) {
        ArrayList list = new ArrayList(fluids.size());
        for (FluidStack<?> x : fluids) {
            list.add(new PolydexFluidStack(x.instance(), x.amount(), 1.0f));
        }
        return list;
    }

    public static PolydexStack<?>[] createOutput(List<OutputStack> output) {
        ArrayList<PolydexStack> list = new ArrayList<PolydexStack>(output.size());
        for (OutputStack x : output) {
            list.add(PolydexStack.of((class_1799)x.stack().method_46651(x.stack().method_7947() * x.roll()), (float)x.chance()));
        }
        return list.toArray(new PolydexStack[0]);
    }
}

