/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.polydex.pages;

import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.polydex.PolydexCompatImpl;
import eu.pb4.polyfactory.polydex.PolydexTextures;
import eu.pb4.polyfactory.polydex.pages.PrioritizedRecipePage;
import eu.pb4.polyfactory.recipe.smeltery.SmelteryRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class SmelteryRecipePage<T extends SmelteryRecipe>
extends PrioritizedRecipePage<T> {
    private static final class_1799 ICON = new GuiElementBuilder(FactoryItems.SMELTERY).setName((class_2561)class_2561.method_43471((String)"polydex_category.polyfactory.polyfactory.smeltery")).asStack();
    private final PolydexIngredient<?> ingredient = PolydexIngredient.of((class_1856)this.getInput());
    private final PolydexStack<?>[] outputFluids = PolydexCompatImpl.createFluids(this.getFluidOutput()).toArray(new PolydexStack[0]);

    @Nullable
    public class_2561 texture(class_3222 player) {
        return class_2561.method_43473().method_10852(PolydexTextures.SMELTERY).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.POLYDEX_OFFSET_N + GuiTextures.SMELTERY_POLYDEX_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.SMELTERY.render(a -> {
            for (FluidStack<?> x : this.getFluidOutput()) {
                a.accept(x.instance(), Float.valueOf((float)((double)x.amount() / 648000.0)));
            }
        })).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.SMELTERY_POLYDEX_FLUID_OFFSET_N + GuiTextures.POLYDEX_OFFSET)).method_10862(UiResourceCreator.STYLE));
    }

    public class_1799 getOutput(@Nullable PolydexEntry polydexEntry, MinecraftServer minecraftServer) {
        return class_1799.field_8037;
    }

    protected abstract class_1856 getInput();

    protected abstract List<FluidStack<?>> getFluidOutput();

    public SmelteryRecipePage(class_8786<T> recipe) {
        super(recipe);
    }

    public class_1799 typeIcon(class_3222 player) {
        return ICON;
    }

    public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
        GuiElementBuilder b = GuiElementBuilder.from((class_1799)this.outputFluids[0].toTypeDisplayItemStack(player));
        for (PolydexStack x : this.ingredient.asStacks()) {
            b.addLoreLine((class_2561)class_2561.method_43470((String)"- ").method_10852(x.getName()).method_27692(class_124.field_1080));
        }
        return b.asStack();
    }

    public List<PolydexIngredient<?>> ingredients() {
        return List.of(this.ingredient);
    }

    public boolean isOwner(MinecraftServer server, PolydexEntry entry) {
        for (PolydexStack<?> x : this.outputFluids) {
            if (!entry.isPartOf(x)) continue;
            return true;
        }
        return super.isOwner(server, entry);
    }

    public void createPage(@Nullable PolydexEntry entry, class_3222 player, PageBuilder layer) {
        layer.setIngredient(2, 2, this.ingredient);
        GuiElementBuilder fluid = GuiTextures.EMPTY_BUILDER.get();
        fluid.setName((class_2561)class_2561.method_43471((String)"text.polyfactory.polydex.created_fluids"));
        for (FluidStack<?> stack : this.getFluidOutput()) {
            fluid.addLoreLine((class_2561)stack.toTextRequired().method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false))));
        }
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 3; ++x) {
                layer.set(x + 5, y, fluid);
            }
        }
    }
}

