/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.recipe.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.recipe.OutputStack;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.recipe.FactoryRecipeSerializers;
import eu.pb4.polyfactory.recipe.fluid.FluidInteractionRecipe;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public record RemovingFluidInteractionRecipe(List<FluidInputStack> fluidInput, Optional<class_2394> particleEffect, Optional<class_6880<class_3414>> soundEvent, float particleChance, float minTemperature, float maxTemperature) implements FluidInteractionRecipe
{
    public static final MapCodec<RemovingFluidInteractionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FluidInputStack.CODEC.listOf().fieldOf("fluid_input").forGetter(RemovingFluidInteractionRecipe::fluidInput), (App)class_2398.field_25125.optionalFieldOf("particle").forGetter(RemovingFluidInteractionRecipe::particleEffect), (App)class_3414.field_41699.optionalFieldOf("sound_event").forGetter(RemovingFluidInteractionRecipe::soundEvent), (App)Codec.FLOAT.optionalFieldOf("particle_chance", (Object)Float.valueOf(0.0f)).forGetter(RemovingFluidInteractionRecipe::particleChance), (App)Codec.FLOAT.optionalFieldOf("min_temperature", (Object)Float.valueOf(Float.NEGATIVE_INFINITY)).forGetter(RemovingFluidInteractionRecipe::minTemperature), (App)Codec.FLOAT.optionalFieldOf("max_temperature", (Object)Float.valueOf(Float.POSITIVE_INFINITY)).forGetter(RemovingFluidInteractionRecipe::maxTemperature)).apply((Applicative)instance, RemovingFluidInteractionRecipe::new));

    @Override
    public List<FluidInputStack> fluidInput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return this.fluidInput;
    }

    @Override
    public List<FluidStack<?>> fluidOutput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return List.of();
    }

    @Override
    public List<OutputStack> itemOutput(FluidContainerInput input, class_7225.class_7874 lookup) {
        return List.of();
    }

    public boolean matches(FluidContainerInput input, class_1937 world) {
        if (input.temperature() < this.minTemperature || input.temperature() > this.maxTemperature) {
            return false;
        }
        int below = 0;
        for (FluidInputStack in : this.fluidInput) {
            long amount = input.get(in.instance());
            if (amount == 0L) {
                return false;
            }
            if (amount >= in.required()) continue;
            ++below;
        }
        return below > 0;
    }

    @Override
    @Nullable
    public class_2394 particle(FluidContainerInput input, class_5819 random) {
        return this.particleEffect.orElse(null);
    }

    @Override
    @Nullable
    public class_6880<class_3414> soundEvent(FluidContainerInput input, class_5819 random) {
        return this.soundEvent.orElse(null);
    }

    @Override
    public int maxApplyPerTick() {
        return 1;
    }

    @Override
    public float particleChance(FluidContainerInput input) {
        return this.particleChance;
    }

    public class_1865<RemovingFluidInteractionRecipe> method_8119() {
        return FactoryRecipeSerializers.FLUID_INTERACTION_REMOVING;
    }
}

