/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.ui;

import com.mojang.datafixers.util.Pair;
import eu.pb4.polyfactory.fluid.FluidType;
import eu.pb4.polyfactory.other.FactoryRegistries;
import eu.pb4.polyfactory.util.ResourceUtils;
import eu.pb4.polymer.resourcepack.api.AssetPaths;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.imageio.ImageIO;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_2960;

public class FluidUiTextureCreator {
    private final Set<Pair<class_2960, class_2960>> textures = new HashSet<Pair<class_2960, class_2960>>();
    private final int width;
    private final int textureHeight;

    public FluidUiTextureCreator(int textureWidth) {
        this.width = textureWidth;
        this.textureHeight = 16;
    }

    public void registerTextures(class_2960 id, FluidType<?> object) {
        this.textures.add((Pair<class_2960, class_2960>)Pair.of((Object)id, (Object)object.texture()));
    }

    public void setup() {
        for (class_2960 fluid : FactoryRegistries.FLUID_TYPES.method_10235()) {
            this.registerTextures(fluid, Objects.requireNonNull((FluidType)FactoryRegistries.FLUID_TYPES.method_63535(fluid)));
        }
        RegistryEntryAddedCallback.event(FactoryRegistries.FLUID_TYPES).register((rawId, id, object) -> this.registerTextures(id, (FluidType<?>)object));
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.register(b -> this.generateAssets((arg_0, arg_1) -> ((ResourcePackBuilder)b).addData(arg_0, arg_1)));
    }

    public void generateAssets(BiConsumer<String, byte[]> assetWriter) {
        try {
            for (Pair<class_2960, class_2960> texture : this.textures) {
                this.generateSplitTextures(assetWriter, (class_2960)texture.getFirst(), (class_2960)texture.getSecond());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void generateSplitTextures(BiConsumer<String, byte[]> assetWriter, class_2960 id, class_2960 texture) throws IOException {
        BufferedImage image = ResourceUtils.getTexture(texture);
        class_2960 file = id.method_45138("gen/fluids_" + this.width + "/").method_48331("/");
        int scale = image.getWidth() / 16;
        for (int i = 0; i < this.textureHeight; ++i) {
            BufferedImage out = new BufferedImage(this.width * scale, scale, 1);
            for (int x = 0; x < out.getWidth(); ++x) {
                for (int y = 0; y < out.getHeight(); ++y) {
                    out.setRGB(x, y, image.getRGB(x % image.getWidth(), y + i * scale));
                }
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)out, "png", bytes);
            assetWriter.accept(AssetPaths.texture((class_2960)file.method_48331(i + ".png")), bytes.toByteArray());
        }
    }
}

