/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.polyfactory.util.ModelRenderType;
import eu.pb4.polyfactory.util.inventory.CustomInsertInventory;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemConsumer;
import eu.pb4.sgui.api.GuiHelpers;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2614;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactoryUtil {
    public static final List<class_2350> REORDERED_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033);
    public static final GameProfile GENERIC_PROFILE = new GameProfile(class_156.field_25140, "[PolyFactory]");
    public static final class_243 HALF_BELOW = new class_243(0.0, -0.5, 0.0);
    public static final List<class_2350> HORIZONTAL_DIRECTIONS = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039);
    public static final List<class_1304> ARMOR_EQUIPMENT = Arrays.stream(class_1304.values()).filter(x -> x.method_5925() == class_1304.class_1305.field_6178).toList();
    public static final List<class_1767> COLORS_CREATIVE = List.of(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957, class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942, class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954);
    private static final List<Runnable> RUN_NEXT_TICK = new ArrayList<Runnable>();

    public static class_1792 requestModelBase(ModelRenderType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ModelRenderType.SOLID -> class_1802.field_20391;
            case ModelRenderType.TRANSPARENT -> class_1802.field_8153;
            case ModelRenderType.COLORED -> class_1802.field_18138;
        };
    }

    public static void runNextTick(Runnable runnable) {
        RUN_NEXT_TICK.add(runnable);
    }

    public static void register() {
        ServerTickEvents.START_SERVER_TICK.register(FactoryUtil::onTick);
        ServerLifecycleEvents.SERVER_STOPPED.register(FactoryUtil::onServerStopped);
    }

    private static void onServerStopped(MinecraftServer server) {
        RUN_NEXT_TICK.clear();
    }

    private static void onTick(MinecraftServer server) {
        RUN_NEXT_TICK.forEach(Runnable::run);
        RUN_NEXT_TICK.clear();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)"polyfactory", (String)path);
    }

    public static class_5250 fluidTextIngots(long amount) {
        if (amount >= 81000L) {
            long buckets = amount / 81L;
            return class_2561.method_43470((String)(buckets / 1000L + "." + buckets / 10L % 100L + " ")).method_10852((class_2561)class_2561.method_43471((String)"text.polyfactory.amount.block"));
        }
        if (amount >= 9000L) {
            long buckets = amount / 9L;
            return class_2561.method_43470((String)(buckets / 1000L + "." + buckets / 10L % 100L + " ")).method_10852((class_2561)class_2561.method_43471((String)"text.polyfactory.amount.ingot"));
        }
        if (amount >= 1000L) {
            long buckets = amount / 1L;
            return class_2561.method_43470((String)(buckets / 1000L + "." + buckets / 10L % 100L + " ")).method_10852((class_2561)class_2561.method_43471((String)"text.polyfactory.amount.nuggets"));
        }
        if (amount != 0L) {
            return class_2561.method_43470((String)(amount + "d"));
        }
        return class_2561.method_43470((String)"0");
    }

    public static class_5250 fluidTextGeneric(long amount) {
        if (amount >= 81000L) {
            long buckets = amount / 81L;
            return class_2561.method_43470((String)(buckets / 1000L + "." + buckets / 10L % 100L + "B"));
        }
        if (amount >= 81L) {
            long buckets = amount / 81L;
            return class_2561.method_43470((String)(buckets + "mB"));
        }
        if (amount != 0L) {
            return class_2561.method_43470((String)(amount + "d"));
        }
        return class_2561.method_43470((String)"0");
    }

    public static void sendVelocityDelta(class_3222 player, class_243 delta) {
        player.field_13987.method_14364((class_2596)new class_2664(new class_243(player.method_23317(), player.method_23318() - 9999.0, player.method_23321()), Optional.of(delta), (class_2394)class_2398.field_11247, class_7923.field_41172.method_47983((Object)class_3417.field_42593)));
    }

    public static float wrap(float value, float min, float max) {
        if (value > max) {
            return min;
        }
        if (value < min) {
            return max;
        }
        return value;
    }

    public static int wrap(int value, int min, int max) {
        if (value > max) {
            return min;
        }
        if (value < min) {
            return max;
        }
        return value;
    }

    public static class_1799 exchangeStack(class_1799 inputStack, int subtractedAmount, class_1657 player, class_1799 outputStack, boolean creativeOverride) {
        boolean bl = player.method_56992();
        if (creativeOverride && bl) {
            if (!player.method_31548().method_7379(outputStack)) {
                player.method_31548().method_7394(outputStack);
            }
            return inputStack;
        }
        inputStack.method_57008(subtractedAmount, (class_1309)player);
        if (inputStack.method_7960()) {
            return outputStack;
        }
        if (!player.method_31548().method_7394(outputStack)) {
            player.method_7328(outputStack, false);
        }
        return inputStack;
    }

    public static class_1799 exchangeStack(class_1799 inputStack, int subtractedAmount, class_1657 player, class_1799 outputStack) {
        return FactoryUtil.exchangeStack(inputStack, subtractedAmount, player, outputStack, true);
    }

    public static int tryInserting(class_1937 world, class_2338 pos, class_1799 itemStack, class_2350 direction) {
        class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
        if (inv != null) {
            return FactoryUtil.tryInsertingInv(inv, itemStack, direction);
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)direction);
        if (storage != null) {
            try (Transaction t = Transaction.openOuter();){
                long x = storage.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)t);
                t.commit();
                itemStack.method_7934((int)x);
                int n = (int)x;
                return n;
            }
        }
        return -1;
    }

    public static int tryInsertingInv(class_1263 inventory, class_1799 itemStack, class_2350 direction) {
        if (inventory instanceof CustomInsertInventory) {
            CustomInsertInventory customInsertInventory = (CustomInsertInventory)inventory;
            return customInsertInventory.insertStack(itemStack, direction);
        }
        if (inventory instanceof class_1278) {
            class_1278 sidedInventory = (class_1278)inventory;
            return FactoryUtil.tryInsertingSided(sidedInventory, itemStack, direction);
        }
        return FactoryUtil.tryInsertingRegular(inventory, itemStack);
    }

    public static MovableResult tryInsertingMovable(ContainerHolder conveyor, class_1937 world, class_2338 conveyorPos, class_2338 targetPos, class_2350 dir, class_2350 selfDir, @Nullable class_6862<class_2248> requiredTag) {
        MovingItem holdStack = conveyor.getContainer();
        if (holdStack == null || holdStack.method_32327().method_7960()) {
            return MovableResult.FAILURE;
        }
        WorldPointer pointer = new WorldPointer(world, targetPos);
        if (requiredTag != null && !pointer.getBlockState().method_26164(requiredTag)) {
            return MovableResult.FAILURE;
        }
        class_2248 class_22482 = pointer.getBlockState().method_26204();
        if (class_22482 instanceof MovingItemConsumer) {
            MovingItemConsumer conveyorInteracting = (MovingItemConsumer)class_22482;
            if (conveyorInteracting.pushItemTo(pointer, selfDir, dir, conveyorPos, conveyor)) {
                return MovableResult.SUCCESS_MOVABLE;
            }
        } else if (FactoryUtil.tryInserting((class_1937)pointer.getWorld(), pointer.getPos(), holdStack.method_32327(), dir) != -1) {
            if (holdStack.method_32327().method_7960()) {
                conveyor.clearContainer();
                return MovableResult.SUCCESS_REGULAR;
            }
            return MovableResult.SUCCESS_REGULAR;
        }
        return MovableResult.FAILURE;
    }

    private static int tryInsertingSided(class_1278 inventory, class_1799 itemStack, class_2350 direction) {
        int[] slots = inventory.method_5494(direction);
        int init = itemStack.method_7947();
        for (int i = 0; i < slots.length; ++i) {
            int maxMove;
            int slot = slots[i];
            if (!inventory.method_5492(slot, itemStack, direction)) continue;
            class_1799 current = inventory.method_5438(slot);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(slot, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int insertBetween(class_1263 inventory, int start, int end, class_1799 itemStack) {
        int size = Math.min(inventory.method_5439(), end);
        int init = itemStack.method_7947();
        for (int i = start; i < size; ++i) {
            int maxMove;
            class_1799 current = inventory.method_5438(i);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(i, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int tryInsertingRegular(class_1263 inventory, class_1799 itemStack) {
        int size = inventory.method_5439();
        int init = itemStack.method_7947();
        for (int i = 0; i < size; ++i) {
            int maxMove;
            class_1799 current = inventory.method_5438(i);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(i, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int tryInsertingIntoSlot(class_1937 world, class_2338 pos, class_1799 itemStack, class_2350 direction, IntList slots) {
        class_1263 inv = class_2614.method_11250((class_1937)world, (class_2338)pos);
        if (inv != null) {
            return FactoryUtil.tryInsertingInvIntoSlot(inv, itemStack, direction, slots);
        }
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)direction);
        if (storage instanceof SlottedStorage) {
            SlottedStorage slottedStorage = (SlottedStorage)storage;
            try (Transaction t = Transaction.openOuter();){
                int total = 0;
                for (Integer slot : slots) {
                    if (slot >= slottedStorage.getSlotCount()) continue;
                    long x = slottedStorage.getSlot(slot.intValue()).insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)t);
                    itemStack.method_7934((int)x);
                    total = (int)((long)total + x);
                    if (!itemStack.method_7960()) continue;
                    break;
                }
                t.commit();
                int n = total;
                return n;
            }
        }
        return -1;
    }

    public static int tryInsertingInvIntoSlot(class_1263 inventory, class_1799 itemStack, class_2350 direction, IntList slots) {
        if (inventory instanceof CustomInsertInventory) {
            CustomInsertInventory customInsertInventory = (CustomInsertInventory)inventory;
            return customInsertInventory.insertStackSlots(itemStack, direction, slots);
        }
        if (inventory instanceof class_1278) {
            class_1278 sidedInventory = (class_1278)inventory;
            return FactoryUtil.tryInsertingSidedIntoSlot(sidedInventory, itemStack, direction, slots);
        }
        return FactoryUtil.tryInsertingRegularIntoSlot(inventory, itemStack, slots);
    }

    private static int tryInsertingSidedIntoSlot(class_1278 inventory, class_1799 itemStack, class_2350 direction, IntList allowedSlots) {
        int[] slots = inventory.method_5494(direction);
        int init = itemStack.method_7947();
        for (int i = 0; i < slots.length; ++i) {
            int maxMove;
            int slot = slots[i];
            if (!inventory.method_5492(slot, itemStack, direction) || !allowedSlots.contains(slot)) continue;
            class_1799 current = inventory.method_5438(slot);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(slot, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static int tryInsertingRegularIntoSlot(class_1263 inventory, class_1799 itemStack, IntList slots) {
        int size = inventory.method_5439();
        int init = itemStack.method_7947();
        IntListIterator intListIterator = slots.iterator();
        while (intListIterator.hasNext()) {
            int maxMove;
            int i = (Integer)intListIterator.next();
            if (i >= size) continue;
            class_1799 current = inventory.method_5438(i);
            if (current.method_7960()) {
                maxMove = Math.min(itemStack.method_7947(), inventory.method_5444());
                inventory.method_5447(i, itemStack.method_46651(maxMove));
                itemStack.method_7934(maxMove);
            } else if (class_1799.method_31577((class_1799)current, (class_1799)itemStack) && (maxMove = Math.min(Math.min(current.method_7914() - current.method_7947(), itemStack.method_7947()), inventory.method_5444())) > 0) {
                current.method_7933(maxMove);
                itemStack.method_7934(maxMove);
            }
            if (!itemStack.method_7960()) continue;
            return init;
        }
        return init - itemStack.method_7947();
    }

    public static <T extends Comparable<T>> class_2680 transform(class_2680 input, Function<T, T> transform, class_2769<T> property) {
        return (class_2680)input.method_47968(property, (Comparable)transform.apply(input.method_11654(property)));
    }

    public static class_1657 getClosestPlayer(class_1937 world, class_2338 pos, double distance) {
        return world.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, distance, false);
    }

    public static class_2561 asText(@Nullable class_2350 dir) {
        return class_2561.method_43471((String)("text.polyfactory.direction." + (dir != null ? dir.method_15434() : "none")));
    }

    public static void setSafeVelocity(class_1297 entity, class_243 vec) {
        entity.method_18799(FactoryUtil.safeVelocity(vec));
    }

    public static class_243 safeVelocity(class_243 vec) {
        double l = vec.method_1033();
        if (l > 1028.0) {
            return vec.method_1021(1028.0 / l);
        }
        return vec;
    }

    public static void addSafeVelocity(class_1297 entity, class_243 vec) {
        FactoryUtil.setSafeVelocity(entity, entity.method_18798().method_1019(vec));
    }

    public static class_2338 findFurthestFluidBlockForRemoval(class_1937 world, class_2680 target, class_2338 start) {
        return start;
    }

    public static class_2338 findFurthestFluidBlockForPlacement(class_2680 target, class_2338 start) {
        return start;
    }

    public static Consumer<class_1799> getItemConsumer(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return arg_0 -> ((class_1661)player.method_31548()).method_7398(arg_0);
        }
        if (entity instanceof class_1263) {
            class_1263 inventory = (class_1263)entity;
            return stack -> {
                FactoryUtil.tryInsertingRegular(inventory, stack);
                if (!stack.method_7960()) {
                    entity.method_5775((class_3218)entity.method_37908(), stack);
                }
            };
        }
        return stack -> entity.method_5775((class_3218)entity.method_37908(), stack);
    }

    public static void sendSlotUpdate(class_1297 entity, class_1268 hand) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            GuiHelpers.sendSlotUpdate((class_3222)player, (int)player.field_7498.field_7763, (int)(hand == class_1268.field_5808 ? 36 + player.method_31548().method_67532() : 45), (class_1799)player.method_5998(hand), (int)player.field_7498.method_37422());
        }
    }

    public static class_2680 rotateAxis(class_2680 state, class_2769<class_2350.class_2351> axis, class_2470 rotation) {
        class_2350.class_2351 a = (class_2350.class_2351)state.method_11654(axis);
        if (a == class_2350.class_2351.field_11052 || rotation == class_2470.field_11467 || rotation == class_2470.field_11464) {
            return state;
        }
        return (class_2680)state.method_11657(axis, (Comparable)(a == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048));
    }

    public static <T extends Comparable<T>> class_2680 rotate(class_2680 state, class_2769<T> north, class_2769<T> south, class_2769<T> east, class_2769<T> west, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11464 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(south))).method_11657(east, state.method_11654(west))).method_11657(south, state.method_11654(north))).method_11657(west, state.method_11654(east));
            case class_2470.field_11465 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(east))).method_11657(east, state.method_11654(south))).method_11657(south, state.method_11654(west))).method_11657(west, state.method_11654(north));
            case class_2470.field_11463 -> (class_2680)((class_2680)((class_2680)((class_2680)state.method_11657(north, state.method_11654(west))).method_11657(east, state.method_11654(north))).method_11657(south, state.method_11654(east))).method_11657(west, state.method_11654(south));
            default -> state;
        };
    }

    public static <T extends Comparable<T>> class_2680 mirror(class_2680 state, class_2769<T> north, class_2769<T> south, class_2769<T> east, class_2769<T> west, class_2415 mirror) {
        return switch (mirror) {
            case class_2415.field_11300 -> (class_2680)((class_2680)state.method_11657(north, state.method_11654(south))).method_11657(south, state.method_11654(north));
            case class_2415.field_11301 -> (class_2680)((class_2680)state.method_11657(east, state.method_11654(west))).method_11657(west, state.method_11654(east));
            default -> state;
        };
    }

    public static class_5321<class_1860<?>> recipeKey(String s) {
        return class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)FactoryUtil.id(s));
    }

    public static <T extends Enum<T>> T nextEnum(T activeMode, T[] values, boolean next) {
        return values[(values.length + activeMode.ordinal() + (next ? 1 : -1)) % values.length];
    }

    public static <T extends Comparable<T>> Codec<T> propertyCodec(class_2769<T> property) {
        return Codec.stringResolver(arg_0 -> property.method_11901(arg_0), x -> property.method_11900(x).orElse((Comparable)property.method_11898().getFirst()));
    }

    public static class_1799 fromNbtStack(class_7225.class_7874 lookup, class_2520 stack) {
        class_2487 compound;
        return stack instanceof class_2487 && (compound = (class_2487)stack).method_33133() ? class_1799.field_8037 : class_1799.method_57360((class_7225.class_7874)lookup, (class_2520)stack).orElse(class_1799.field_8037);
    }

    public static <T> class_6885<T> fakeTagList(final class_6862<T> tag) {
        return new class_6885<T>(){

            public Stream<class_6880<T>> method_40239() {
                return Stream.empty();
            }

            public int method_40247() {
                return 0;
            }

            public boolean method_62680() {
                return true;
            }

            public Either<class_6862<T>, List<class_6880<T>>> method_40248() {
                return Either.left((Object)tag);
            }

            public Optional<class_6880<T>> method_40243(class_5819 random) {
                return Optional.empty();
            }

            public class_6880<T> method_40240(int index) {
                return null;
            }

            public boolean method_40241(class_6880<T> entry) {
                return false;
            }

            public boolean method_46768(class_7876<T> owner) {
                return true;
            }

            public Optional<class_6862<T>> method_45925() {
                return Optional.of(tag);
            }

            @NotNull
            public Iterator<class_6880<T>> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    public static boolean insertItemIntoSlots(class_1799 stack, List<class_1735> slots, boolean fromLast) {
        class_1799 stackInSlot;
        boolean modified = false;
        if (fromLast) {
            slots = slots.reversed();
        }
        if (stack.method_7946()) {
            for (class_1735 class_17352 : slots) {
                int maxSize;
                if (stack.method_7960()) break;
                if (!class_17352.method_7680(stack) || (stackInSlot = class_17352.method_7677()).method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)stackInSlot)) continue;
                int totalCount = stackInSlot.method_7947() + stack.method_7947();
                if (totalCount <= (maxSize = class_17352.method_7676(stackInSlot))) {
                    stack.method_7939(0);
                    stackInSlot.method_7939(totalCount);
                    class_17352.method_7668();
                    modified = true;
                    continue;
                }
                if (stackInSlot.method_7947() >= maxSize) continue;
                stack.method_7934(maxSize - stackInSlot.method_7947());
                stackInSlot.method_7939(maxSize);
                class_17352.method_7668();
                modified = true;
            }
        }
        if (!stack.method_7960()) {
            for (class_1735 class_17353 : slots) {
                if (!class_17353.method_7680(stack) || !(stackInSlot = class_17353.method_7677()).method_7960() || !class_17353.method_7680(stack)) continue;
                int maxSize = class_17353.method_7676(stack);
                class_17353.method_53512(stack.method_7971(Math.min(stack.method_7947(), maxSize)));
                class_17353.method_7668();
                modified = true;
                break;
            }
        }
        return modified;
    }

    public static enum MovableResult {
        SUCCESS_MOVABLE,
        SUCCESS_REGULAR,
        FAILURE;

    }
}

