/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.movingitem;

import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_3222;
import net.minecraft.class_5630;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MovingItem
implements VirtualElement,
class_5630 {
    private class_1799 stack;
    private class_1799 stackCurrent;
    private final ItemDisplayElement[] itemDisplay = new ItemDisplayElement[4];
    private final ItemDisplayElement riddenBase;
    private float globalScale = 1.0f;
    private int tick;
    private boolean isFirstMove = true;
    private class_243 pos = class_243.field_1353;

    @Deprecated
    public MovingItem(class_1799 stack) {
        this(stack, class_243.field_1353);
    }

    public MovingItem(class_1799 stack, class_243 pos) {
        this.stack = stack.method_7972();
        this.stackCurrent = stack.method_7972();
        for (int i = 0; i < 4; ++i) {
            this.itemDisplay[i] = new LodItemDisplayElement();
            this.itemDisplay[i].setLeftRotation((Quaternionfc)class_2350.field_11043.method_23224());
            this.itemDisplay[i].setDisplayWidth(1.0f);
            this.itemDisplay[i].setDisplayHeight(2.0f);
            this.itemDisplay[i].setViewRange(i == 0 ? 0.5f : 0.2f);
            this.itemDisplay[i].setItemDisplayContext(class_811.field_4315);
            this.itemDisplay[i].setInterpolationDuration(10);
            this.itemDisplay[i].ignorePositionUpdates();
            this.updateDisplay(i);
        }
        this.riddenBase = this.itemDisplay[0];
        this.riddenBase.setSendPositionUpdates(true);
        this.setPos(pos);
    }

    public MovingItem split(ContainerHolder aware) {
        return this.split(aware.getMaxStackCount(this.stack));
    }

    public MovingItem split(int newCount) {
        MovingItem x = new MovingItem(this.stack.method_46651(newCount), this.getCurrentPos());
        this.stack.method_7934(newCount);
        return x;
    }

    private void updateDisplay(int i) {
        int count = this.stack.method_7947();
        if (i * 16 <= count) {
            this.itemDisplay[i].setItem(this.stack.method_7972());
        } else {
            this.itemDisplay[i].setItem(class_1799.field_8037);
        }
        this.updateScale(i);
    }

    private void updateScale(int i) {
        this.itemDisplay[i].setScale((Vector3fc)new Vector3f(0.5f * this.globalScale));
    }

    public class_1799 method_32327() {
        return this.stack;
    }

    public boolean method_32332(class_1799 stack) {
        if (class_1799.method_31577((class_1799)this.stack, (class_1799)stack)) {
            return false;
        }
        this.stack = stack;
        for (int i = 0; i < 4; ++i) {
            this.updateDisplay(i);
        }
        return true;
    }

    public void setPos(class_243 vec3d) {
        this.setOverridePos(vec3d);
        for (ItemDisplayElement x : this.itemDisplay) {
            x.setOverridePos(vec3d);
        }
    }

    @Nullable
    public void setOverridePos(class_243 vec3d) {
        this.pos = vec3d;
    }

    @Nullable
    public class_243 getOverridePos() {
        return this.pos;
    }

    public IntList getEntityIds() {
        return IntList.of((int[])new int[]{this.riddenBase.getEntityId(), this.itemDisplay[1].getEntityId(), this.itemDisplay[2].getEntityId(), this.itemDisplay[3].getEntityId()});
    }

    public void setHolder(@Nullable ElementHolder holder) {
        for (ItemDisplayElement x : this.itemDisplay) {
            x.setHolder(holder);
        }
    }

    @Nullable
    public ElementHolder getHolder() {
        return this.riddenBase.getHolder();
    }

    public class_243 getOffset() {
        return class_243.field_1353;
    }

    public void setOffset(class_243 vec3d) {
    }

    public void startWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
        for (ItemDisplayElement x : this.itemDisplay) {
            x.startWatching(player, packetConsumer);
        }
        packetConsumer.accept((class_2596<class_2602>)VirtualEntityUtils.createRidePacket((int)this.riddenBase.getEntityId(), (IntList)IntList.of((int)this.itemDisplay[1].getEntityId(), (int)this.itemDisplay[2].getEntityId(), (int)this.itemDisplay[3].getEntityId())));
    }

    public void stopWatching(class_3222 player, Consumer<class_2596<class_2602>> packetConsumer) {
    }

    public void notifyMove(class_243 oldPos, class_243 currentPos, class_243 delta) {
    }

    public void tick() {
        if (this.tick++ % 2 == 1) {
            return;
        }
        this.checkItems();
        for (ItemDisplayElement x : this.itemDisplay) {
            x.tick();
        }
        if (this.isFirstMove) {
            this.riddenBase.setTeleportDuration(4);
            this.isFirstMove = false;
        }
    }

    public VirtualElement.InteractionHandler getInteractionHandler(class_3222 player) {
        return VirtualElement.InteractionHandler.EMPTY;
    }

    public void removeHolder(ElementHolder animation) {
        if (this.riddenBase.getHolder() == animation) {
            this.setHolder(null);
        }
    }

    public void setRotation(Quaternionf quaternionf) {
        if (quaternionf.equals(this.itemDisplay[0].getLeftRotation(), 0.05f)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ItemDisplayElement display = this.itemDisplay[i];
            display.setLeftRotation((Quaternionfc)quaternionf);
            boolean e = i % 2 == 1;
            display.setTranslation((Vector3fc)new Vector3f((float)(e ? i : -i) * 0.01f, (float)i * 0.03f, (float)(e ? i : -i) * 0.01f).rotate((Quaternionfc)quaternionf));
            if (!display.isDirty()) continue;
            display.startInterpolation();
        }
    }

    public void checkItems() {
        if (this.stack.method_7947() != this.stackCurrent.method_7947() || class_1799.method_31577((class_1799)this.stack, (class_1799)this.stackCurrent)) {
            this.stackCurrent = this.stack.method_7972();
            for (int i = 0; i < 4; ++i) {
                this.updateDisplay(i);
            }
        }
    }

    public void scale(float v) {
        if (this.globalScale == v) {
            return;
        }
        this.globalScale = v;
        for (int i = 0; i < 4; ++i) {
            this.updateScale(i);
        }
    }
}

