/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.movingitem;

import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SimpleContainer
implements ContainerHolder {
    private static final AddedCallback NOOP_ADD = (a, b, c) -> {};
    private static final RemovedCallback NOOP_REMOVE = (a, b) -> {};
    private final int id;
    @Nullable
    private MovingItem movingItem;
    private AddedCallback added;
    private RemovedCallback removed;

    public SimpleContainer() {
        this(-1, NOOP_ADD, NOOP_REMOVE);
    }

    public SimpleContainer(int id, AddedCallback added, RemovedCallback removed) {
        this.id = id;
        this.added = added;
        this.removed = removed;
    }

    public static void readArray(SimpleContainer[] containers, class_2499 items, class_7225.class_7874 lookup) {
        int l = Math.min(containers.length, items.size());
        for (int i = 0; i < l; ++i) {
            Object object = items.get(i);
            if (!(object instanceof class_2487)) continue;
            class_2487 compound = (class_2487)object;
            containers[i].readNbt(compound, lookup);
        }
    }

    public static class_2520 writeArray(SimpleContainer[] containers, class_7225.class_7874 lookup) {
        class_2499 list = new class_2499();
        for (SimpleContainer cotnainer : containers) {
            list.add((Object)cotnainer.writeNbt(lookup));
        }
        return list;
    }

    public static SimpleContainer[] createArray(int size, AddedCallback added, RemovedCallback removed) {
        SimpleContainer[] arr = new SimpleContainer[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = new SimpleContainer(i, added, removed);
        }
        return arr;
    }

    @Override
    @Nullable
    public MovingItem getContainer() {
        return this.movingItem;
    }

    @Override
    public void setContainer(@Nullable MovingItem container) {
        if (container == null) {
            this.removed.accept(this.movingItem, true);
            this.movingItem = null;
        } else {
            if (this.movingItem != null) {
                this.removed.accept(this.movingItem, true);
            }
            this.movingItem = container;
            this.added.accept(this.id, container, true);
        }
    }

    @Override
    @Nullable
    public MovingItem pullAndRemove() {
        MovingItem x = this.movingItem;
        this.movingItem = null;
        this.removed.accept(x, false);
        return x;
    }

    @Override
    public void pushAndAttach(MovingItem container) {
        if (this.movingItem != null) {
            this.removed.accept(this.movingItem, true);
        }
        this.movingItem = container;
        if (container != null) {
            this.added.accept(this.id, container, false);
        } else {
            this.setContainer(null);
        }
    }

    public class_2520 writeNbt(class_7225.class_7874 lookup) {
        return this.movingItem == null || this.movingItem.method_32327().method_7960() ? new class_2487() : this.movingItem.method_32327().method_57358(lookup);
    }

    public void readNbt(class_2487 compound, class_7225.class_7874 lookup) {
        class_1799 itemStack = FactoryUtil.fromNbtStack(lookup, (class_2520)compound);
        if (itemStack == class_1799.field_8037) {
            this.clearContainer();
        } else {
            this.setContainer(new MovingItem(itemStack));
        }
    }

    public void maybeAdd(ElementHolder model) {
        if (!this.isContainerEmpty()) {
            model.addElement((VirtualElement)this.getContainer());
        }
    }

    public class_1799 getStack() {
        if (this.movingItem != null) {
            return this.movingItem.method_32327();
        }
        return class_1799.field_8037;
    }

    @Nullable
    public class_243 getPos() {
        if (this.movingItem != null) {
            return this.movingItem.getCurrentPos();
        }
        return null;
    }

    public void tick() {
        if (this.movingItem != null) {
            this.movingItem.tick();
        }
    }

    public static interface AddedCallback {
        public void accept(int var1, MovingItem var2, boolean var3);
    }

    public static interface RemovedCallback {
        public void accept(MovingItem var1, boolean var2);
    }
}

