/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.storage;

import eu.pb4.polyfactory.util.storage.EmptyStorage;
import eu.pb4.polyfactory.util.storage.FilteredSingleSlotStorage;
import eu.pb4.polyfactory.util.storage.RedirectingStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilteredRedirectedSlottedStorage<T extends TransferVariant<?>>
implements SlottedStorage<T>,
RedirectingStorage {
    private final Supplier<class_1937> world;
    private final Supplier<class_2338> pos;
    private final Supplier<class_2350> direction;
    private final BlockApiLookup<Storage<T>, class_2350> lookup;
    private final SlottedPredicate<T> predicate;
    private final int[] slotMap;
    private final T defaultValue;

    public FilteredRedirectedSlottedStorage(BlockApiLookup<Storage<T>, @Nullable class_2350> lookup, Supplier<class_1937> world, Supplier<class_2338> pos, Supplier<class_2350> direction, T defaultValue, int[] slotMap, SlottedPredicate<T> predicate) {
        this.slotMap = slotMap;
        this.lookup = lookup;
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.predicate = predicate;
        this.defaultValue = defaultValue;
    }

    @Nullable
    public SlottedStorage<T> getTargetStorage() {
        SlottedStorage s;
        class_2350 dir = this.direction.get();
        Storage storage = (Storage)this.lookup.find(this.world.get(), this.pos.get().method_10093(dir), (Object)dir.method_10153());
        return storage instanceof RedirectingStorage ? null : (storage instanceof SlottedStorage ? (s = (SlottedStorage)storage) : null);
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        long out = 0L;
        for (SingleSlotStorage slot : this.getSlots()) {
            if ((out += slot.insert(resource, maxAmount - out, transaction)) != maxAmount) continue;
            return out;
        }
        return out;
    }

    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        long out = 0L;
        for (SingleSlotStorage slot : this.getSlots()) {
            if ((out += slot.extract(resource, maxAmount - out, transaction)) != maxAmount) continue;
            return out;
        }
        return out;
    }

    @NotNull
    public Iterator<StorageView<T>> iterator() {
        SlottedStorage<T> storage = this.getTargetStorage();
        if (storage == null) {
            return Collections.emptyIterator();
        }
        ArrayList<SingleSlotStorage> slots = new ArrayList<SingleSlotStorage>();
        for (int i = 0; i < this.slotMap.length; ++i) {
            SingleSlotStorage slot;
            int x = this.slotMap[i];
            if (x == -1 || x >= storage.getSlotCount() || !this.predicate.test(i, (TransferVariant)(slot = storage.getSlot(x)).getResource())) continue;
            slots.add(slot);
        }
        return slots.iterator();
    }

    public int getSlotCount() {
        return this.slotMap.length;
    }

    public SingleSlotStorage<T> getSlot(int i) {
        if (this.slotMap[i] == -1) {
            return new EmptyStorage<T>(this.defaultValue);
        }
        SlottedStorage<T> storage = this.getTargetStorage();
        if (storage == null || storage.getSlotCount() >= this.slotMap[i]) {
            return new EmptyStorage<T>(this.defaultValue);
        }
        return new FilteredSingleSlotStorage<T>(storage.getSlot(this.slotMap[i]), i, this.predicate);
    }

    public static interface SlottedPredicate<T> {
        public boolean test(int var1, T var2);
    }
}

