/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.util.storage;

import com.google.common.collect.Iterators;
import eu.pb4.polyfactory.util.storage.RedirectingStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class FilteredRedirectedStorage<T extends TransferVariant<?>>
implements Storage<T>,
RedirectingStorage {
    private final Supplier<class_1937> world;
    private final Supplier<class_2338> pos;
    private final Supplier<class_2350> direction;
    private final BlockApiLookup<Storage<T>, class_2350> lookup;
    private final Predicate<T> predicate;

    public FilteredRedirectedStorage(BlockApiLookup<Storage<T>, @Nullable class_2350> lookup, Supplier<class_1937> world, Supplier<class_2338> pos, Supplier<class_2350> direction, Predicate<T> predicate) {
        this.lookup = lookup;
        this.world = world;
        this.pos = pos;
        this.direction = direction;
        this.predicate = predicate;
    }

    @Nullable
    public Storage<T> getTargetStorage() {
        class_2350 dir = this.direction.get();
        Storage storage = (Storage)this.lookup.find(this.world.get(), this.pos.get().method_10093(dir), (Object)dir.method_10153());
        return storage instanceof RedirectingStorage ? null : storage;
    }

    public long insert(T resource, long maxAmount, TransactionContext transaction) {
        Storage<T> storage = this.getTargetStorage();
        if (storage == null || !this.predicate.test(resource)) {
            return 0L;
        }
        return storage.insert(resource, maxAmount, transaction);
    }

    public long extract(T resource, long maxAmount, TransactionContext transaction) {
        Storage<T> storage = this.getTargetStorage();
        if (storage == null || !this.predicate.test(resource)) {
            return 0L;
        }
        return storage.extract(resource, maxAmount, transaction);
    }

    public Iterator<StorageView<T>> iterator() {
        Storage<T> storage = this.getTargetStorage();
        if (storage == null) {
            return Collections.emptyIterator();
        }
        return Iterators.filter((Iterator)storage.iterator(), this::checkView);
    }

    private boolean checkView(StorageView<T> tStorageView) {
        return this.predicate.test((TransferVariant)tStorageView.getResource());
    }
}

