/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.configurable;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public interface BlockConfigValue<T> {
    public static <T, B> BlockConfigValue<T> ofBlockEntity(final Class<B> beClass, final Function<B, T> getter, final BiConsumer<B, T> setter) {
        return new BlockConfigValue<T>(){

            @Override
            @Nullable
            public T getValue(class_1937 world, class_2338 pos, class_2350 side, class_2680 state) {
                class_2586 be = world.method_8321(pos);
                if (be != null && beClass.isAssignableFrom(be.getClass())) {
                    return getter.apply(be);
                }
                return null;
            }

            @Override
            public boolean setValue(T value, class_1937 world, class_2338 pos, class_2350 side, class_2680 state) {
                class_2586 be = world.method_8321(pos);
                if (be != null && beClass.isAssignableFrom(be.getClass())) {
                    setter.accept(be, value);
                    return true;
                }
                return false;
            }
        };
    }

    public static <T extends Comparable<T>> BlockConfigValue<T> ofProperty(class_2769<T> property) {
        return BlockConfigValue.ofPropertyCustom(property, (propertyx, value, world, pos, side, state) -> (class_2680)state.method_47968(propertyx, value));
    }

    public static <T extends Comparable<T>> BlockConfigValue<T> ofPropertyCustom(final class_2769<T> property, final StateProvider<T> provider) {
        return new BlockConfigValue<T>(){

            @Override
            @Nullable
            public T getValue(class_1937 world, class_2338 pos, class_2350 side, class_2680 state) {
                return state.method_61767(property, null);
            }

            @Override
            public boolean setValue(T value, class_1937 world, class_2338 pos, class_2350 side, class_2680 state) {
                BlockAwareAttachment holder;
                class_2680 newState = provider.getModifiedState(property, value, world, pos, side, state);
                if (newState == state) {
                    return false;
                }
                if (state.method_26204() instanceof FactoryBlock && (holder = BlockAwareAttachment.get((class_1937)world, (class_2338)pos)) != null) {
                    DisplayElement displayElement;
                    Object2IntArrayMap map = new Object2IntArrayMap();
                    Object2IntArrayMap map2 = new Object2IntArrayMap();
                    for (VirtualElement el : holder.holder().getElements()) {
                        if (!(el instanceof DisplayElement)) continue;
                        displayElement = (DisplayElement)el;
                        map.put((Object)displayElement, displayElement.getTeleportDuration());
                        map2.put((Object)displayElement, displayElement.getInterpolationDuration());
                        displayElement.setTeleportDuration(0);
                        displayElement.setInterpolationDuration(0);
                        displayElement.tick();
                    }
                    world.method_8501(pos, newState);
                    for (VirtualElement el : holder.holder().getElements()) {
                        if (!(el instanceof DisplayElement)) continue;
                        displayElement = (DisplayElement)el;
                        displayElement.setTeleportDuration(map.getInt((Object)displayElement));
                        displayElement.setInterpolationDuration(map2.getInt((Object)displayElement));
                        displayElement.tick();
                    }
                    return true;
                }
                world.method_8501(pos, newState);
                return true;
            }
        };
    }

    @Nullable
    public T getValue(class_1937 var1, class_2338 var2, class_2350 var3, class_2680 var4);

    public boolean setValue(T var1, class_1937 var2, class_2338 var3, class_2350 var4, class_2680 var5);

    public static interface StateProvider<T extends Comparable<T>> {
        public class_2680 getModifiedState(class_2769<T> var1, T var2, class_1937 var3, class_2338 var4, class_2350 var5, class_2680 var6);
    }
}

