/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.data.AbstracterCableBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.property.FactoryProperties;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.nodes.data.DataStorage;
import eu.pb4.polyfactory.nodes.generic.SelectiveSideNode;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCableBlock
extends AbstracterCableBlock {
    public static final int DEFAULT_COLOR = 0xBBBBBB;
    public static final class_2746 HAS_CABLE = class_2746.method_11825((String)"has_cable");
    public static final class_2746 NORTH = class_2741.field_12489;
    public static final class_2746 EAST = class_2741.field_12487;
    public static final class_2746 SOUTH = class_2741.field_12540;
    public static final class_2746 WEST = class_2741.field_12527;
    public static final class_2746 UP = class_2741.field_12519;
    public static final class_2746 DOWN = class_2741.field_12546;
    public static final Map<class_2350, class_2746> FACING_PROPERTIES = FactoryProperties.DIRECTIONS;

    public AbstractCableBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)UP, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @Override
    public boolean setColor(class_2680 state, class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.CABLE.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            class_2680 newState = state;
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                newState = (class_2680)newState.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(!this.isDirectionBlocked(state, dir) && this.canConnectTo((class_4538)world, provider.getColor(), newPos, block, dir.method_10153())));
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
            return true;
        }
        return false;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        boolean hasReceivers = false;
        boolean hasProviders = false;
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            class_2680 newState = state;
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                if (this.isDirectionBlocked(state, dir) || !this.canConnectTo((class_4538)world, be.getColor(), newPos, block, dir.method_10153())) continue;
                newState = (class_2680)newState.method_11657((class_2769)FACING_PROPERTIES.get(dir), (Comparable)Boolean.valueOf(true));
                if (!(placer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)placer;
                if (hasReceivers && hasProviders) continue;
                DataStorage net = NetworkComponent.Data.getLogic(serverPlayer.method_51469(), newPos);
                if (net.hasReceivers()) {
                    hasReceivers = true;
                }
                if (!net.hasProviders()) continue;
                hasProviders = true;
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
        }
        if (hasReceivers && hasProviders) {
            TriggerCriterion.trigger((class_3222)((class_3222)placer), (class_2960)FactoryTriggers.CABLE_CONNECT);
        }
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        return this.isDirectionBlocked(state, direction) ? state : (class_2680)state.method_11657((class_2769)FACING_PROPERTIES.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(world, AbstractCableBlock.getColor(world, pos), neighborPos, neighborState, direction.method_10153())));
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    @Override
    public Collection<BlockNode> createEnergyNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getDirections(state)));
    }

    @Override
    public EnumSet<class_2350> getDirections(class_2680 state) {
        ArrayList<class_2350> list = new ArrayList<class_2350>(6);
        for (class_2350 dir : class_2350.values()) {
            if (!((Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(dir))).booleanValue() || this.isDirectionBlocked(state, dir)) continue;
            list.add(dir);
        }
        return list.isEmpty() ? EnumSet.noneOf(class_2350.class) : EnumSet.copyOf(list);
    }

    @Override
    protected boolean checkModelDirection(class_2680 state, class_2350 direction) {
        return (Boolean)state.method_11654((class_2769)FACING_PROPERTIES.get(direction));
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return FactoryUtil.rotate(state, NORTH, SOUTH, EAST, WEST, rotation);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return FactoryUtil.mirror(state, NORTH, SOUTH, EAST, WEST, mirror);
    }
}

