/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.DataReceiver;
import eu.pb4.polyfactory.block.data.InputTransformerBlockEntity;
import eu.pb4.polyfactory.block.data.util.DataNetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.nodes.data.ChannelProviderDirectionNode;
import eu.pb4.polyfactory.nodes.data.ChannelReceiverDirectionNode;
import eu.pb4.polyfactory.nodes.data.DataProviderNode;
import eu.pb4.polyfactory.nodes.data.DataReceiverNode;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class InputTransformerBlock
extends DataNetworkBlock
implements class_2343,
FactoryBlock,
CableConnectable,
DataProvider,
DataReceiver,
ConfigurableBlock {
    public static final class_2754<class_2350> FACING_INPUT = class_2754.method_11850((String)"facing_input", class_2350.class);
    public static final class_2754<class_2350> FACING_OUTPUT = class_2754.method_11850((String)"facing_output", class_2350.class);
    protected static final List<BlockConfig<?>> BLOCK_CONFIG = List.of(BlockConfig.ofDirection(FACING_INPUT), BlockConfig.ofChannelWithDisabled("channel_input", InputTransformerBlockEntity.class, InputTransformerBlockEntity::inputChannel, InputTransformerBlockEntity::setInputChannel), BlockConfig.ofDirection(FACING_OUTPUT), BlockConfig.ofChannel("channel_output", InputTransformerBlockEntity.class, InputTransformerBlockEntity::outputChannel, InputTransformerBlockEntity::setOutputChannel));

    public InputTransformerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 facing = ctx.method_7715().method_10153();
        return (class_2680)((class_2680)this.method_9564().method_11657(FACING_OUTPUT, (Comparable)facing.method_10153())).method_11657(FACING_INPUT, (Comparable)facing);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING_INPUT, FACING_OUTPUT});
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10085.method_9564();
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new InputTransformerBlockEntity(pos, state);
    }

    @Override
    public boolean canCableConnect(class_4538 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654(FACING_INPUT) == dir || state.method_11654(FACING_OUTPUT) == dir;
    }

    @Override
    @Nullable
    public DataContainer provideData(class_3218 world, class_2338 selfPos, class_2680 selfState, int channel, DataProviderNode node) {
        class_2586 class_25862 = world.method_8321(selfPos);
        if (class_25862 instanceof InputTransformerBlockEntity) {
            InputTransformerBlockEntity be = (InputTransformerBlockEntity)class_25862;
            return be.lastOutput();
        }
        return null;
    }

    @Override
    public boolean receiveData(class_3218 world, class_2338 selfPos, class_2680 selfState, int channel, DataContainer data, DataReceiverNode node, class_2338 sourcePos, @Nullable class_2350 sourceDir) {
        if (node instanceof ChannelReceiverDirectionNode) {
            ChannelReceiverDirectionNode direction = (ChannelReceiverDirectionNode)node;
            class_2586 class_25862 = world.method_8321(selfPos);
            if (class_25862 instanceof InputTransformerBlockEntity) {
                InputTransformerBlockEntity be = (InputTransformerBlockEntity)class_25862;
                DataContainer input = be.lastInput();
                boolean matchingData = false;
                if (direction.direction() == selfState.method_11654(FACING_INPUT) && channel == be.inputChannel()) {
                    input = be.setLastInput(data);
                    matchingData = true;
                }
                if (matchingData) {
                    this.sendData((class_1936)world, (class_2350)selfState.method_11654(FACING_OUTPUT), selfPos, this.transformData(input, world, selfPos, selfState, be));
                    return true;
                }
            }
        }
        return false;
    }

    protected abstract DataContainer transformData(DataContainer var1, class_3218 var2, class_2338 var3, class_2680 var4, InputTransformerBlockEntity var5);

    public int sendData(class_1936 world, class_2350 direction, class_2338 selfPos, DataContainer data) {
        if (data != null && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_2586 class_25862 = world.method_8321(selfPos);
            if (class_25862 instanceof InputTransformerBlockEntity) {
                InputTransformerBlockEntity be = (InputTransformerBlockEntity)class_25862;
                be.setLastOutput(data);
                return NetworkComponent.Data.getLogic(serverWorld, selfPos, x -> {
                    ChannelProviderDirectionNode p;
                    BlockNode patt0$temp = x.getNode();
                    return patt0$temp instanceof ChannelProviderDirectionNode && (p = (ChannelProviderDirectionNode)patt0$temp).channel() == be.outputChannel() && p.direction() == direction;
                }).pushDataUpdate(selfPos, be.outputChannel(), data, direction);
            }
        }
        return 0;
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof InputTransformerBlockEntity) {
            InputTransformerBlockEntity be = (InputTransformerBlockEntity)class_25862;
            return List.of(new ChannelReceiverDirectionNode((class_2350)state.method_11654(FACING_INPUT), be.inputChannel()), new ChannelProviderDirectionNode((class_2350)state.method_11654(FACING_OUTPUT), be.outputChannel()));
        }
        return List.of();
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return BLOCK_CONFIG;
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public static class Model
    extends BlockModel {
        public static final class_1799 INPUT = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/data_cube_connector_input"));
        public static final class_1799 OUTPUT = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/data_cube_connector_output"));
        private final ItemDisplayElement base;
        private final ItemDisplayElement input;
        private final ItemDisplayElement output;

        private Model(class_2680 state) {
            this.base = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.base.setScale((Vector3fc)new Vector3f(2.0f));
            this.input = ItemDisplayElementUtil.createSimple((class_1799)INPUT);
            this.output = ItemDisplayElementUtil.createSimple((class_1799)OUTPUT);
            this.updateStatePos(state, FACING_INPUT, this.input);
            this.updateStatePos(state, FACING_OUTPUT, this.output);
            this.addElement((VirtualElement)this.base);
            this.addElement((VirtualElement)this.input);
            this.addElement((VirtualElement)this.output);
        }

        private void updateStatePos(class_2680 state, class_2754<class_2350> property, ItemDisplayElement element) {
            class_2350 dir = (class_2350)state.method_11654(property);
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            element.setYaw(y);
            element.setPitch(p);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                class_2680 state = this.blockState();
                this.updateStatePos(state, FACING_INPUT, this.input);
                this.updateStatePos(state, FACING_OUTPUT, this.output);
                this.input.tick();
                this.output.tick();
            }
        }
    }
}

