/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data;

import com.mojang.serialization.MapCodec;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.data.AbstracterCableBlock;
import eu.pb4.polyfactory.block.data.CableBlockEntity;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.StatePropertiesCodecPatcher;
import eu.pb4.polyfactory.block.other.XInWallBlock;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.mixin.util.WallBlockAccessor;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.nodes.data.DataStorage;
import eu.pb4.polyfactory.util.BlockStateNameProvider;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polymer.virtualentity.api.BlockWithElementHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2544;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class WallWithCableBlock
extends AbstracterCableBlock
implements BlockStateNameProvider,
StatePropertiesCodecPatcher,
XInWallBlock {
    public static final Map<class_2248, WallWithCableBlock> MAP = new IdentityHashMap<class_2248, WallWithCableBlock>();
    public static final class_2746 UP_WALL = class_2746.method_11825((String)"up_wall");
    public static final class_2754<Side> EAST_SHAPE = class_2754.method_11850((String)"east", Side.class);
    public static final class_2754<Side> NORTH_SHAPE = class_2754.method_11850((String)"north", Side.class);
    public static final class_2754<Side> SOUTH_SHAPE = class_2754.method_11850((String)"south", Side.class);
    public static final class_2754<Side> WEST_SHAPE = class_2754.method_11850((String)"west", Side.class);
    private static final List<Pair> SELF_TO_BACKING = List.of(new Pair<Side, class_4778>((class_2769<Side>)EAST_SHAPE, (class_2769<class_4778>)class_2544.field_55815, x -> x == Side.WALL ? class_4778.field_22180 : class_4778.field_22178, x -> x == class_4778.field_22178 ? Side.NONE : Side.WALL), new Pair<Side, class_4778>((class_2769<Side>)WEST_SHAPE, (class_2769<class_4778>)class_2544.field_55818, x -> x == Side.WALL ? class_4778.field_22180 : class_4778.field_22178, x -> x == class_4778.field_22178 ? Side.NONE : Side.WALL), new Pair<Side, class_4778>((class_2769<Side>)SOUTH_SHAPE, (class_2769<class_4778>)class_2544.field_55817, x -> x == Side.WALL ? class_4778.field_22180 : class_4778.field_22178, x -> x == class_4778.field_22178 ? Side.NONE : Side.WALL), new Pair<Side, class_4778>((class_2769<Side>)NORTH_SHAPE, (class_2769<class_4778>)class_2544.field_55816, x -> x == Side.WALL ? class_4778.field_22180 : class_4778.field_22178, x -> x == class_4778.field_22178 ? Side.NONE : Side.WALL), new Pair(UP_WALL, class_2544.field_11717, Function.identity(), Function.identity()));
    private final class_2544 backing;

    @Nullable
    public static class_2680 fromWall(class_2680 source) {
        WallWithCableBlock block = MAP.get(source.method_26204());
        if (block == null) {
            return null;
        }
        class_2680 state = block.method_9564();
        for (Pair prop : SELF_TO_BACKING) {
            state = (class_2680)state.method_11657(prop.self, (Comparable)prop.backingToSelf.apply(source.method_11654(prop.backing)));
        }
        return state;
    }

    public WallWithCableBlock(class_4970.class_2251 settings, class_2544 wallBlock) {
        super(settings);
        this.backing = wallBlock;
        this.method_9590(this.method_9564());
        MAP.put((class_2248)wallBlock, this);
    }

    @Override
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return this.backing.method_9564().method_65171(world, pos, includeData);
    }

    @Override
    public EnumSet<class_2350> getDirections(class_2680 state) {
        return EnumSet.allOf(class_2350.class);
    }

    @Override
    protected boolean isDirectionBlocked(class_2680 state, class_2350 direction) {
        return false;
    }

    @Override
    protected boolean checkModelDirection(class_2680 state, class_2350 direction) {
        return direction.method_10166() != class_2350.class_2351.field_11052 && state.method_11654(this.getProperty(direction)) == Side.CABLE;
    }

    @Override
    public boolean setColor(class_2680 state, class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.CABLE.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            class_2680 newState = state;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                class_2769<Side> prop = this.getProperty(dir);
                newState = (class_2680)newState.method_11657(prop, (Comparable)((Object)((Side)((Object)newState.method_11654(prop))).cable(this.canConnectTo((class_4538)world, provider.getColor(), newPos, block, dir.method_10153()))));
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
            return true;
        }
        return false;
    }

    private class_2769<Side> getProperty(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            default -> null;
        };
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        boolean hasReceivers = false;
        boolean hasProviders = false;
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            class_2680 newState = state;
            for (class_2350 dir : class_2350.values()) {
                class_2338 newPos = pos.method_10093(dir);
                class_2680 block = world.method_8320(newPos);
                if (!this.canConnectTo((class_4538)world, be.getColor(), newPos, block, dir.method_10153())) continue;
                if (dir.method_10166() != class_2350.class_2351.field_11052) {
                    newState = (class_2680)newState.method_11657(this.getProperty(dir), (Comparable)((Object)((Side)((Object)newState.method_11654(this.getProperty(dir)))).cable(true)));
                }
                if (!(placer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)placer;
                if (hasReceivers && hasProviders) continue;
                DataStorage net = NetworkComponent.Data.getLogic(serverPlayer.method_51469(), newPos);
                if (net.hasReceivers()) {
                    hasReceivers = true;
                }
                if (!net.hasProviders()) continue;
                hasProviders = true;
            }
            if (state != newState) {
                world.method_8501(pos, newState);
            }
        }
        if (hasReceivers && hasProviders) {
            TriggerCriterion.trigger((class_3222)((class_3222)placer), (class_2960)FactoryTriggers.CABLE_CONNECT);
        }
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 x = this.backing.method_9605(ctx);
        class_2680 state = this.method_9564();
        for (Pair prop : SELF_TO_BACKING) {
            assert (x != null);
            state = (class_2680)state.method_11657(prop.self, (Comparable)prop.backingToSelf.apply(x.method_11654(prop.backing)));
        }
        return state;
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2680 x = ((WallBlockAccessor)this.backing).callGetStateForNeighborUpdate(this.getPolymerBlockState(state, null), world, tickView, pos, direction, neighborPos, neighborState, random);
        for (Pair prop : SELF_TO_BACKING) {
            assert (x != null);
            Comparable val = (Comparable)prop.backingToSelf.apply(x.method_11654(prop.backing));
            state = (class_2680)state.method_11657(prop.self, val);
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider) {
            ColorProvider be = (ColorProvider)class_25862;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2769<Side> prop = this.getProperty(dir);
                class_2338 nextPos = pos.method_10093(dir);
                boolean val = this.canConnectTo(world, be.getColor(), nextPos, world.method_8320(nextPos), dir.method_10153());
                state = (class_2680)state.method_11657(prop, (Comparable)((Object)((Side)((Object)state.method_11654(prop))).cable(val)));
            }
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{EAST_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, UP_WALL});
    }

    protected boolean isTransparent(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        return this.getPolymerBlockState(state, null).method_26165(player, world, pos);
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        list.addAll(this.getPolymerBlockState(state, null).method_26189(builder));
        list.addAll(FactoryBlocks.CABLE.method_9564().method_26189(builder));
        return list;
    }

    @Override
    public class_2680 convertToBacking(class_2680 state) {
        class_2680 backing = this.backing.method_9564();
        for (Pair x : SELF_TO_BACKING) {
            backing = (class_2680)backing.method_11657(x.backing, (Comparable)x.selfToBacking.apply(state.method_11654(x.self)));
        }
        return backing;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CableBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        ElementHolder elementHolder;
        class_2680 converted = this.convertToBacking(initialBlockState);
        BlockWithElementHolder blockWithElementHolder = BlockWithElementHolder.get((class_2680)converted);
        if (blockWithElementHolder instanceof BlockWithElementHolder) {
            BlockWithElementHolder holder = blockWithElementHolder;
            elementHolder = holder.createElementHolder(world, pos, converted);
        } else {
            elementHolder = null;
        }
        ElementHolder elementHolder2 = elementHolder;
        return new Model(initialBlockState, elementHolder2, this::convertToBacking);
    }

    public class_5250 method_9518() {
        return class_2561.method_43469((String)"block.polyfactory.wall_with_cable", (Object[])new Object[]{this.backing.method_9518()});
    }

    @Override
    public class_2561 getName(class_3218 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        ColorProvider be;
        if (blockEntity instanceof ColorProvider && !(be = (ColorProvider)blockEntity).isDefaultColor()) {
            if (!DyeColorExtra.hasLang(be.getColor())) {
                return class_2561.method_43469((String)"block.polyfactory.wall_with_cable.colored.full", (Object[])new Object[]{this.backing.method_9518(), ColoredItem.getColorName(be.getColor()), ColoredItem.getHexName(be.getColor())});
            }
            return class_2561.method_43469((String)"block.polyfactory.wall_with_cable.colored", (Object[])new Object[]{this.backing.method_9518(), ColoredItem.getColorName(be.getColor())});
        }
        return this.method_9518();
    }

    public class_2544 backing() {
        return this.backing;
    }

    @Override
    public MapCodec<class_2680> modifyPropertiesCodec(MapCodec<class_2680> codec) {
        return StatePropertiesCodecPatcher.modifier(codec, (state, ops, input) -> {
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                Object wall = input.get(dir.method_15434() + "_wall");
                Object cable = input.get(dir.method_15434());
                if (wall == null || cable == null) continue;
                state = (class_2680)state.method_11657(this.getProperty(dir), (Comparable)((Object)Side.NONE.wall(((String)ops.getStringValue(wall).getOrThrow()).equals("true")).cable(((String)ops.getStringValue(cable).getOrThrow()).equals("true"))));
            }
            return state;
        });
    }

    private record Pair<A extends Comparable<A>, B extends Comparable<B>>(class_2769<A> self, class_2769<B> backing, Function<A, B> selfToBacking, Function<B, A> backingToSelf) {
    }

    public static enum Side implements class_3542
    {
        NONE("none"),
        WALL("wall"),
        CABLE("cable");

        private final String name;

        private Side(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public Side cable(boolean val) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> {
                    if (val) {
                        yield CABLE;
                    }
                    yield NONE;
                }
                case 1 -> WALL;
            };
        }

        public Side wall(boolean val) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> {
                    if (val) {
                        yield WALL;
                    }
                    yield this;
                }
                case 1 -> val ? WALL : NONE;
            };
        }
    }

    public static final class Model
    extends AbstracterCableBlock.BaseCableModel {
        @Nullable
        private final XInWallBlock.ProxyAttachement proxied;

        public Model(class_2680 state, @Nullable ElementHolder elementHolder, Function<class_2680, class_2680> convertToBacking) {
            super(state);
            if (elementHolder != null) {
                this.proxied = new XInWallBlock.ProxyAttachement((ElementHolder)this, elementHolder, () -> (class_2680)convertToBacking.apply(this.blockState()));
                elementHolder.setAttachment((HolderAttachment)this.proxied);
                this.addElement(this.proxied);
            } else {
                this.proxied = null;
            }
        }

        @Override
        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            super.notifyUpdate(updateType);
            if (this.proxied != null) {
                this.proxied.holder().notifyUpdate(updateType);
            }
        }

        @Override
        public class_1799 getModel(class_2680 state, BiPredicate<class_2680, class_2350> directionPredicate) {
            return FactoryModels.COLORED_WALL_CABLE.get(state, directionPredicate).method_7972();
        }
    }
}

