/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.io;

import com.google.common.collect.ImmutableList;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.data.DoubleInputTransformerBlock;
import eu.pb4.polyfactory.block.data.DoubleInputTransformerBlockEntity;
import eu.pb4.polyfactory.data.BoolData;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.InvalidData;
import eu.pb4.polyfactory.util.FactoryUtil;
import java.util.List;
import java.util.function.IntPredicate;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4970;

public class DataComparatorBlock
extends DoubleInputTransformerBlock {
    public static final class_2754<Operation> OPERATION = class_2754.method_11850((String)"operation", Operation.class);
    public static final class_2746 STRICT = class_2746.method_11825((String)"strict");
    public static final List<BlockConfig<?>> WRENCH_ACTIONS = ImmutableList.builder().addAll(DoubleInputTransformerBlock.WRENCH_ACTIONS).add(BlockConfig.of("operation", OPERATION, (t, world, pos, side, state) -> t.text)).add(BlockConfig.of("strict", STRICT)).build();

    public DataComparatorBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(OPERATION, (Comparable)((Object)Operation.EQUAL))).method_11657((class_2769)STRICT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{OPERATION});
        builder.method_11667(new class_2769[]{STRICT});
    }

    protected int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 class_25862;
        if (state.method_11654((class_2769)FACING_OUTPUT) == direction.method_10153() && (class_25862 = world.method_8321(pos)) instanceof DoubleInputTransformerBlockEntity) {
            DoubleInputTransformerBlockEntity be = (DoubleInputTransformerBlockEntity)class_25862;
            return be.lastOutput().isTrue() ? 15 : 0;
        }
        return 0;
    }

    protected boolean method_9506(class_2680 state) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        if (state.method_27852(oldState.method_26204()) && state.method_11654(OPERATION) != oldState.method_11654(OPERATION) && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof DoubleInputTransformerBlockEntity) {
                DoubleInputTransformerBlockEntity be = (DoubleInputTransformerBlockEntity)class_25862;
                this.sendData((class_1936)world, (class_2350)state.method_11654((class_2769)FACING_OUTPUT), pos, this.transformData(be.lastInput1(), be.lastInput2(), serverWorld, pos, state, be));
                return;
            }
        }
        world.method_8452(pos, (class_2248)this, null);
    }

    @Override
    public int sendData(class_1936 world, class_2350 direction, class_2338 selfPos, DataContainer data) {
        int i = super.sendData(world, direction, selfPos, data);
        if (world instanceof class_1937) {
            class_1937 w = (class_1937)world;
            w.method_8452(selfPos, (class_2248)this, null);
        }
        return i;
    }

    @Override
    protected DataContainer transformData(DataContainer input1, DataContainer input2, class_3218 world, class_2338 selfPos, class_2680 selfState, DoubleInputTransformerBlockEntity be) {
        Operation action = (Operation)((Object)selfState.method_11654(OPERATION));
        Boolean strict = (Boolean)selfState.method_11654((class_2769)STRICT);
        class_1657 class_16572 = FactoryUtil.getClosestPlayer((class_1937)world, selfPos, 16.0);
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.DATA_COMPARATOR);
        }
        if (input1.getClass() == input2.getClass() && (action == Operation.EQUAL || action == Operation.NOT_EQUAL)) {
            return BoolData.of(input1.equals(input2) == (action == Operation.EQUAL));
        }
        if (strict.booleanValue() && input1.type() != input2.type()) {
            return new InvalidData("mismatched input");
        }
        return BoolData.of(action.predicate.test(input1.compareTo(input2)));
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return WRENCH_ACTIONS;
    }

    public static enum Operation implements class_3542
    {
        EQUAL("equal", i -> i == 0),
        NOT_EQUAL("not_equal", i -> i != 0),
        LESS_THAN("less_than", i -> i < 0),
        LESS_OR_EQUAL("less_or_equal", i -> i <= 0),
        MORE_THAN("more_than", i -> i > 0),
        MORE_OR_EQUAL("more_or_equal", i -> i >= 0);

        private final String name;
        private final IntPredicate predicate;
        public final class_2561 text;

        private Operation(String name, IntPredicate predicate) {
            this.name = name;
            this.predicate = predicate;
            this.text = class_2561.method_43471((String)("item.polyfactory.wrench.action.operation.comparator." + name));
        }

        public String method_15434() {
            return this.name;
        }
    }
}

