/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.output;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.QuickWaterloggable;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.BlockValueFormatter;
import eu.pb4.polyfactory.block.configurable.ConfigurableBlock;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.data.ChannelContainer;
import eu.pb4.polyfactory.block.data.DataReceiver;
import eu.pb4.polyfactory.block.data.util.ChanneledDataBlockEntity;
import eu.pb4.polyfactory.block.data.util.DataCache;
import eu.pb4.polyfactory.block.data.util.DataNetworkBlock;
import eu.pb4.polyfactory.block.property.ValueModifier;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.nodes.data.ChannelReceiverDirectionNode;
import eu.pb4.polyfactory.nodes.data.DataReceiverNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_10225;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5000;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class GaugeBlock
extends DataNetworkBlock
implements FactoryBlock,
ConfigurableBlock,
class_2343,
CableConnectable,
DataReceiver,
PolymerTexturedBlock,
QuickWaterloggable {
    public static final class_2754<class_5000> ORIENTATION = class_2741.field_23333;
    public static final class_2754<Style> STYLE = class_2754.method_11850((String)"style", Style.class);
    public static final class_2754<HandPosition> HAND_POSITION = class_2754.method_11850((String)"hand_position", HandPosition.class);
    public static final class_2754<ValueModifier> VALUE_MODIFIER = class_2754.method_11850((String)"value_modifier", ValueModifier.class);
    private static final BlockConfig<Style> STYLE_CONFIG = BlockConfig.of(STYLE);
    private static final BlockConfig<ValueModifier> VALUE_MODIFIER_CONFIG = BlockConfig.of(VALUE_MODIFIER, BlockValueFormatter.text(ValueModifier::text));
    private static final BlockConfig<HandPosition> HAND_POSITION_CONFIG = BlockConfig.of(HAND_POSITION, BlockValueFormatter.text(HandPosition::text));

    public GaugeBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(HAND_POSITION, (Comparable)((Object)HandPosition.LEFT))).method_11657(VALUE_MODIFIER, (Comparable)((Object)ValueModifier.ABSOLUTE))).method_11657(STYLE, (Comparable)((Object)Style.DEFAULT)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED, ORIENTATION, HAND_POSITION, VALUE_MODIFIER, STYLE});
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new ChannelReceiverDirectionNode(((class_5000)state.method_11654(ORIENTATION)).method_26426().method_10153(), this.getChannel(world, pos)));
    }

    @Override
    public boolean receiveData(class_3218 world, class_2338 selfPos, class_2680 selfState, int channel, DataContainer data, @Nullable DataReceiverNode node, class_2338 sourcePos, @Nullable class_2350 sourceDir) {
        ElementHolder elementHolder;
        BlockAwareAttachment x;
        class_2586 class_25862 = world.method_8321(selfPos);
        if (class_25862 instanceof DataCache) {
            DataCache cache = (DataCache)class_25862;
            cache.setCachedData(data);
        }
        if ((x = BlockAwareAttachment.get((class_1937)world, (class_2338)selfPos)) == null || !((elementHolder = x.holder()) instanceof Model)) {
            return false;
        }
        Model model = (Model)elementHolder;
        model.setRotation(data.asProgress(), false);
        return true;
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return ((Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? FactoryUtil.TRAPDOOR_WATERLOGGED : FactoryUtil.TRAPDOOR_REGULAR).get(((class_5000)state.method_11654(ORIENTATION)).method_26426());
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2350 dir = ctx.method_8038();
        class_2350 dir2 = switch (dir) {
            case class_2350.field_11033 -> ctx.method_8042();
            case class_2350.field_11036 -> ctx.method_8042().method_10153();
            default -> class_2350.field_11036;
        };
        return this.waterLog(ctx, (class_2680)this.method_9564().method_11657(ORIENTATION, (Comparable)class_5000.method_26425((class_2350)dir, (class_2350)dir2)));
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        this.tickWater(state, world, tickView, pos);
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.CHANNEL, HAND_POSITION_CONFIG, VALUE_MODIFIER_CONFIG, STYLE_CONFIG);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2338 back = pos.method_10093(((class_5000)state.method_11654(ORIENTATION)).method_26426().method_10153());
        world.method_8455(back, world.method_8320(back).method_26204());
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ChanneledDataBlockEntity(pos, state);
    }

    protected int getChannel(class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ChannelContainer) {
            ChannelContainer container = (ChannelContainer)class_25862;
            return container.channel();
        }
        return 0;
    }

    @Override
    public boolean canCableConnect(class_4538 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        return ((class_5000)state.method_11654(ORIENTATION)).method_26426().method_10153() == dir;
    }

    public static enum HandPosition implements class_3542
    {
        LEFT("left", -0.5f),
        CENTER("center", 0.0f),
        RIGHT("right", 0.5f);

        private final String name;
        private final float value;

        private HandPosition(String name, float value) {
            this.name = name;
            this.value = value;
        }

        public class_2561 text() {
            return class_2561.method_43471((String)("text.polyfactory.direction." + this.name));
        }

        public String method_15434() {
            return this.name;
        }

        public float value() {
            return this.value;
        }
    }

    public static enum Style implements class_3542
    {
        DEFAULT("default"),
        RED_GREEN("red_green"),
        GREEN_RED("green_red");

        private final String name;
        private final class_1799 model;

        private Style(String name) {
            this.name = name;
            this.model = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/gauge" + (String)(name.equals("default") ? "" : "_" + name)));
        }

        public String method_15434() {
            return this.name;
        }
    }

    public static class Model
    extends BlockModel
    implements ChanneledDataBlockEntity.InitDataListener {
        private static final class_1799 HAND = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/gauge_hand"));
        private final ItemDisplayElement base;
        private final ItemDisplayElement hand = ItemDisplayElementUtil.createSimple((class_1799)HAND);
        private ValueModifier modifier;
        private float targetAngle = 0.0f;
        private float currentAngle = 0.0f;
        private float position;
        private float progress;

        protected Model(class_2680 state) {
            this.base = ItemDisplayElementUtil.createSimple();
            this.base.setScale((Vector3fc)new Vector3f(2.0f));
            this.base.setTranslation((Vector3fc)new Vector3f(0.0f, 0.0f, -0.4375f));
            this.hand.setTranslation(this.base.getTranslation());
            this.hand.setInterpolationDuration(1);
            this.hand.setItem(HAND);
            this.position = ((HandPosition)((Object)state.method_11654(HAND_POSITION))).value();
            this.modifier = (ValueModifier)((Object)state.method_11654(VALUE_MODIFIER));
            this.updateStatePos(state);
            this.setRotation(0.0f, true);
            this.addElement((VirtualElement)this.base);
            this.addElement((VirtualElement)this.hand);
        }

        protected void updateStatePos(class_2680 state) {
            this.base.setItem(((Style)((Object)state.method_11654(GaugeBlock.STYLE))).model);
            class_5000 orientation = (class_5000)state.method_11654(ORIENTATION);
            class_2350 dir = orientation.method_26426();
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() == class_2350.class_2351.field_11052) {
                if (dir == class_2350.field_11033) {
                    p = 90.0f;
                }
                y = orientation.method_26428().method_10144();
            } else {
                p = 0.0f;
                y = dir.method_10144();
            }
            this.base.setYaw(y);
            this.base.setPitch(p);
            this.hand.setPitch(p);
            this.hand.setYaw(y);
        }

        public void setRotation(float progress, boolean force) {
            this.progress = progress;
            this.targetAngle = this.calculateAngle(progress);
            if (force) {
                this.currentAngle = this.targetAngle;
                this.hand.setLeftRotation((Quaternionfc)new Quaternionf().rotateZ(this.targetAngle));
            }
        }

        private float calculateAngle(float progress) {
            return class_3532.method_15363((float)(-this.modifier.apply(progress) - this.position), (float)-0.5f, (float)0.5f) * 2.0f * 125.0f * ((float)Math.PI / 180);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
                this.position = ((HandPosition)((Object)this.blockState().method_11654(HAND_POSITION))).value();
                this.modifier = (ValueModifier)((Object)this.blockState().method_11654(VALUE_MODIFIER));
                this.targetAngle = this.calculateAngle(this.progress);
            }
        }

        protected void onTick() {
            float newAngle = class_3532.method_16439((float)0.3f, (float)this.currentAngle, (float)this.targetAngle);
            if ((double)Math.abs(this.currentAngle - newAngle) < 0.001) {
                return;
            }
            this.currentAngle = newAngle;
            this.hand.setLeftRotation((Quaternionfc)new Quaternionf().rotateZ(newAngle));
            this.hand.startInterpolationIfDirty();
        }

        @Override
        public void provideInitialCachedData(DataContainer lastData) {
            this.setRotation(lastData.asProgress(), true);
        }
    }
}

