/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.output;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.polyfactory.block.data.DataReceiver;
import eu.pb4.polyfactory.block.data.util.DirectionalCabledDataBlock;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.ListData;
import eu.pb4.polyfactory.data.SoundEventData;
import eu.pb4.polyfactory.nodes.data.DataReceiverNode;
import eu.pb4.polyfactory.nodes.data.SpeakerNode;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4970;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlock
extends DirectionalCabledDataBlock
implements DataReceiver {
    public SpeakerBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SpeakerNode((class_2350)state.method_11654((class_2769)FACING), this.getDirections(state), this.getChannel(world, pos)));
    }

    @Override
    public boolean receiveData(class_3218 world, class_2338 selfPos, class_2680 selfState, int channel, DataContainer data, DataReceiverNode node, class_2338 sourcePos, @Nullable class_2350 sourceDir) {
        ElementHolder elementHolder;
        if (data.isEmpty()) {
            return false;
        }
        BlockAwareAttachment x = BlockAwareAttachment.get((class_1937)world, (class_2338)selfPos);
        if (x == null || !((elementHolder = x.holder()) instanceof Model)) {
            return false;
        }
        Model model = (Model)elementHolder;
        if (data instanceof ListData) {
            ListData listData = (ListData)data;
            return listData.forEachFlatBool(d -> this.playNote((DataContainer)d, model, selfPos, selfState, world));
        }
        return this.playNote(data, model, selfPos, selfState, world);
    }

    private boolean playNote(DataContainer data, Model model, class_2338 selfPos, class_2680 selfState, class_3218 world) {
        class_6880 soundEvent = class_7923.field_41172.method_47983((Object)class_3417.field_42593);
        float volume = 1.0f;
        float pitch = 1.0f;
        long seed = 0L;
        if (data instanceof SoundEventData) {
            SoundEventData soundEventData = (SoundEventData)data;
            soundEvent = soundEventData.soundEvent();
            volume = soundEventData.volume();
            pitch = soundEventData.pitch();
            seed = soundEventData.seed();
        } else {
            boolean notFound = true;
            String[] parts = data.asString().split(" ", 4);
            if (parts.length != 0) {
                try {
                    class_2766 instrument = class_2766.valueOf((String)parts[0].toUpperCase(Locale.ROOT));
                    soundEvent = instrument.method_11886();
                    notFound = false;
                    if (parts.length >= 2) {
                        try {
                            pitch = Float.parseFloat(parts[1]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (parts.length >= 3) {
                        try {
                            volume = Float.parseFloat(parts[2]);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (notFound) {
                return false;
            }
        }
        model.playSound(soundEvent, Math.min(volume, 1.5f), pitch, seed);
        class_243 facing = class_243.method_24953((class_2382)selfPos).method_43206((class_2350)selfState.method_11654((class_2769)FACING), 0.6);
        world.method_65096((class_2394)class_2398.field_11224, facing.field_1352, facing.field_1351, facing.field_1350, 0, (double)(pitch / 24.0f), 0.0, 0.0, 1.0);
        return true;
    }

    @Override
    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public static class Model
    extends DirectionalCabledDataBlock.Model {
        private final ItemDisplayElement soundSource = new ItemDisplayElement();

        protected Model(class_2680 state) {
            super(state);
            this.soundSource.setInvisible(true);
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.soundSource);
        }

        @Override
        protected void updateStatePos(class_2680 state) {
            super.updateStatePos(state);
            if (this.soundSource != null) {
                this.soundSource.setOffset(((class_2350)state.method_11654(DirectionalCabledDataBlock.FACING)).method_62676().method_1021(0.5));
            }
        }

        public void playSound(class_6880<class_3414> sound, float volume, float pitch, long seed) {
            this.sendPacket((class_2596)VirtualEntityUtils.createPlaySoundFromEntityPacket((int)this.soundSource.getEntityId(), sound, (class_3419)class_3419.field_15247, (float)volume, (float)pitch, (long)seed));
        }
    }
}

