/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.providers;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.base.AxisAndFacingBlock;
import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.configurable.BlockValueFormatter;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.data.ChannelContainer;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.util.ChanneledDataBlockEntity;
import eu.pb4.polyfactory.block.data.util.ChanneledDataCache;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.network.AxisAndFacingNetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.property.ValueModifier;
import eu.pb4.polyfactory.data.CapacityData;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.data.LongData;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.data.ChannelProviderDirectionNode;
import eu.pb4.polyfactory.nodes.data.DataProviderNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalAxisNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class RotationMeterBlock
extends AxisAndFacingNetworkBlock
implements FactoryBlock,
CableConnectable,
DataProvider,
NetworkComponent.Data,
NetworkComponent.Rotational,
class_2343 {
    public RotationMeterBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    protected void updateNetworkAt(class_4538 world, class_2338 pos) {
        NetworkComponent.Rotational.updateRotationalAt(world, pos);
        NetworkComponent.Data.updateDataAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Rotational || block instanceof NetworkComponent.Data;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10085.method_9564();
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalAxisNode(RotationMeterBlock.getAxis(state)));
    }

    @Override
    public Collection<BlockNode> createDataNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new ChannelProviderDirectionNode((class_2350)state.method_11654((class_2769)FACING), this.getChannel(world, pos)));
    }

    protected int getChannel(class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ChannelContainer) {
            ChannelContainer container = (ChannelContainer)class_25862;
            return container.channel();
        }
        return 0;
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    @Override
    public boolean canCableConnect(class_4538 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654((class_2769)FACING) == dir;
    }

    @Override
    @Nullable
    public DataContainer provideData(class_3218 world, class_2338 selfPos, class_2680 selfState, int channel, DataProviderNode node) {
        ChanneledDataCache be;
        class_2586 class_25862 = world.method_8321(selfPos);
        if (class_25862 instanceof ChanneledDataCache && (be = (ChanneledDataCache)class_25862).channel() == channel) {
            return be.getCachedData();
        }
        return null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ChanneledDataBlockEntity(pos, state);
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.CHANNEL, BlockConfig.FACING, FIRST_AXIS_CONFIG);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return this::tick;
    }

    protected abstract <T extends class_2586> void tick(class_1937 var1, class_2338 var2, class_2680 var3, T var4);

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement axle = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
        private final ItemDisplayElement base;

        public Model(class_2680 state) {
            this.base = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.base.setScale((Vector3fc)new Vector3f(2.0f));
            this.updateStatePos(state);
            this.updateAnimation(0.0f, state);
            this.addElement((VirtualElement)this.axle);
            this.addElement((VirtualElement)this.base);
        }

        private void updateAnimation(float speed, class_2680 state) {
            Matrix4f mat = Model.mat();
            mat.identity();
            switch (AxisAndFacingBlock.getAxis(state)) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(speed);
            mat.scale(2.0f, 2.0f, 2.0f);
            this.axle.setTransformation(mat);
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                class_2680 facing = this.blockState();
                this.updateAnimation(this.getRotation(), facing);
                this.axle.startInterpolationIfDirty();
            }
        }

        private void updateStatePos(class_2680 state) {
            Matrix4f mat = Model.mat();
            mat.identity();
            mat.rotate((Boolean)state.method_11654((class_2769)AxisAndFacingBlock.FIRST_AXIS) != false ? 1.5707964f : 0.0f, (Vector3fc)((class_2350)state.method_11654(AxisAndFacingBlock.FACING)).method_23955());
            mat.rotate((Quaternionfc)((class_2350)state.method_11654(AxisAndFacingBlock.FACING)).method_23224());
            mat.scale(2.0f);
            this.base.setTransformation(mat);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
                this.updateAnimation(this.getRotation(), this.blockState());
                this.axle.setInterpolationDuration(0);
                this.axle.tick();
                this.axle.setInterpolationDuration(this.getUpdateRate());
            }
        }
    }

    public static final class Stress
    extends RotationMeterBlock {
        public static final class_2754<Type> TYPE = class_2754.method_11850((String)"type", Type.class);
        public static final BlockConfig<?> TYPE_CONFIG = BlockConfig.of("type", TYPE);

        public Stress(class_4970.class_2251 settings) {
            super(settings);
            this.method_9590((class_2680)this.method_9564().method_11657(TYPE, (Comparable)((Object)Type.LEFT)));
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
            builder.method_11667(new class_2769[]{TYPE});
        }

        @Override
        protected <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
            RotationData rot = RotationUser.getRotation(world, pos);
            DataProvider.sendData((class_4538)world, pos, switch (((Type)((Object)state.method_11654(TYPE))).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> new CapacityData((long)(rot.stressCapacity() - rot.stressUsage()), (long)rot.stressCapacity());
                case 1 -> new LongData((long)rot.stressCapacity());
                case 2 -> new CapacityData((long)rot.stressUsage(), (long)rot.stressCapacity());
            });
        }

        @Override
        public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
            return List.of(BlockConfig.CHANNEL, BlockConfig.FACING, FIRST_AXIS_CONFIG, TYPE_CONFIG);
        }

        public static enum Type implements class_3542
        {
            LEFT,
            CAPACITY,
            USED;


            public String method_15434() {
                return this.name().toLowerCase(Locale.ROOT);
            }
        }
    }

    public static final class Speed
    extends RotationMeterBlock {
        public static final class_2754<ValueModifier> VALUE_MODIFIER = class_2754.method_11849((String)"value_modifier", ValueModifier.class, (Enum[])new ValueModifier[]{ValueModifier.ABSOLUTE, ValueModifier.UNMODIFIED});
        private static final BlockConfig<ValueModifier> VALUE_MODIFIER_CONFIG = BlockConfig.of(VALUE_MODIFIER, BlockValueFormatter.text(ValueModifier::text));

        public Speed(class_4970.class_2251 settings) {
            super(settings);
            this.method_9590((class_2680)this.method_9564().method_11657(VALUE_MODIFIER, (Comparable)((Object)ValueModifier.ABSOLUTE)));
        }

        @Override
        protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
            super.method_9515(builder);
            builder.method_11667(new class_2769[]{VALUE_MODIFIER});
        }

        @Override
        protected <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
            RotationData rot = RotationUser.getRotation(world, pos);
            DataProvider.sendData((class_4538)world, pos, new LongData((long)(rot.speed() / 360.0 * 60.0 * 20.0 * (double)((ValueModifier)((Object)state.method_11654(VALUE_MODIFIER))).apply(rot.isNegative() ? -1.0f : 1.0f))));
        }

        @Override
        public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
            return List.of(BlockConfig.CHANNEL, BlockConfig.FACING, FIRST_AXIS_CONFIG, VALUE_MODIFIER_CONFIG);
        }
    }
}

