/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.data.providers;

import eu.pb4.polyfactory.block.configurable.BlockConfig;
import eu.pb4.polyfactory.block.data.DataProvider;
import eu.pb4.polyfactory.block.data.providers.OrientableCabledDataProviderBlock;
import eu.pb4.polyfactory.block.data.util.ChanneledDataBlockEntity;
import eu.pb4.polyfactory.data.BasicDataType;
import eu.pb4.polyfactory.data.DataContainer;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.util.List;
import java.util.Objects;
import java.util.SequencedSet;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5244;
import net.minecraft.class_9334;

public class TextInputBlock
extends OrientableCabledDataProviderBlock {
    public static final class_2754<BasicDataType> MODE = class_2754.method_11850((String)"mode", BasicDataType.class);

    public TextInputBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657(MODE, (Comparable)((Object)BasicDataType.STRING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{MODE});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!player.method_5715() && this.getFacing(state).method_10153() != hit.method_17780() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof ChanneledDataBlockEntity) {
                ChanneledDataBlockEntity be = (ChanneledDataBlockEntity)class_25862;
                if (be.checkUnlocked(player)) {
                    new Gui(serverPlayer, be);
                }
                return class_1269.field_52422;
            }
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    public List<BlockConfig<?>> getBlockConfiguration(class_3222 player, class_2338 blockPos, class_2350 side, class_2680 state) {
        return List.of(BlockConfig.CHANNEL, this.facingAction, BlockConfig.of("mode", MODE, (basicDataType, world, pos, sidex, statex) -> basicDataType.text()));
    }

    private static class Gui
    extends AnvilInputGui {
        private final ChanneledDataBlockEntity blockEntity;

        public Gui(class_3222 player, ChanneledDataBlockEntity blockEntity) {
            super(player, false);
            this.blockEntity = blockEntity;
            this.setTitle(GuiTextures.TEXT_INPUT.apply(blockEntity.getDisplayName()));
            this.updateDone();
            this.setSlot(2, GuiTextures.BUTTON_CLOSE.get().setName(class_5244.field_24339).setCallback(x -> {
                player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_61058, 0.5f, 1.0f);
                this.close();
            }));
            this.open();
        }

        public void onInput(String input) {
            super.onInput(input);
            this.updateDone();
            if (this.screenHandler != null) {
                this.screenHandler.method_34245(2, class_1799.field_8037);
            }
        }

        private void updateDone() {
            DataContainer data = ((BasicDataType)((Object)this.blockEntity.method_11010().method_11654(MODE))).parse(this.getInput());
            if (data != null) {
                this.setSlot(1, GuiTextures.BUTTON_DONE.get().setName(class_5244.field_24334).setCallback(x -> {
                    this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_61058, 0.5f, 1.0f);
                    DataProvider.sendData((class_4538)this.blockEntity.method_10997(), this.blockEntity.method_11016(), data);
                    this.close();
                }));
            } else {
                this.setSlot(1, (GuiElementBuilderInterface)GuiTextures.BUTTON_DONE_BLOCKED.get().setName((class_2561)class_2561.method_43473().method_10852(class_5244.field_24334).method_27692(class_124.field_1080)));
            }
        }

        public void setDefaultInputValue(String input) {
            super.setDefaultInputValue(input);
            if (this.blockEntity != null) {
                this.updateDone();
            }
            class_1799 itemStack = GuiTextures.EMPTY.getItemStack().method_7972();
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)input));
            itemStack.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
            this.setSlot(0, itemStack, Objects.requireNonNull(this.getSlot(0)).getGuiCallback());
        }

        public void onTick() {
            if (this.blockEntity.method_11015() || this.player.method_73189().method_1025(class_243.method_24953((class_2382)this.blockEntity.method_11016())) > 324.0) {
                this.close();
                return;
            }
            super.onTick();
        }
    }
}

