/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.electric;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.block.base.AxisAndFacingBlock;
import eu.pb4.polyfactory.block.data.CableConnectable;
import eu.pb4.polyfactory.block.electric.ElectricMotorBlockEntity;
import eu.pb4.polyfactory.block.electric.EnergyUser;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.network.AxisAndFacingNetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.electric.EnergyData;
import eu.pb4.polyfactory.nodes.generic.FunctionalAxisNode;
import eu.pb4.polyfactory.nodes.generic.FunctionalDirectionNode;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class ElectricGeneratorBlock
extends AxisAndFacingNetworkBlock
implements FactoryBlock,
CableConnectable,
RotationUser,
EnergyUser {
    public ElectricGeneratorBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    @Override
    protected void updateNetworkAt(class_4538 world, class_2338 pos) {
        NetworkComponent.Rotational.updateRotationalAt(world, pos);
        NetworkComponent.Energy.updateEnergyAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Rotational || block instanceof NetworkComponent.Energy;
    }

    @Override
    public void updateRotationalData(RotationData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        modifier.stress(15.0);
    }

    @Override
    public void updateEnergyData(EnergyData.State modifier, class_2680 state, class_3218 world, class_2338 pos) {
        double speed = RotationUser.getRotation((class_1937)world, pos).speed();
        modifier.provide((long)(speed * 15.0));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10085.method_9564();
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalAxisNode(ElectricGeneratorBlock.getAxis(state)));
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public boolean tickElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return true;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        if (!player.method_5715() && hit.method_17780() != state.method_11654((class_2769)FACING) && player.method_68878() && (class_25862 = world.method_8321(pos)) instanceof ElectricMotorBlockEntity) {
            ElectricMotorBlockEntity be = (ElectricMotorBlockEntity)class_25862;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                be.openGui(serverPlayer);
                return class_1269.field_52422;
            }
        }
        return class_1269.field_5811;
    }

    @Override
    public Collection<BlockNode> createEnergyNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new FunctionalDirectionNode((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Override
    public boolean canCableConnect(class_4538 world, int cableColor, class_2338 pos, class_2680 state, class_2350 dir) {
        return state.method_11654((class_2769)FACING) == dir;
    }

    public static final class Model
    extends RotationAwareModel {
        private final ItemDisplayElement axle = LodItemDisplayElement.createSimple((class_1799)AxleBlock.Model.ITEM_MODEL, (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
        private final ItemDisplayElement base;

        public Model(class_2680 state) {
            this.base = ItemDisplayElementUtil.createSimple((class_1792)state.method_26204().method_8389());
            this.base.setScale((Vector3fc)new Vector3f(2.0f));
            this.updateStatePos(state);
            this.updateAnimation(0.0f, state);
            this.addElement((VirtualElement)this.axle);
            this.addElement((VirtualElement)this.base);
        }

        private void updateAnimation(float speed, class_2680 state) {
            Matrix4f mat = Model.mat();
            switch (AxisAndFacingBlock.getAxis(state)) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(speed);
            mat.scale(2.0f, 2.0f, 2.0f);
            this.axle.setTransformation(mat);
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                class_2680 facing = this.blockState();
                this.updateAnimation(this.getRotation(), facing);
                this.axle.startInterpolationIfDirty();
            }
        }

        private void updateStatePos(class_2680 state) {
            Matrix4f mat = Model.mat();
            mat.rotate((Boolean)state.method_11654((class_2769)AxisAndFacingBlock.FIRST_AXIS) != false ? 1.5707964f : 0.0f, (Vector3fc)((class_2350)state.method_11654(AxisAndFacingBlock.FACING)).method_23955());
            mat.rotate((Quaternionfc)((class_2350)state.method_11654(AxisAndFacingBlock.FACING)).method_23224());
            mat.scale(2.0f);
            this.base.setTransformation(mat);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
                this.updateAnimation(this.getRotation(), this.blockState());
                this.axle.setInterpolationDuration(0);
                this.axle.tick();
                this.axle.setInterpolationDuration(this.getUpdateRate());
            }
        }
    }
}

