/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.BlockHeat;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.block.fluids.MDrainBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlock;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlockEntity;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.drain.DrainRecipe;
import eu.pb4.polyfactory.recipe.input.DrainInput;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.TagLimitedSlot;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.SimpleContainer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class MDrainBlockEntity
extends TallItemMachineBlockEntity
implements FluidInputOutput.ContainerBased {
    public static final int CATALYST_FIRST = 2;
    public static final int OUTPUT_FIRST = 1;
    public static final int INPUT_FIRST = 0;
    public static final long FLUID_CAPACITY = 81000L;
    private static final int[] OUTPUT_SLOTS = new int[]{1};
    private static final int[] INPUT_SLOTS = new int[]{0};
    private final SimpleContainer[] containers = new SimpleContainer[]{new SimpleContainer(0, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1)), new SimpleContainer(1, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1)), new SimpleContainer()};
    protected double process = 0.0;
    protected double speedScale = 0.0;
    @Nullable
    protected class_8786<DrainRecipe> currentRecipe = null;
    private boolean active;
    private MDrainBlock.Model model;
    private boolean inventoryChanged = false;
    private final FluidContainerImpl fluidContainer = new FluidContainerImpl(81000L, this::method_5431);
    private float visualProgress;

    public MDrainBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.MECHANICAL_DRAIN, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        MDrainBlockEntity self = (MDrainBlockEntity)t;
        class_3218 serverWorld = (class_3218)world;
        if (self.model == null) {
            self.model = (MDrainBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            for (int i = 0; i < 2; ++i) {
                self.updatePosition(i);
                self.containers[i].maybeAdd((ElementHolder)self.model);
            }
        }
        self.state = null;
        float temp = BlockHeat.getReceived(world, pos) + self.fluidContainer.fluidTemperature();
        FluidContainerUtil.tick((FluidContainer)self.fluidContainer, (class_3218)world, pos, temp, self::addToOutputOrDrop);
        self.model.setFluid(self.fluidContainer.topFluid(), self.fluidContainer.getFilledPercentage());
        if (self.isInputEmpty()) {
            self.process = 0.0;
            self.visualProgress = 0.0f;
            self.updateInputPosition();
            self.speedScale = 0.0;
            self.active = false;
            self.model.setActive(false);
            self.model.tick();
            return;
        }
        if (self.currentRecipe == null && !self.inventoryChanged) {
            self.process = 0.0;
            self.visualProgress = 0.0f;
            self.updateInputPosition();
            self.speedScale = 0.0;
            self.active = false;
            self.model.setActive(false);
            self.model.tick();
            self.state = INCORRECT_ITEMS_TEXT;
            return;
        }
        class_1799 inputStack = self.method_5438(0);
        DrainInput input = self.asInput();
        if (self.currentRecipe == null || !((DrainRecipe)self.currentRecipe.comp_1933()).method_8115(input, world)) {
            self.process = 0.0;
            self.visualProgress = 0.0f;
            self.updateInputPosition();
            self.speedScale = 0.0;
            self.currentRecipe = serverWorld.method_64577().method_8132(FactoryRecipeTypes.DRAIN, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.active = false;
                self.model.setActive(false);
                self.model.tick();
                self.inventoryChanged = false;
                self.state = INCORRECT_ITEMS_TEXT;
                return;
            }
        }
        self.inventoryChanged = false;
        self.active = true;
        self.model.setActive(true);
        RotationData rot = RotationUser.getRotation(world, pos.method_10084());
        double fullSpeed = rot.speed();
        self.model.rotate((float)fullSpeed);
        self.model.tick();
        if (self.process >= ((DrainRecipe)self.currentRecipe.comp_1933()).time(input)) {
            class_1799 itemOut = ((DrainRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
            class_1799 currentOutput = self.method_5438(1);
            if (currentOutput.method_7960()) {
                self.method_5447(1, itemOut);
            } else if (class_1799.method_31577((class_1799)itemOut, (class_1799)currentOutput) && currentOutput.method_7947() + itemOut.method_7947() < itemOut.method_7914()) {
                currentOutput.method_7933(itemOut.method_7947());
            } else {
                return;
            }
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 16.0);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                class_174.field_44587.method_51350(serverPlayer, self.currentRecipe.comp_1932(), List.of(inputStack.method_7972(), self.catalyst()));
            }
            inputStack.method_7934(((DrainRecipe)self.currentRecipe.comp_1933()).decreasedInputItemAmount(input));
            if (inputStack.method_7960()) {
                self.method_5447(0, class_1799.field_8037);
            }
            for (FluidStack fluidStack : ((DrainRecipe)self.currentRecipe.comp_1933()).fluidInput(input)) {
                self.fluidContainer.extract(fluidStack, false);
            }
            for (FluidStack fluidStack : ((DrainRecipe)self.currentRecipe.comp_1933()).fluidOutput(input)) {
                self.fluidContainer.insert(fluidStack, false);
            }
            world.method_45447(null, pos, (class_3414)((DrainRecipe)self.currentRecipe.comp_1933()).soundEvent().comp_349(), class_3419.field_15245);
            self.process = 0.0;
            self.visualProgress = 0.0f;
            self.updateInputPosition();
            self.method_5431();
        } else {
            double speed;
            double strength = fullSpeed / 50.0 / 20.0;
            self.speedScale = speed = Math.min(Math.abs(strength) * 1.0, 1.0);
            if (speed > 0.0) {
                self.process += speed;
                self.visualProgress = (float)(self.process / ((DrainRecipe)self.currentRecipe.comp_1933()).time(input));
                MDrainBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)self.method_11010());
                class_243 ppos = self.containers[0].getPos();
                Optional fluid = class_156.method_40083(((DrainRecipe)self.currentRecipe.comp_1933()).fluidOutput(input), (class_5819)world.field_9229);
                if (fluid.isPresent() && ppos != null) {
                    ((class_3218)world).method_65096(((FluidStack)fluid.get()).instance().particle(), ppos.field_1352, ppos.field_1351, ppos.field_1350, 0, 0.0, -1.0, 0.0, 0.1);
                }
                self.updateInputPosition();
                return;
            }
            self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
        }
    }

    private DrainInput asInput() {
        return DrainInput.of(this.method_5438(0).method_7972(), this.catalyst(), this.fluidContainer, false);
    }

    private void updateInputPosition() {
        this.updatePosition(0);
        this.containers[0].tick();
    }

    @Override
    protected void updatePosition(int id) {
        SimpleContainer c = this.containers[id];
        if (!c.isContainerEmpty()) {
            Quaternionf rot;
            assert (c.getContainer() != null);
            MovingItem container = c.getContainer();
            class_243 base = class_243.method_24953((class_2382)this.field_11867);
            class_2350 dir = (class_2350)this.method_11010().method_11654(MDrainBlock.INPUT_FACING);
            if (id == 0) {
                base = base.method_1031(0.0, 0.5, 0.0).method_43206(dir, -((double)this.visualProgress - 0.5) * 0.5).method_43206(dir.method_10170(), -0.25);
                rot = class_2350.field_11036.method_23224().rotateY(-dir.method_10170().method_10144() * ((float)Math.PI / 180)).rotateX(2.3561945f);
            } else {
                base = base.method_1031(0.0, 0.45, 0.0).method_43206(dir, -0.3);
                rot = dir.method_10153().method_23224();
            }
            container.setPos(base);
            container.scale(0.75f);
            container.setRotation(rot);
        }
    }

    protected void method_11007(class_11372 view) {
        this.writeInventoryView(view);
        view.method_71463("Progress", this.process);
        this.fluidContainer.writeData(view, "fluid");
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.readInventoryView(view);
        this.process = view.method_71422("Progress", 0.0);
        this.fluidContainer.readData(view, "fluid");
        this.inventoryChanged = true;
        super.method_11014(view);
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.fluidContainer.clear();
            f.extractTo(this.fluidContainer);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.fluidContainer));
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("fluid");
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(MDrainBlock.INPUT_FACING);
        return facing.method_10153() == side || side == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot != 1;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (slot == 2) {
            this.model.setCatalyst(stack);
        }
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 stack = player.method_5998(class_1268.field_5808);
        if ((stack.method_7960() || class_1799.method_31577((class_1799)stack, (class_1799)this.catalyst()) && stack.method_7947() < stack.method_7914()) && hit.method_17780() == class_2350.field_11036 && !this.catalyst().method_7960()) {
            if (stack.method_7960()) {
                player.method_6122(class_1268.field_5808, this.catalyst());
            } else {
                stack.method_7933(1);
            }
            this.setCatalyst(class_1799.field_8037);
            return class_1269.field_52422;
        }
        if (stack.method_31573(FactoryItemTags.DRAIN_CATALYST) && hit.method_17780() == class_2350.field_11036 && this.catalyst().method_7960()) {
            this.setCatalyst(stack.method_46651(1));
            stack.method_57008(1, (class_1309)player);
            return class_1269.field_52422;
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            FluidContainer container = this.getFluidContainer();
            class_1799 copy = stack.method_7972();
            DrainInput input = DrainInput.of(copy, this.catalyst(), container, !(player instanceof FakePlayer));
            Optional optional = serverWorld.method_64577().method_8132(FactoryRecipeTypes.DRAIN, (class_9695)input, world);
            if (optional.isEmpty()) {
                return super.onUse(state, world, pos, player, hit);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_44587.method_51350(serverPlayer, ((class_8786)optional.get()).comp_1932(), List.of(stack.method_7972(), this.catalyst()));
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.DRAIN_USE);
            }
            DrainRecipe recipe = (DrainRecipe)((class_8786)optional.get()).comp_1933();
            class_1799 itemOut = recipe.method_8116(input, (class_7225.class_7874)player.method_56673());
            for (FluidStack<?> fluid : recipe.fluidInput(input)) {
                container.extract(fluid, false);
            }
            player.method_6122(class_1268.field_5808, FactoryUtil.exchangeStack(stack, recipe.decreasedInputItemAmount(input), player, itemOut));
            for (FluidStack<?> fluid : recipe.fluidOutput(input)) {
                container.insert(fluid, false);
            }
            world.method_45447(null, pos, (class_3414)recipe.soundEvent().comp_349(), class_3419.field_15245);
        }
        return class_1269.field_52422;
    }

    private void addToOutputOrDrop(class_1799 stack) {
        FactoryUtil.insertBetween(this, 1, this.method_5439(), stack);
        if (!stack.method_7960()) {
            assert (this.field_11863 != null);
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
        }
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < 1; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getStress() {
        if (this.active) {
            return 1.0;
        }
        return 0.0;
    }

    public void method_5431() {
        super.method_5431();
        this.inventoryChanged = true;
    }

    @Override
    public SimpleContainer[] getContainers() {
        return this.containers;
    }

    @Override
    @Nullable
    public BlockModel getModel() {
        return this.model;
    }

    public FluidContainer getFluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.fluidContainer;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.fluidContainer;
    }

    public class_1799 catalyst() {
        return this.method_5438(2);
    }

    public void setCatalyst(class_1799 catalyst) {
        this.method_5447(2, catalyst);
        if (this.model != null) {
            this.model.setCatalyst(catalyst);
        }
        this.method_5431();
    }

    public int getComparatorOutput(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        if (state.method_11654(MDrainBlock.PART) == TallItemMachineBlock.Part.TOP) {
            return class_1703.method_7618((class_1263)this);
        }
        return (int)(this.fluidContainer.stored() * 15L / this.fluidContainer.capacity());
    }

    private class Gui
    extends SimpleGui {
        private int lastFluidUpdate;
        private int delayTick;

        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.lastFluidUpdate = -1;
            this.delayTick = -1;
            this.updateTitleAndFluid();
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.DRAIN));
            GuiElementInterface fluidSlot = FluidContainerUtil.guiElement(MDrainBlockEntity.this.fluidContainer, true);
            this.setSlot(6, fluidSlot);
            this.setSlot(15, fluidSlot);
            this.setSlot(24, fluidSlot);
            this.setSlotRedirect(2, new class_1735((class_1263)MDrainBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(14, (class_1735)new class_1719((class_1657)player, (class_1263)MDrainBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(20, new TagLimitedSlot(this, MDrainBlockEntity.this, 2, FactoryItemTags.DRAIN_CATALYST){

                public int method_7675() {
                    return 1;
                }

                public int method_7676(class_1799 stack) {
                    return 1;
                }
            });
            this.setSlot(12, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            this.open();
        }

        private void updateTitleAndFluid() {
            class_2561 text = GuiTextures.MECHANICAL_DRAIN.apply((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MECHANICAL_DRAIN_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.MIXER.render(MDrainBlockEntity.this.fluidContainer::provideRender)).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MECHANICAL_DRAIN_FLUID_OFFSET_N)).method_10862(UiResourceCreator.STYLE)).method_10852((class_2561)MDrainBlockEntity.this.method_11010().method_26204().method_9518()));
            if (!text.equals((Object)this.getTitle())) {
                this.setTitle(text);
            }
            this.lastFluidUpdate = MDrainBlockEntity.this.fluidContainer.updateId();
        }

        private float progress() {
            return MDrainBlockEntity.this.visualProgress;
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)MDrainBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            if (MDrainBlockEntity.this.fluidContainer.updateId() != this.lastFluidUpdate && this.delayTick < 0) {
                this.delayTick = 3;
            }
            if (this.delayTick-- == 0) {
                this.updateTitleAndFluid();
            }
            this.setSlot(12, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            super.onTick();
        }
    }
}

