/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.MSpoutBlockEntity;
import eu.pb4.polyfactory.block.fluids.transport.PipeConnectable;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.models.GenericParts;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.pipe.PumpNode;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class MSpoutBlock
extends TallItemMachineBlock
implements NetworkComponent.Pipe,
PipeConnectable {
    public MSpoutBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_1263) {
            class_1263 inventory = (class_1263)class_25862;
            return class_1703.method_7618((class_1263)inventory);
        }
        return 0;
    }

    @Override
    public boolean pushItemTo(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        if (self.getBlockState().method_11654(INPUT_FACING) == pushDirection || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return false;
        }
        MSpoutBlockEntity be = (MSpoutBlockEntity)self.getBlockEntity();
        ContainerHolder container = be.getContainerHolder(0);
        if (container.isContainerEmpty()) {
            container.pushAndAttach(conveyor.pullAndRemove());
        } else {
            class_1799 targetStack = container.getContainer().method_32327();
            class_1799 sourceStack = conveyor.getContainer().method_32327();
            if (class_1799.method_31577((class_1799)container.getContainer().method_32327(), (class_1799)conveyor.getContainer().method_32327())) {
                int count = Math.min(targetStack.method_7947() + sourceStack.method_7947(), container.getMaxStackCount(sourceStack));
                if (count != targetStack.method_7947()) {
                    int dec = count - targetStack.method_7947();
                    targetStack.method_7933(dec);
                    sourceStack.method_7934(dec);
                }
                if (sourceStack.method_7960()) {
                    conveyor.clearContainer();
                }
            }
        }
        return true;
    }

    @Override
    public void getItemFrom(WorldPointer self, class_2350 pushDirection, class_2350 relative, class_2338 conveyorPos, ContainerHolder conveyor) {
        class_2350 inputDir = (class_2350)self.getBlockState().method_11654(INPUT_FACING);
        if (!conveyor.isContainerEmpty() || pushDirection == inputDir || inputDir.method_10153() != relative || self.getBlockState().method_11654(PART) == TallItemMachineBlock.Part.TOP) {
            return;
        }
        MSpoutBlockEntity be = (MSpoutBlockEntity)self.getBlockEntity();
        ContainerHolder out = be.getContainerHolder(1);
        if (out.isContainerEmpty()) {
            return;
        }
        class_1799 stack = out.getContainer().method_32327();
        int amount = Math.min(stack.method_7947(), out.getMaxStackCount(stack));
        if (stack.method_7947() == amount) {
            conveyor.pushAndAttach(out.pullAndRemove());
        } else {
            stack.method_7934(amount);
            conveyor.setMovementPosition(pushDirection == inputDir.method_10153() ? 0.0 : 0.5);
            conveyor.pushNew(stack.method_46651(amount));
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world instanceof class_3218 && type == FactoryBlockEntities.MECHANICAL_SPOUT ? MSpoutBlockEntity::ticker : null;
    }

    @Override
    protected class_2586 createSourceBlockEntity(class_2338 pos, class_2680 state) {
        return new MSpoutBlockEntity(pos, state);
    }

    @Override
    protected ElementHolder createModel(class_3218 serverWorld, class_2338 pos, class_2680 initialBlockState) {
        return new Model(serverWorld, initialBlockState);
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10535.method_9564();
    }

    @Override
    public Collection<BlockNode> createPipeNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return state.method_11654(PART) == TallItemMachineBlock.Part.TOP ? List.of(new PumpNode(class_2350.field_11033, true, 8)) : List.of();
    }

    @Override
    protected void updateNetworkAt(class_4538 world, class_2338 pos) {
        NetworkComponent.Rotational.updateRotationalAt(world, pos);
        NetworkComponent.Pipe.updatePipeAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Rotational || block instanceof NetworkComponent.Pipe;
    }

    @Override
    public boolean canPipeConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return dir == class_2350.field_11036;
    }

    public static final class Model
    extends RotationAwareModel {
        private final class_1799 DEFAULT_MODEL = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/mechanical_spout"));
        private final class_1799 ALT_MODEL = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/mechanical_spout_alt"));
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple((class_1799)this.DEFAULT_MODEL);
        private final ItemDisplayElement gearA;
        private final ItemDisplayElement gearB;
        private final ItemDisplayElement fluid;
        private boolean altModel = false;
        private double progress;
        private FluidInstance<?> castingFluid;
        private boolean isCooling = false;

        private Model(class_3218 world, class_2680 state) {
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.5f, 0.0f));
            this.gearA = LodItemDisplayElement.createSimple((class_1799)GenericParts.SMALL_GEAR, (int)this.getUpdateRate(), (float)0.3f, (float)0.5f);
            this.gearB = LodItemDisplayElement.createSimple((class_1799)GenericParts.SMALL_GEAR, (int)this.getUpdateRate(), (float)0.3f, (float)0.5f);
            this.fluid = LodItemDisplayElement.createSimple();
            this.gearA.setViewRange(0.4f);
            this.gearB.setViewRange(0.4f);
            this.fluid.setViewRange(0.4f);
            this.fluid.setScale((Vector3fc)new Vector3f(0.75f));
            this.fluid.setOffset(new class_243(0.0, 0.4609375, 0.0));
            this.updateStatePos(state);
            class_2350 dir = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.updateAnimation(0.0f, dir.method_10171() == class_2350.class_2352.field_11060 == (dir.method_10166() == class_2350.class_2351.field_11048));
            this.addElement((VirtualElement)this.main);
            this.addElement((VirtualElement)this.fluid);
            this.addElement((VirtualElement)this.gearA);
            this.addElement((VirtualElement)this.gearB);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 direction = (class_2350)state.method_11654(TallItemMachineBlock.INPUT_FACING);
            this.main.setYaw(direction.method_10144());
            this.fluid.setYaw(direction.method_10144());
            this.gearA.setYaw(direction.method_10144());
            this.gearB.setYaw(direction.method_10144());
        }

        private void updateAnimation(float rotation, boolean negative) {
            Matrix4f mat = Model.mat();
            mat.identity();
            mat.translate(0.0f, 0.5f, 0.0f);
            mat.rotateY(negative ? 1.5707964f : -1.5707964f);
            mat.translate(0.0f, 0.5f, 0.4f);
            mat.rotateZ(rotation);
            this.gearA.setTransformation(mat);
            mat.translate(0.0f, 0.0f, -0.8f);
            this.gearB.setTransformation(mat);
        }

        protected void onTick() {
            int tick = this.getTick();
            boolean b = tick % this.getUpdateRate() == 0;
            class_2350 dir = (class_2350)this.blockState().method_11654(TallItemMachineBlock.INPUT_FACING);
            if (b) {
                this.updateAnimation(RotationUser.getRotation((class_1937)this.getAttachment().getWorld(), this.blockPos().method_10084()).rotation(), dir.method_10171() == class_2350.class_2352.field_11060 == (dir.method_10166() == class_2350.class_2351.field_11048));
                this.gearA.startInterpolationIfDirty();
                this.gearB.startInterpolationIfDirty();
            }
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
            }
        }

        public void setActive(boolean b) {
            if (!b) {
                this.setProgress(false, 0.0, null);
            }
        }

        public void altModel(boolean b) {
            if (this.altModel == b) {
                return;
            }
            if (!b) {
                this.setProgress(false, 0.0, null);
            }
            this.altModel = b;
            this.main.setItem(b ? this.ALT_MODEL : this.DEFAULT_MODEL);
            this.main.tick();
        }

        public void setProgress(boolean isCooling, double process, FluidInstance<?> castingFluid) {
            if (!this.altModel) {
                return;
            }
            if (this.progress == process && this.castingFluid == castingFluid && this.isCooling == isCooling) {
                return;
            }
            if (castingFluid == null) {
                this.fluid.setItem(class_1799.field_8037);
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, -0.1f, 0.0f));
            } else {
                boolean isSolid = process > 0.5 && isCooling;
                float value = class_3532.method_15363((float)((float)(isSolid ? (process - 0.5) / 0.5 : 1.0 - process / 0.5)), (float)0.0f, (float)1.0f);
                int color = isCooling ? class_9848.method_61318((float)1.0f, (float)1.0f, (float)(0.6f + value * 0.4f), (float)(0.5f + value * 0.5f)) : 0xFFFFFF;
                this.fluid.setItem(FactoryModels.FLUID_FLAT_14_SPOUT.get(castingFluid, color, isSolid));
                this.fluid.setTranslation((Vector3fc)new Vector3f(0.0f, (float)((isCooling ? 1.0 : class_3532.method_15350((double)process, (double)0.0, (double)1.0)) - 0.5) / 16.2f * 12.0f / 16.0f, 0.0f));
            }
            if (process > this.progress && !isCooling) {
                this.fluid.startInterpolationIfDirty();
            }
            this.fluid.tick();
            this.progress = process;
            this.castingFluid = castingFluid;
            this.isCooling = isCooling;
        }
    }
}

