/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidContainerOwner;
import eu.pb4.polyfactory.block.fluids.MDrainBlock;
import eu.pb4.polyfactory.block.fluids.MSpoutBlock;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlockEntity;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.input.SingleItemWithFluid;
import eu.pb4.polyfactory.recipe.spout.SpoutRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.SimpleContainer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import net.minecraft.class_9695;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class MSpoutBlockEntity
extends TallItemMachineBlockEntity {
    public static final int OUTPUT_FIRST = 1;
    public static final int INPUT_FIRST = 0;
    private static final int[] OUTPUT_SLOTS = new int[]{1};
    private static final int[] INPUT_SLOTS = new int[]{0};
    private final SimpleContainer[] containers = new SimpleContainer[]{new SimpleContainer(0, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1)), new SimpleContainer(1, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1))};
    protected double process = 0.0;
    protected double speedScale = 0.0;
    @Nullable
    protected class_8786<SpoutRecipe> currentRecipe = null;
    private boolean active;
    private MSpoutBlock.Model model;
    private boolean inventoryChanged = false;
    private int containerUpdateId = -1;
    @Nullable
    private FluidContainer fluidContainer;
    private boolean isCooling = false;

    public MSpoutBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.MECHANICAL_SPOUT, pos, state);
    }

    private SingleItemWithFluid asInput() {
        return SingleItemWithFluid.of(this.method_5438(0).method_7972(), this.fluidContainer, (class_3218)this.field_11863);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        double time;
        FluidContainer container;
        MSpoutBlockEntity self = (MSpoutBlockEntity)t;
        if (self.model == null) {
            self.model = (MSpoutBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            for (int i = 0; i < self.containers.length; ++i) {
                self.updatePosition(i);
                self.containers[i].maybeAdd((ElementHolder)self.model);
            }
        }
        boolean alt = !self.containers[0].isContainerEmpty() && self.containers[0].getContainer().method_32327().method_31573(FactoryItemTags.SPOUT_ITEM_HORIZONTAL);
        self.model.altModel(alt);
        self.state = null;
        class_2338 posAbove = pos.method_10084();
        RotationData rot = RotationUser.getRotation(world, posAbove);
        double fullSpeed = rot.speed();
        double strength = fullSpeed / 60.0 / 20.0;
        NetworkComponent.Pipe.forEachLogic((class_3218)world, posAbove, l -> l.setSourceStrength(posAbove, strength));
        class_2586 class_25862 = world.method_8321(pos.method_10086(2));
        if (class_25862 instanceof FluidContainerOwner) {
            FluidContainerOwner owner = (FluidContainerOwner)class_25862;
            v0 = owner.getFluidContainer(class_2350.field_11033);
        } else {
            v0 = container = null;
        }
        if (self.isInputEmpty()) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.active = false;
            self.isCooling = false;
            self.model.setActive(false);
            self.model.tick();
            self.fluidContainer = container;
            return;
        }
        if (container == null || self.currentRecipe == null && !self.inventoryChanged && self.fluidContainer == container && self.containerUpdateId == container.updateId()) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.active = false;
            self.model.setActive(false);
            self.model.tick();
            self.state = INCORRECT_ITEMS_TEXT;
            self.isCooling = false;
            self.fluidContainer = container;
            return;
        }
        self.containerUpdateId = container.updateId();
        self.fluidContainer = container;
        class_1799 inputStack = self.method_5438(0);
        SingleItemWithFluid input = self.asInput();
        if (self.currentRecipe == null || !((SpoutRecipe)self.currentRecipe.comp_1933()).method_8115(input, world)) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.currentRecipe = ((class_3218)world).method_64577().method_8132(FactoryRecipeTypes.SPOUT, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.active = false;
                self.model.setActive(false);
                self.model.tick();
                self.inventoryChanged = false;
                self.isCooling = false;
                self.state = INCORRECT_ITEMS_TEXT;
                return;
            }
        }
        self.inventoryChanged = false;
        self.active = true;
        self.model.setActive(true);
        self.model.tick();
        double coolingTime = ((SpoutRecipe)self.currentRecipe.comp_1933()).coolingTime(input);
        double d = time = self.isCooling ? coolingTime : ((SpoutRecipe)self.currentRecipe.comp_1933()).time(input);
        if (self.process >= time) {
            if (coolingTime > 0.0 && !self.isCooling) {
                self.isCooling = true;
                self.process = 0.0;
                self.method_5431();
                return;
            }
            class_1799 itemOut = ((SpoutRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
            class_1799 currentOutput = self.method_5438(1);
            if (currentOutput.method_7960()) {
                self.method_5447(1, itemOut);
            } else if (class_1799.method_31577((class_1799)itemOut, (class_1799)currentOutput) && currentOutput.method_7947() + itemOut.method_7947() <= itemOut.method_7914()) {
                currentOutput.method_7933(itemOut.method_7947());
            } else {
                return;
            }
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 16.0);
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.SPOUT_CRAFT);
                class_174.field_44587.method_51350(serverPlayer, self.currentRecipe.comp_1932(), List.of(inputStack.method_7972()));
            }
            inputStack.method_7934(((SpoutRecipe)self.currentRecipe.comp_1933()).decreasedInputItemAmount(input));
            int damage = ((SpoutRecipe)self.currentRecipe.comp_1933()).damageInputItemAmount(input);
            if (damage > 0) {
                class_1799 x = inputStack.method_7972();
                inputStack.method_7956(damage, (class_3218)world, null, Consumers.nop());
                if (inputStack.method_7960()) {
                    if (x.method_57826(class_9334.field_56399)) {
                        world.method_45447(null, pos, (class_3414)((class_6880)x.method_58694(class_9334.field_56399)).comp_349(), class_3419.field_15245);
                    }
                    ((class_3218)world).method_65096((class_2394)new class_2392(class_2398.field_11218, x), (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.51, 5, 0.2, 0.0, 0.2, 0.5);
                }
            }
            if (inputStack.method_7960()) {
                self.method_5447(0, class_1799.field_8037);
            }
            for (FluidStack fluidStack : ((SpoutRecipe)self.currentRecipe.comp_1933()).fluidInput(input)) {
                container.extract(fluidStack, false);
            }
            world.method_45447(null, pos, (class_3414)((SpoutRecipe)self.currentRecipe.comp_1933()).soundEvent().comp_349(), class_3419.field_15245);
            self.process = 0.0;
            self.isCooling = false;
            self.model.setProgress(false, 0.0, null);
            self.method_5431();
        } else {
            double speed;
            self.speedScale = speed = Math.min(Math.abs(strength) * 1.0, 1.0);
            if (speed > 0.0 || self.isCooling) {
                self.process = self.process + (self.isCooling ? 1.0 : speed);
                MSpoutBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)self.method_11010());
                Optional fluid = class_156.method_40083(((SpoutRecipe)self.currentRecipe.comp_1933()).fluidInput(input), (class_5819)world.field_9229);
                if (fluid.isPresent()) {
                    double progress = self.process / time;
                    if (!self.isCooling) {
                        ((class_3218)world).method_65096(((FluidStack)fluid.get()).instance().particle(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5 + 1.0 + 0.25, (double)pos.method_10260() + 0.5, 0, 0.0, -1.0, 0.0, 0.1);
                    }
                    self.model.setProgress(self.isCooling, progress, ((FluidStack)fluid.get()).instance());
                }
                return;
            }
            self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
        }
    }

    @Override
    protected void updatePosition(int id) {
        SimpleContainer c = this.containers[id];
        if (!c.isContainerEmpty()) {
            Quaternionf rot;
            assert (c.getContainer() != null);
            MovingItem container = c.getContainer();
            class_243 base = class_243.method_24953((class_2382)this.field_11867);
            float scale = 0.75f;
            class_2350 dir = (class_2350)this.method_11010().method_11654(MDrainBlock.INPUT_FACING);
            if (id == 0) {
                if (container.method_32327().method_31573(FactoryItemTags.SPOUT_ITEM_HORIZONTAL)) {
                    base = base.method_1031(0.0, 0.4609375, 0.0);
                    rot = class_7833.field_40716.rotation(0.0f).mul((Quaternionfc)dir.method_10153().method_23224());
                    scale = 1.5f;
                } else {
                    base = base.method_1031(0.0, 0.625, 0.0);
                    rot = class_2350.field_11036.method_23224().rotateY(dir.method_10144() * ((float)Math.PI / 180));
                }
            } else {
                if (!this.containers[0].isContainerEmpty() && this.containers[0].getContainer().method_32327().method_31573(FactoryItemTags.SPOUT_ITEM_HORIZONTAL)) {
                    base = base.method_1031(0.0, 0.0625, 0.0);
                }
                base = base.method_1031(0.0, 0.46875, 0.0).method_43206(dir, -0.4);
                rot = class_7833.field_40716.rotation((float)Math.PI).mul((Quaternionfc)dir.method_10153().method_23224());
            }
            container.setPos(base);
            container.scale(scale);
            container.setRotation(rot);
        }
    }

    protected void method_11007(class_11372 view) {
        this.writeInventoryView(view);
        view.method_71463("Progress", this.process);
        view.method_71472("is_cooling", this.isCooling);
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.readInventoryView(view);
        this.process = view.method_71422("Progress", 0.0);
        this.isCooling = view.method_71433("is_cooling", false);
        this.inventoryChanged = true;
        super.method_11014(view);
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("fluid");
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(MDrainBlock.INPUT_FACING);
        return facing.method_10153() == side || side == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot != 1;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot == 1;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < 1; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getStress() {
        if (this.active) {
            return 1.0;
        }
        return 0.0;
    }

    public void method_5431() {
        super.method_5431();
        this.inventoryChanged = true;
    }

    @Override
    public SimpleContainer[] getContainers() {
        return this.containers;
    }

    @Override
    @Nullable
    public BlockModel getModel() {
        return this.model;
    }

    private class Gui
    extends SimpleGui {
        private int lastFluidUpdate;
        private int delayTick;
        private FluidContainer lastContainer;

        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.lastFluidUpdate = -1;
            this.delayTick = -1;
            this.updateTitleAndFluid();
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.SPOUT));
            this.setSlotRedirect(12, new class_1735((class_1263)MSpoutBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(15, (class_1735)new class_1719((class_1657)player, (class_1263)MSpoutBlockEntity.this, 1, 1, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            this.open();
        }

        private void updateTitleAndFluid() {
            class_2561 text = MSpoutBlockEntity.this.fluidContainer != null ? GuiTextures.MECHANICAL_SPOUT.apply((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MECHANICAL_SPOUT_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.MIXER.render(MSpoutBlockEntity.this.fluidContainer::provideRender)).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MECHANICAL_SPOUT_FLUID_OFFSET_N)).method_10862(UiResourceCreator.STYLE)).method_10852((class_2561)MSpoutBlockEntity.this.method_11010().method_26204().method_9518())) : GuiTextures.MECHANICAL_SPOUT_NO_CONN.apply((class_2561)MSpoutBlockEntity.this.method_11010().method_26204().method_9518());
            GuiElementInterface fluidSlot = FluidContainerUtil.guiElement(MSpoutBlockEntity.this.fluidContainer, false);
            this.setSlot(2, fluidSlot);
            this.setSlot(11, fluidSlot);
            this.setSlot(20, fluidSlot);
            if (!text.equals((Object)this.getTitle())) {
                this.setTitle(text);
            }
            this.lastFluidUpdate = MSpoutBlockEntity.this.fluidContainer != null ? MSpoutBlockEntity.this.fluidContainer.updateId() : -1;
            this.lastContainer = MSpoutBlockEntity.this.fluidContainer;
        }

        private float progress() {
            if (MSpoutBlockEntity.this.currentRecipe == null) {
                return 0.0f;
            }
            double value = 0.0;
            double coolingTime = ((SpoutRecipe)MSpoutBlockEntity.this.currentRecipe.comp_1933()).coolingTime(MSpoutBlockEntity.this.asInput());
            value = coolingTime > 0.0 && MSpoutBlockEntity.this.isCooling ? MSpoutBlockEntity.this.process / coolingTime * 0.5 + 0.5 : (coolingTime > 0.0 ? MSpoutBlockEntity.this.process / ((SpoutRecipe)MSpoutBlockEntity.this.currentRecipe.comp_1933()).time(MSpoutBlockEntity.this.asInput()) * 0.5 : MSpoutBlockEntity.this.process / ((SpoutRecipe)MSpoutBlockEntity.this.currentRecipe.comp_1933()).time(MSpoutBlockEntity.this.asInput()));
            return (float)class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)MSpoutBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            if (MSpoutBlockEntity.this.fluidContainer != this.lastContainer) {
                this.delayTick = 0;
            } else if (MSpoutBlockEntity.this.fluidContainer != null && MSpoutBlockEntity.this.fluidContainer.updateId() != this.lastFluidUpdate && this.delayTick < 0) {
                this.delayTick = 3;
            }
            if (this.delayTick-- == 0) {
                this.updateTitleAndFluid();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            super.onTick();
        }
    }
}

