/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.BlockHeat;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.block.fluids.PortableFluidTankBlock;
import eu.pb4.polyfactory.block.fluids.smeltery.FaucedBlock;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class PortableFluidTankBlockEntity
extends class_2586
implements FluidInputOutput.ContainerBased,
BlockEntityExtraListener {
    public static final long CAPACITY = 324000L;
    private final FluidContainerImpl container = new FluidContainerImpl(324000L, this::onFluidChanged);
    private float blockTemperature = 0.0f;
    @Nullable
    private PortableFluidTankBlock.Model model;
    private boolean faucedActivate = false;
    private FaucedBlock.FaucedProvider faucedProvider = FaucedBlock.FaucedProvider.EMPTY;
    @Nullable
    private FluidInstance<?> faucedFluid = null;
    private float faucedRate = 0.0f;

    public PortableFluidTankBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.PORTABLE_FLUID_TANK, pos, state);
    }

    public FluidContainer getFluidContainer() {
        return this.container;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        this.container.writeData(view, "fluid");
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.container.readData(view, "fluid");
        if (this.model != null) {
            this.model.setFluid(this.container);
        }
    }

    public void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.container.clear();
            f.extractTo(this.container);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.container));
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("fluid");
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.method_11010().method_11654(PortableFluidTankBlock.FACING) == direction ? this.container : null;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.container;
    }

    private void onFluidChanged() {
        this.method_5431();
        if (this.model != null) {
            this.model.setFluid(this.container);
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        PortableFluidTankBlockEntity self;
        block6: {
            block5: {
                if (!(t instanceof PortableFluidTankBlockEntity)) break block5;
                self = (PortableFluidTankBlockEntity)t;
                if (world instanceof class_3218) break block6;
            }
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (self.faucedProvider != FaucedBlock.FaucedProvider.EMPTY && (!self.faucedProvider.isValid() && self.faucedActivate || self.container.isFull() || self.faucedProvider.getFluidContainerInput().get(self.faucedFluid) == 0L)) {
            self.faucedProvider.setActiveFluid(null);
            self.faucedProvider = FaucedBlock.FaucedProvider.EMPTY;
            self.faucedActivate = false;
        }
        if (self.faucedActivate && self.faucedFluid != null) {
            long maxFlow = self.faucedFluid.getMaxFlow(serverWorld);
            long amount = Math.min(Math.min(Math.min((long)((double)self.faucedRate * 0.05 * (double)maxFlow * self.faucedFluid.getFlowSpeedMultiplier(serverWorld)), maxFlow), self.container.empty()), self.faucedProvider.getFluidContainerInput().get(self.faucedFluid));
            self.faucedProvider.setActiveFluid(self.faucedFluid);
            self.faucedProvider.extract(self.faucedFluid, amount);
            self.container.insert(self.faucedFluid, amount, false);
            ((class_3218)world).method_65096(self.faucedFluid.particle(), (double)pos.method_10263() + 0.5 + (double)((float)self.faucedProvider.direction().method_10148() / 32.0f), (double)((float)(pos.method_10264() + 1) + 0.25f), (double)pos.method_10260() + 0.5 + (double)((float)self.faucedProvider.direction().method_10165() / 32.0f), 0, 0.0, -1.0, 0.0, 0.1);
            return;
        }
        self.blockTemperature = BlockHeat.getReceived(world, pos) + self.container.fluidTemperature();
        FluidContainerUtil.tick((FluidContainer)self.container, (class_3218)world, pos, self.blockTemperature, self::dropItem);
    }

    private void dropItem(class_1799 stack) {
        class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
    }

    public void onListenerUpdate(class_2818 chunk) {
        ElementHolder elementHolder;
        BlockAwareAttachment x = BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867);
        if (x != null && (elementHolder = x.holder()) instanceof PortableFluidTankBlock.Model) {
            PortableFluidTankBlock.Model model;
            this.model = model = (PortableFluidTankBlock.Model)elementHolder;
            this.model.setFluid(this.container);
        }
    }

    public class_1269 activate(FaucedBlock.FaucedProvider provider, float rate) {
        if (!provider.isValid() || this.container.isFull() || provider.getFluidContainerInput().method_59987()) {
            return class_1269.field_5814;
        }
        if (this.faucedActivate && provider == this.faucedProvider) {
            this.faucedActivate = false;
            this.faucedProvider.setActiveFluid(null);
            this.faucedProvider = FaucedBlock.FaucedProvider.EMPTY;
            return class_1269.field_52422;
        }
        this.faucedProvider = provider;
        this.faucedActivate = true;
        this.faucedRate = rate;
        this.faucedFluid = provider.getFluidContainerInput().fluids().getFirst();
        for (FluidInstance<?> fluid : this.container.fluids()) {
            if (provider.getFluidContainerInput().get(fluid) <= 0L) continue;
            this.faucedFluid = fluid;
            break;
        }
        return class_1269.field_52422;
    }
}

