/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.MultiBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.block.fluids.smeltery.FaucedBlock;
import eu.pb4.polyfactory.block.fluids.smeltery.IndustrialSmelteryBlockEntity;
import eu.pb4.polyfactory.block.fluids.transport.PipeBaseBlock;
import eu.pb4.polyfactory.block.fluids.transport.PipeConnectable;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3710;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class IndustrialSmelteryBlock
extends MultiBlock
implements FactoryBlock,
class_2343,
class_3954,
FluidOutput.Getter,
PipeConnectable {
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2746 HAS_PIPE = class_2746.method_11825((String)"has_pipe");
    public static final int STEEL_BLOCKS = 3;
    public static final int DEEPSLATE_BRICK_BLOCKS = 22;

    public IndustrialSmelteryBlock(class_4970.class_2251 settings) {
        super(3, 3, 3, settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)HAS_PIPE, (Comparable)Boolean.valueOf(false)));
    }

    public boolean placeSmeltery(class_3218 world, class_2338 pos) {
        ArrayList<class_2680> list = new ArrayList<class_2680>();
        int steel = 0;
        int deepslate = 0;
        class_2680 controller = null;
        class_2338 start = pos.method_10069(-1, -1, -1);
        class_2338 end = pos.method_10069(1, 1, 1);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)start, (class_2338)end)) {
            class_2680 state = world.method_8320(blockPos);
            list.add(state);
            if (state.method_27852(class_2246.field_28900)) {
                ++deepslate;
                continue;
            }
            if (state.method_27852((class_2248)FactoryBlocks.STEEL_BLOCK)) {
                ++steel;
                continue;
            }
            if (state.method_27852((class_2248)FactoryBlocks.SMELTERY_CORE) && controller == null) {
                controller = state;
                continue;
            }
            if ((!state.method_26215() || blockPos.equals((Object)pos)) && state.method_26215()) continue;
            return false;
        }
        if (steel < 3 || deepslate < 22 || controller == null) {
            return false;
        }
        class_2680 state = (class_2680)FactoryBlocks.SMELTERY.method_9564().method_11657(FACING, (Comparable)((class_2350)controller.method_11654((class_2769)class_3710.field_11104)));
        for (class_2338 blockPos : class_2338.method_10097((class_2338)start, (class_2338)end)) {
            class_2586 class_25862;
            int x = blockPos.method_10263() - start.method_10263();
            int y = blockPos.method_10264() - start.method_10264();
            int z = blockPos.method_10260() - start.method_10260();
            world.method_8501(blockPos, (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)this.partX, (Comparable)Integer.valueOf(x))).method_11657((class_2769)this.partY, (Comparable)Integer.valueOf(y))).method_11657((class_2769)this.partZ, (Comparable)Integer.valueOf(z)));
            if (x != 1 || y != 1 || z != 1 || !((class_25862 = world.method_8321(blockPos)) instanceof IndustrialSmelteryBlockEntity)) continue;
            IndustrialSmelteryBlockEntity be = (IndustrialSmelteryBlockEntity)class_25862;
            be.setPositionedBlocks(list);
        }
        return true;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, LIT, HAS_PIPE});
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862;
        if (!player.method_5715() && (class_25862 = world.method_8321(this.getCenter(state, pos))) instanceof IndustrialSmelteryBlockEntity) {
            IndustrialSmelteryBlockEntity be = (IndustrialSmelteryBlockEntity)class_25862;
            be.openGui((class_3222)player);
            return class_1269.field_52422;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        IndustrialSmelteryBlockEntity be;
        class_2680 x;
        class_2338 center = this.getCenter(state, pos);
        class_2586 class_25862 = world.method_8321(center);
        if (class_25862 instanceof IndustrialSmelteryBlockEntity && (x = (be = (IndustrialSmelteryBlockEntity)class_25862).getPositionedBlock((class_2382)pos.method_10059((class_2382)center))) != null && !x.method_26215()) {
            return x.method_65171(world, pos, false);
        }
        return super.method_9574(world, pos, state, includeData);
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        super.method_66388(state, world, pos, moved);
        if (this.isCenter(state)) {
            return;
        }
        class_2338 center = this.getCenter(state, pos);
        class_2586 class_25862 = world.method_8321(center);
        if (class_25862 instanceof IndustrialSmelteryBlockEntity) {
            IndustrialSmelteryBlockEntity be = (IndustrialSmelteryBlockEntity)class_25862;
            be.breakSmeltery(world, center, pos, false);
        }
    }

    protected boolean canDropStackFrom(class_2680 state) {
        return false;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        boolean hasPipe = false;
        for (class_2350 x : class_2350.values()) {
            PipeBaseBlock block;
            class_2680 tmp = world.method_8320(pos.method_10093(x));
            class_2248 class_22482 = tmp.method_26204();
            hasPipe |= class_22482 instanceof PipeBaseBlock && (block = (PipeBaseBlock)class_22482).checkModelDirection(tmp, x.method_10153()) || tmp.method_27852((class_2248)FactoryBlocks.FAUCED) && tmp.method_11654(FaucedBlock.FACING) == x;
        }
        return (class_2680)state.method_11657((class_2769)HAS_PIPE, (Comparable)Boolean.valueOf(hasPipe));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042().method_10153());
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        class_2758 part;
        class_2758 class_27582 = part = ((class_2350)initialBlockState.method_11654(FACING)).method_10166() == class_2350.class_2351.field_11048 ? this.partZ : this.partX;
        if ((Integer)initialBlockState.method_11654((class_2769)this.partY) == 2 && (Integer)initialBlockState.method_11654((class_2769)part) != 1) {
            return new ModelTopPipe(initialBlockState);
        }
        return this.isCenter(initialBlockState) ? new Model(initialBlockState) : null;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return this.isCenter(state) ? new IndustrialSmelteryBlockEntity(pos, state) : null;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return this.isCenter(state) ? IndustrialSmelteryBlockEntity::tick : null;
    }

    public class_1278 method_17680(class_2680 state, class_1936 world, class_2338 pos) {
        class_1278 inv;
        class_2338 center = this.getCenter(state, pos);
        class_2586 be = world.method_8321(center);
        return be instanceof class_1278 ? (inv = (class_1278)be) : null;
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_28900.method_9564();
    }

    @Override
    public FluidOutput getFluidOutput(class_3218 world, class_2338 pos, class_2350 direction) {
        return (FluidOutput)world.method_8321(this.getCenter(world.method_8320(pos), pos));
    }

    @Override
    public boolean canPipeConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return true;
    }

    public boolean forceLightUpdates(class_2680 blockState) {
        return this.isCenter(blockState);
    }

    public final class ModelTopPipe
    extends BlockModel {
        private static final class_1799 MODEL = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/smeltery_top_pipe"));
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple();

        private ModelTopPipe(class_2680 state) {
            this.main.setDisplaySize(2.0f, 2.0f);
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.main);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654(FACING);
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.main.setItem((Boolean)state.method_11654((class_2769)HAS_PIPE) != false ? MODEL : class_1799.field_8037);
            this.main.setYaw(y - 90.0f);
            this.main.setPitch(p);
            class_2758 part = dir.method_10166() == class_2350.class_2351.field_11048 ? IndustrialSmelteryBlock.this.partZ : IndustrialSmelteryBlock.this.partX;
            Integer val = (Integer)state.method_11654((class_2769)part);
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.25f, (val == 0 == (dir.method_10166() == class_2350.class_2351.field_11048) ? 0.25f : -0.25f) * (float)dir.method_10171().method_10181()));
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.updateStatePos(this.blockState());
                this.tick();
            }
        }
    }

    public static final class Model
    extends BlockModel {
        private static final class_1799 REGULAR = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/smeltery"));
        private static final class_1799 LIT = ItemDisplayElementUtil.getModel((class_2960)ModInit.id("block/smeltery_lit"));
        private final ItemDisplayElement main;

        private Model(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1799)((Boolean)state.method_11654((class_2769)LIT) != false ? LIT : REGULAR));
            this.main.setOffset(new class_243(0.0, -1.0, 0.0));
            this.main.setScale((Vector3fc)new Vector3f(4.0f));
            this.main.setTranslation((Vector3fc)new Vector3f(0.0f, 0.5f, 0.0f));
            this.main.setDisplaySize(5.0f, 5.0f);
            this.updateStatePos(state);
            this.addElement((VirtualElement)this.main);
        }

        private void updateStatePos(class_2680 state) {
            class_2350 dir = (class_2350)state.method_11654(FACING);
            float p = -90.0f;
            float y = 0.0f;
            if (dir.method_10166() != class_2350.class_2351.field_11052) {
                p = 0.0f;
                y = dir.method_10144();
            } else if (dir == class_2350.field_11033) {
                p = 90.0f;
            }
            this.main.setYaw(y);
            this.main.setPitch(p);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.main.setItem((Boolean)this.blockState().method_11654((class_2769)LIT) != false ? LIT : REGULAR);
                this.updateStatePos(this.blockState());
                this.tick();
            }
        }
    }
}

