/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import com.mojang.serialization.Codec;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.block.fluids.smeltery.IndustrialSmelteryBlock;
import eu.pb4.polyfactory.block.mechanical.source.SteamEngineBlock;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.smeltery.SmelteryRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.FuelSlot;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.virtual.inventory.VirtualSlot;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.floats.FloatList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class IndustrialSmelteryBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
FluidOutput.ContainerBased {
    public static final int FLUID_CAPACITY = 1944000;
    private static final Codec<List<class_2680>> BLOCK_STATE_LIST_CODEC = class_2680.field_24734.listOf();
    private static final int[] ALL_SLOTS = IntStream.range(0, 12).toArray();
    private static final int[] INPUT_SLOTS = IntStream.range(0, 9).toArray();
    private static final int[] FUEL_SLOTS = IntStream.range(9, 12).toArray();
    private final class_2371<class_1799> items = class_2371.method_10213((int)12, (Object)class_1799.field_8037);
    private final int[] progress = new int[9];
    private final int[] progressEnd = new int[9];
    private final class_8786<SmelteryRecipe>[] recipes = new class_8786[9];
    private final class_1799[] currentStacks = new class_1799[9];
    private List<class_2680> positionedStates = new ArrayList<class_2680>();
    private final FluidContainerImpl fluidContainer = new FluidContainerImpl(1944000L, this::method_5431);
    public int fuelTicks = 0;
    public int fuelInitial = 1;
    private boolean alreadyBreaking = false;

    public IndustrialSmelteryBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.SMELTERY, pos, state);
        Arrays.fill(this.currentStacks, class_1799.field_8037);
        Arrays.fill(this.progress, -1);
        Arrays.fill(this.progressEnd, 1);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        IndustrialSmelteryBlockEntity self = (IndustrialSmelteryBlockEntity)t;
        FluidContainerUtil.tick((FluidContainer)self.fluidContainer, (class_3218)world, pos, self.fuelTicks > 0 ? 0.85f : 0.0f, self::addToOutputOrDrop);
        boolean dirty = false;
        boolean triesSmelting = false;
        for (int i = 0; i < 9; ++i) {
            int x;
            boolean nullRecipe;
            boolean isDirtyStack;
            class_1799 stack = (class_1799)self.items.get(i);
            if (stack.method_7960()) {
                self.progress[i] = -1;
                self.currentStacks[i] = class_1799.field_8037;
                dirty = true;
                continue;
            }
            boolean bl = isDirtyStack = !class_1799.method_31577((class_1799)self.currentStacks[i], (class_1799)stack);
            if (!isDirtyStack && self.recipes[i] == null) continue;
            class_9696 input = new class_9696(stack);
            boolean bl2 = nullRecipe = self.recipes[i] == null;
            if (self.recipes[i] == null || !((SmelteryRecipe)self.recipes[i].comp_1933()).method_8115((class_9695)input, world)) {
                self.recipes[i] = world.method_8503().method_3772().method_8132(FactoryRecipeTypes.SMELTERY, (class_9695)input, world).orElse(null);
                if (self.recipes[i] == null) {
                    self.progress[i] = -1;
                } else {
                    if (!nullRecipe) {
                        self.progress[i] = 0;
                    }
                    self.progressEnd[i] = ((SmelteryRecipe)self.recipes[i].comp_1933()).time(input, world);
                }
                dirty = true;
                self.currentStacks[i] = stack.method_46651(1);
                continue;
            }
            if (isDirtyStack) {
                self.progress[i] = -1;
                self.currentStacks[i] = stack.method_46651(1);
                dirty = true;
                continue;
            }
            List<FluidStack<?>> result = ((SmelteryRecipe)self.recipes[i].comp_1933()).output(input, world);
            long stored = self.fluidContainer.stored();
            for (FluidStack<?> x2 : result) {
                stored += x2.amount();
            }
            if (stored <= self.fluidContainer.capacity()) {
                triesSmelting = true;
            }
            if (self.fuelTicks > 0) {
                if (self.progress[i] < ((SmelteryRecipe)self.recipes[i].comp_1933()).time(input, world)) {
                    int n = i;
                    self.progress[n] = self.progress[n] + 1;
                    dirty = true;
                    continue;
                }
                if (stored > self.fluidContainer.capacity()) continue;
                dirty = true;
                stack.method_7934(1);
                self.progress[i] = 0;
                for (FluidStack<?> x2 : result) {
                    self.fluidContainer.insert(x2, false);
                }
                class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0);
                if (!(class_16572 instanceof class_3222)) continue;
                class_3222 player = (class_3222)class_16572;
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.SMELTERY_MELTS);
                class_174.field_44587.method_51350(player, self.recipes[i].comp_1932(), List.of());
                continue;
            }
            if (self.field_11863.method_8503().method_3780() % 4 != 0 || (x = Math.max(self.progress[i] - 1, -1)) == self.progress[i]) continue;
            self.progress[i] = x;
            dirty = true;
        }
        if (self.fuelTicks > 0) {
            self.fuelTicks = self.fuelTicks - (triesSmelting ? 3 : 1);
            if (!((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        } else {
            boolean isFueled = false;
            if (triesSmelting) {
                for (int i = 9; i < 12; ++i) {
                    int value;
                    class_1799 stack = self.method_5438(i);
                    if (stack.method_7960() || (value = world.method_61269().method_61755(stack)) <= 0) continue;
                    class_1799 remainder = stack.getRecipeRemainder();
                    stack.method_7934(1);
                    self.fuelInitial = self.fuelTicks = value;
                    isFueled = true;
                    if (stack.method_7960()) {
                        self.method_5447(i, class_1799.field_8037);
                    }
                    if (!remainder.method_7960()) {
                        FactoryUtil.insertBetween(self, 9, 12, remainder);
                        if (!remainder.method_7960()) {
                            class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)(pos.method_10264() + 2), (double)((double)pos.method_10260() + 0.5), (class_1799)remainder);
                        }
                    }
                    dirty = true;
                    break;
                }
            }
            if ((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT) != isFueled) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(isFueled)));
            }
        }
        if (dirty) {
            self.method_5431();
        }
    }

    private void addToOutputOrDrop(class_1799 stack) {
        FactoryUtil.insertBetween(this, 0, 9, stack);
        if (!stack.method_7960()) {
            assert (this.field_11863 != null);
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)(this.field_11867.method_10264() + 2), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
        }
    }

    protected void method_11007(class_11372 view) {
        class_1262.method_5426((class_11372)view, this.items);
        this.fluidContainer.writeData(view, "fluids");
        view.method_71465("fuel_ticks", this.fuelTicks);
        view.method_71465("fuel_initial", this.fuelInitial);
        view.method_71468("positioned_states", BLOCK_STATE_LIST_CODEC, this.positionedStates);
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        class_1262.method_5429((class_11368)view, this.items);
        this.fluidContainer.readData(view, "fluids");
        this.fuelInitial = view.method_71424("fuel_initial", 0);
        this.fuelTicks = view.method_71424("fuel_ticks", 0);
        this.positionedStates = view.method_71426("positioned_states", BLOCK_STATE_LIST_CODEC).orElse(List.of());
        super.method_11014(view);
        Arrays.fill(this.currentStacks, class_1799.field_8037);
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return ALL_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.field_11863 != null && slot >= 9 == this.field_11863.method_61269().method_61752(stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return !this.field_11863.method_61269().method_61752(stack) && slot >= 9;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    @Override
    @Nullable
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.fluidContainer;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.fluidContainer;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 == null) {
            return;
        }
        for (class_2338 pos : class_2338.method_25996((class_2338)this.method_11016(), (int)1, (int)1, (int)1)) {
            if (pos.equals((Object)this.method_11016())) continue;
            this.field_11863.method_8455(pos, this.method_11010().method_26204());
        }
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        this.breakSmeltery((class_3218)this.field_11863, pos, pos, true);
    }

    public void breakSmeltery(class_3218 world, class_2338 pos, class_2338 brokenPos, boolean center) {
        if (this.alreadyBreaking) {
            return;
        }
        this.alreadyBreaking = true;
        int i = 0;
        class_1264.method_5451((class_1937)world, (class_2338)pos.method_10079((class_2350)this.method_11010().method_11654(IndustrialSmelteryBlock.FACING), 2), (class_1263)this);
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            class_2680 state = this.positionedStates.size() > i ? this.positionedStates.get(i) : class_2246.field_10124.method_9564();
            ++i;
            if (brokenPos.equals((Object)blockPos) && !state.method_26215()) {
                class_1264.method_5449((class_1937)world, (double)((double)blockPos.method_10263() + 0.5), (double)((double)blockPos.method_10264() + 0.5), (double)((double)blockPos.method_10260() + 0.5), (class_1799)state.method_26204().method_8389().method_7854());
                continue;
            }
            world.method_8501(blockPos, state);
        }
    }

    public void setPositionedBlocks(List<class_2680> list) {
        this.positionedStates = list;
    }

    @Nullable
    public class_2680 getPositionedBlock(class_2382 subtract) {
        int x = subtract.method_10263() + 1;
        int y = subtract.method_10264() + 1;
        int z = subtract.method_10260() + 1;
        int i = z * 3 * 3 + y * 3 + x;
        if (this.positionedStates.size() < i) {
            return null;
        }
        return this.positionedStates.get(i);
    }

    private class Gui
    extends SimpleGui {
        private boolean active;
        private int lastFluidUpdate;
        private int delayTick;
        private final List<class_1735> inputSlots;
        private final List<class_1735> fuelSlots;

        public Gui(class_3222 player) {
            class_1735 slot;
            super(class_3917.field_18667, player, false);
            this.lastFluidUpdate = -1;
            this.delayTick = -1;
            this.inputSlots = new ArrayList<class_1735>();
            this.fuelSlots = new ArrayList<class_1735>();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    slot = new class_1735((class_1263)IndustrialSmelteryBlockEntity.this, y * 3 + x, x, y);
                    this.inputSlots.add(slot);
                    this.setSlotRedirect(9 * y + 1 + x, slot);
                }
            }
            for (int x = 0; x < 3; ++x) {
                GuiElementInterface fluid = FluidContainerUtil.guiElement(IndustrialSmelteryBlockEntity.this.fluidContainer, false);
                for (int y = 0; y < 5; ++y) {
                    this.setSlot(9 * y + 5 + x, fluid);
                }
                slot = new FuelSlot(IndustrialSmelteryBlockEntity.this, 9 + x, player.method_51469().method_61269());
                this.setSlotRedirect(37 + x, slot);
                this.fuelSlots.add(slot);
            }
            this.setSlot(29, (GuiElementInterface)GuiTextures.FLAME.getCeil(this.fuelProgress()));
            this.setSlot(27, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.SMELTERY));
            this.active = IndustrialSmelteryBlockEntity.this.fuelTicks > 0;
            this.updateTitleAndFluid();
            this.updateSmeltingProgress();
            this.open();
        }

        private void updateTitleAndFluid() {
            class_2561 text = GuiTextures.SMELTERY.apply((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.SMELTERY_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.SMELTERY.render(IndustrialSmelteryBlockEntity.this.fluidContainer::provideRender)).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.SMELTERY_FLUID_OFFSET_N)).method_10862(UiResourceCreator.STYLE)).method_10852((class_2561)IndustrialSmelteryBlockEntity.this.method_11010().method_26204().method_9518()));
            if (!text.equals((Object)this.getTitle())) {
                this.setTitle(text);
            }
            this.lastFluidUpdate = IndustrialSmelteryBlockEntity.this.fluidContainer.updateId();
        }

        private void updateSmeltingProgress() {
            for (int y = 0; y < 3; ++y) {
                float[] progress = new float[4];
                boolean[] enabled = new boolean[4];
                int[] color = new int[4];
                for (int x = 0; x < 3; ++x) {
                    int i = y * 3 + x;
                    progress[x] = (float)IndustrialSmelteryBlockEntity.this.progress[i] / (float)IndustrialSmelteryBlockEntity.this.progressEnd[i];
                    enabled[x] = IndustrialSmelteryBlockEntity.this.progress[i] > -1 && !IndustrialSmelteryBlockEntity.this.method_5438(i).method_7960();
                    color[x] = class_9848.method_61319((float)progress[x], (int)0xFFFFFF, (int)0xFF2200);
                }
                enabled[3] = true;
                this.setSlot(y * 9 + 4, (GuiElementBuilderInterface)new GuiElementBuilder(GuiTextures.LEFT_SHIFTED_3_BARS).hideTooltip().setCustomModelData((List)FloatList.of((float[])progress), (List)BooleanList.of((boolean[])enabled), List.of(), (List)IntList.of((int[])color)));
            }
        }

        private float fuelProgress() {
            return IndustrialSmelteryBlockEntity.this.fuelInitial > 0 ? class_3532.method_15363((float)((float)IndustrialSmelteryBlockEntity.this.fuelTicks / (float)IndustrialSmelteryBlockEntity.this.fuelInitial), (float)0.0f, (float)1.0f) : 0.0f;
        }

        public void onTick() {
            boolean active;
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)IndustrialSmelteryBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            if (IndustrialSmelteryBlockEntity.this.fluidContainer.updateId() != this.lastFluidUpdate && this.delayTick < 0) {
                this.delayTick = 3;
            }
            if (this.delayTick-- == 0) {
                this.updateTitleAndFluid();
            }
            this.updateSmeltingProgress();
            boolean bl = active = IndustrialSmelteryBlockEntity.this.fuelTicks > 0;
            if (!this.active && active) {
                this.active = true;
            }
            this.setSlot(29, (GuiElementInterface)GuiTextures.FLAME.getCeil(this.fuelProgress()));
            super.onTick();
        }

        public class_1799 quickMove(int index) {
            class_1799 itemStack = class_1799.field_8037;
            class_1735 slot = this.getSlotRedirectOrPlayer(index);
            if (slot != null && slot.method_7681() && !(slot instanceof VirtualSlot)) {
                class_1799 itemStack2 = slot.method_7677();
                itemStack = itemStack2.method_7972();
                if (index < this.getVirtualSize() ? !this.insertItem(itemStack2, this.getVirtualSize(), this.getVirtualSize() + 36, true) : (this.player.method_51469().method_61269().method_61752(itemStack2) ? !FactoryUtil.insertItemIntoSlots(itemStack2, this.fuelSlots, false) : !FactoryUtil.insertItemIntoSlots(itemStack2, this.inputSlots, false))) {
                    return class_1799.field_8037;
                }
                if (itemStack2.method_7960()) {
                    slot.method_53512(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
            } else if (slot instanceof VirtualSlot) {
                return slot.method_7677();
            }
            return itemStack;
        }
    }
}

