/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.smeltery;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidOutput;
import eu.pb4.polyfactory.block.mechanical.source.SteamEngineBlock;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.smeltery.SmelteryRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.FuelSlot;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.MinimalSidedInventory;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.virtual.inventory.VirtualSlot;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;

public class PrimitiveSmelteryBlockEntity
extends LockableBlockEntity
implements MinimalSidedInventory,
FluidOutput.ContainerBased {
    public static final int FLUID_CAPACITY = 81000;
    private static final int[] ALL_SLOTS = IntStream.range(0, 1).toArray();
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] FUEL_SLOTS = new int[]{1};
    private final class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private final FluidContainerImpl fluidContainer = new FluidContainerImpl(81000L, this::method_5431);
    public int fuelTicks = 0;
    public int fuelInitial = 1;
    private int progress = -1;
    private int progressEnd = 1;
    private class_8786<SmelteryRecipe> recipes;
    private class_1799 currentStack = class_1799.field_8037;

    public PrimitiveSmelteryBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.PRIMITIVE_SMELTERY, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        PrimitiveSmelteryBlockEntity self = (PrimitiveSmelteryBlockEntity)t;
        FluidContainerUtil.tick((FluidContainer)self.fluidContainer, (class_3218)world, pos, self.fuelTicks > 0 ? 0.85f : 0.0f, self::addToOutputOrDrop);
        boolean dirty = false;
        boolean triesSmelting = false;
        class_1799 stack = self.method_5438(0);
        if (stack.method_7960()) {
            self.progress = -1;
            self.currentStack = class_1799.field_8037;
            dirty = true;
        } else {
            boolean isDirtyStack;
            boolean bl = isDirtyStack = !class_1799.method_31577((class_1799)self.currentStack, (class_1799)stack);
            if (isDirtyStack || self.recipes != null) {
                boolean nullRecipe;
                class_9696 input = new class_9696(stack);
                boolean bl2 = nullRecipe = self.recipes == null;
                if (self.recipes == null || !((SmelteryRecipe)self.recipes.comp_1933()).method_8115((class_9695)input, world)) {
                    self.recipes = world.method_8503().method_3772().method_8132(FactoryRecipeTypes.SMELTERY, (class_9695)input, world).orElse(null);
                    if (self.recipes == null) {
                        self.progress = -1;
                    } else {
                        if (!nullRecipe) {
                            self.progress = 0;
                        }
                        self.progressEnd = ((SmelteryRecipe)self.recipes.comp_1933()).time(input, world) * 5 / 2;
                    }
                    dirty = true;
                    self.currentStack = stack.method_46651(1);
                }
                if (isDirtyStack) {
                    self.progress = -1;
                    self.currentStack = stack.method_46651(1);
                    dirty = true;
                } else {
                    int x;
                    List<FluidStack<?>> result = ((SmelteryRecipe)self.recipes.comp_1933()).output(input, world);
                    long stored = self.fluidContainer.stored();
                    for (FluidStack<?> x2 : result) {
                        stored += x2.amount();
                    }
                    if (stored <= self.fluidContainer.capacity()) {
                        triesSmelting = true;
                    }
                    if (self.fuelTicks > 0) {
                        if (self.progress < ((SmelteryRecipe)self.recipes.comp_1933()).time(input, world) * 5 / 2) {
                            ++self.progress;
                            dirty = true;
                        } else if (stored <= self.fluidContainer.capacity()) {
                            dirty = true;
                            stack.method_7934(1);
                            self.progress = 0;
                            for (FluidStack<?> x2 : result) {
                                self.fluidContainer.insert(x2, false);
                            }
                            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0);
                            if (class_16572 instanceof class_3222) {
                                class_3222 player = (class_3222)class_16572;
                                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.SMELTERY_MELTS);
                                class_174.field_44587.method_51350(player, self.recipes.comp_1932(), List.of());
                            }
                        }
                    } else if (self.field_11863.method_8503().method_3780() % 4 == 0 && (x = Math.max(self.progress - 5, -1)) != self.progress) {
                        self.progress = x;
                        dirty = true;
                    }
                }
            }
        }
        if (self.fuelTicks > 0) {
            self.fuelTicks = self.fuelTicks - (triesSmelting ? 4 : 2);
            if (!((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT)).booleanValue()) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
            }
        } else {
            int value;
            class_1799 stack2;
            boolean isFueled = false;
            if (triesSmelting && !(stack2 = self.method_5438(1)).method_7960() && (value = world.method_61269().method_61755(stack2)) > 0) {
                class_1799 remainder = stack2.getRecipeRemainder();
                stack2.method_7934(1);
                self.fuelInitial = self.fuelTicks = value;
                isFueled = true;
                if (stack2.method_7960()) {
                    self.method_5447(1, class_1799.field_8037);
                }
                if (!remainder.method_7960()) {
                    FactoryUtil.insertBetween(self, 9, 12, remainder);
                    if (!remainder.method_7960()) {
                        class_1264.method_5449((class_1937)world, (double)((double)pos.method_10263() + 0.5), (double)(pos.method_10264() + 2), (double)((double)pos.method_10260() + 0.5), (class_1799)remainder);
                    }
                }
                dirty = true;
            }
            if ((Boolean)state.method_11654((class_2769)SteamEngineBlock.LIT) != isFueled) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(isFueled)));
            }
        }
        if (dirty) {
            self.method_5431();
        }
    }

    private void addToOutputOrDrop(class_1799 stack) {
        FactoryUtil.insertBetween(this, 0, 9, stack);
        if (!stack.method_7960()) {
            assert (this.field_11863 != null);
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)(this.field_11867.method_10264() + 2), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
        }
    }

    protected void method_11007(class_11372 view) {
        class_1262.method_5426((class_11372)view, this.items);
        this.fluidContainer.writeData(view, "fluids");
        view.method_71465("fuel_ticks", this.fuelTicks);
        view.method_71465("fuel_initial", this.fuelInitial);
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        class_1262.method_5429((class_11368)view, this.items);
        this.fluidContainer.readData(view, "fluids");
        this.fuelInitial = view.method_71424("fuel_initial", 0);
        this.fuelTicks = view.method_71424("fuel_ticks", 0);
        super.method_11014(view);
        this.currentStack = class_1799.field_8037;
    }

    @Override
    public class_2371<class_1799> getStacks() {
        return this.items;
    }

    public int[] method_5494(class_2350 side) {
        return ALL_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.field_11863 != null && slot == 1 == this.field_11863.method_61269().method_61752(stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return !this.field_11863.method_61269().method_61752(stack) && slot == 1;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    @Override
    @Nullable
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.fluidContainer;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.fluidContainer;
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.method_11016().method_10084(), this.method_11010().method_26204());
        }
    }

    private class Gui
    extends SimpleGui {
        private final class_1735 inputSlot;
        private final FuelSlot fuelSlot;
        private boolean active;
        private int lastFluidUpdate;
        private int delayTick;

        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.lastFluidUpdate = -1;
            this.delayTick = -1;
            this.inputSlot = new class_1735((class_1263)PrimitiveSmelteryBlockEntity.this, 0, 0, 0);
            this.fuelSlot = new FuelSlot(PrimitiveSmelteryBlockEntity.this, 1, player.method_51469().method_61269());
            this.setSlotRedirect(2, this.inputSlot);
            this.setSlotRedirect(20, this.fuelSlot);
            for (int x = 0; x < 3; ++x) {
                GuiElementInterface fluid = FluidContainerUtil.guiElement(PrimitiveSmelteryBlockEntity.this.fluidContainer, false);
                for (int y = 0; y < 3; ++y) {
                    this.setSlot(9 * y + 5 + x, fluid);
                }
            }
            this.setSlot(11, (GuiElementInterface)GuiTextures.FLAME.getCeil(this.fuelProgress()));
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.SMELTERY));
            this.active = PrimitiveSmelteryBlockEntity.this.fuelTicks > 0;
            this.updateTitleAndFluid();
            this.updateSmeltingProgress();
            this.open();
        }

        private void updateTitleAndFluid() {
            class_2561 text = GuiTextures.PRIMITIVE_SMELTERY.apply((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.SMELTERY_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.PRIMITIVE_SMELTERY.render(PrimitiveSmelteryBlockEntity.this.fluidContainer::provideRender)).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.SMELTERY_FLUID_OFFSET_N)).method_10862(UiResourceCreator.STYLE)).method_10852((class_2561)PrimitiveSmelteryBlockEntity.this.method_11010().method_26204().method_9518()));
            if (!text.equals((Object)this.getTitle())) {
                this.setTitle(text);
            }
            this.lastFluidUpdate = PrimitiveSmelteryBlockEntity.this.fluidContainer.updateId();
        }

        private void updateSmeltingProgress() {
            float progress = class_3532.method_15363((float)((float)PrimitiveSmelteryBlockEntity.this.progress / (float)PrimitiveSmelteryBlockEntity.this.progressEnd), (float)0.0f, (float)1.0f);
            this.setSlot(12, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(progress));
        }

        private float fuelProgress() {
            return PrimitiveSmelteryBlockEntity.this.fuelInitial > 0 ? class_3532.method_15363((float)((float)PrimitiveSmelteryBlockEntity.this.fuelTicks / (float)PrimitiveSmelteryBlockEntity.this.fuelInitial), (float)0.0f, (float)1.0f) : 0.0f;
        }

        public void onTick() {
            boolean active;
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)PrimitiveSmelteryBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            if (PrimitiveSmelteryBlockEntity.this.fluidContainer.updateId() != this.lastFluidUpdate && this.delayTick < 0) {
                this.delayTick = 3;
            }
            if (this.delayTick-- == 0) {
                this.updateTitleAndFluid();
            }
            this.updateSmeltingProgress();
            boolean bl = active = PrimitiveSmelteryBlockEntity.this.fuelTicks > 0;
            if (!this.active && active) {
                this.active = true;
                TriggerCriterion.trigger((class_3222)this.player, (class_2960)FactoryTriggers.FUEL_STEAM_ENGINE);
            }
            this.setSlot(11, (GuiElementInterface)GuiTextures.FLAME.getCeil(this.fuelProgress()));
            super.onTick();
        }

        public class_1799 quickMove(int index) {
            class_1799 itemStack = class_1799.field_8037;
            class_1735 slot = this.getSlotRedirectOrPlayer(index);
            if (slot != null && slot.method_7681() && !(slot instanceof VirtualSlot)) {
                class_1799 itemStack2 = slot.method_7677();
                itemStack = itemStack2.method_7972();
                if (index < this.getVirtualSize() ? !this.insertItem(itemStack2, this.getVirtualSize(), this.getVirtualSize() + 36, true) : (this.player.method_51469().method_61269().method_61752(itemStack2) ? !FactoryUtil.insertItemIntoSlots(itemStack2, List.of(this.fuelSlot), false) : !FactoryUtil.insertItemIntoSlots(itemStack2, List.of(this.inputSlot), false))) {
                    return class_1799.field_8037;
                }
                if (itemStack2.method_7960()) {
                    slot.method_53512(class_1799.field_8037);
                } else {
                    slot.method_7668();
                }
            } else if (slot instanceof VirtualSlot) {
                return slot.method_7677();
            }
            return itemStack;
        }
    }
}

