/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.transport;

import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.transport.FilteredPipeBlock;
import eu.pb4.polyfactory.block.fluids.transport.PipeLikeBlockEntity;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidInstance;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class FilteredPipeBlockEntity
extends PipeLikeBlockEntity
implements BlockEntityExtraListener {
    @Nullable
    private FluidInstance<?> allowedFluid = null;
    @Nullable
    private FilteredPipeBlock.Model model;

    public FilteredPipeBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.FILTERED_PIPE, pos, state);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.setAllowedFluid(view.method_71426("allowed_fluid", FluidInstance.CODEC).orElse(null));
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (this.allowedFluid != null) {
            view.method_71468("allowed_fluid", FluidInstance.CODEC, this.allowedFluid);
        }
    }

    @Override
    protected FluidContainerImpl createContainer() {
        return FluidContainerImpl.filtered(81000L, this::checkFluid, this::markFluidDirty);
    }

    private boolean checkFluid(FluidInstance<?> instance) {
        return this.allowedFluid == null || this.allowedFluid.equals(instance) == ((Boolean)this.method_11010().method_11654((class_2769)FilteredPipeBlock.INVERTED) == false);
    }

    private void markFluidDirty() {
        if (this.allowedFluid == null) {
            this.setAllowedFluid(this.container.topFluid());
        }
        this.method_5431();
    }

    public void setAllowedFluid(@Nullable FluidInstance<?> fluid) {
        if (this.allowedFluid == fluid) {
            return;
        }
        this.allowedFluid = fluid;
        if (this.model != null) {
            this.model.setAllowedFluid(fluid);
        }
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        if (!(t instanceof FilteredPipeBlockEntity)) {
            return;
        }
        FilteredPipeBlockEntity pipe = (FilteredPipeBlockEntity)t;
        pipe.preTick();
        if (pipe.container.isNotEmpty()) {
            NetworkComponent.Pipe.getLogic((class_3218)world, pos).runPushFlows(pos, pipe.container::isNotEmpty, pipe::pushFluid);
        }
        if (pipe.container.isNotFull()) {
            NetworkComponent.Pipe.getLogic((class_3218)world, pos).runPullFlows(pos, pipe.container::isNotFull, pipe::pullFluid);
        }
        pipe.postTick();
    }

    @Override
    protected boolean hasDirection(class_2350 direction) {
        return this.method_11010().method_11654(FilteredPipeBlock.AXIS) == direction.method_10166();
    }

    public void onListenerUpdate(class_2818 chunk) {
        ElementHolder elementHolder;
        BlockAwareAttachment x = BlockAwareAttachment.get((class_2818)chunk, (class_2338)this.field_11867);
        if (x != null && (elementHolder = x.holder()) instanceof FilteredPipeBlock.Model) {
            FilteredPipeBlock.Model model;
            this.model = model = (FilteredPipeBlock.Model)elementHolder;
            this.model.setAllowedFluid(this.allowedFluid);
        }
    }
}

