/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.fluids.transport;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.block.fluids.transport.PipeBlockEntity;
import eu.pb4.polyfactory.block.fluids.transport.PipeConnectable;
import eu.pb4.polyfactory.block.network.NetworkBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polyfactory.block.other.FilledStateProvider;
import eu.pb4.polyfactory.models.FactoryModels;
import eu.pb4.polyfactory.nodes.generic.SelectiveSideNode;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class PipeBaseBlock
extends NetworkBlock
implements FactoryBlock,
PipeConnectable,
BarrierBasedWaterloggable,
class_2343,
NetworkComponent.Pipe {
    public PipeBaseBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof FilledStateProvider) {
            FilledStateProvider be = (FilledStateProvider)class_25862;
            return (int)(be.getFilledAmount() * 15L / be.getFillCapacity());
        }
        return 0;
    }

    @Override
    protected void updateNetworkAt(class_4538 world, class_2338 pos) {
        NetworkComponent.Pipe.updatePipeAt(world, pos);
    }

    @Override
    protected boolean isSameNetworkType(class_2248 block) {
        return block instanceof NetworkComponent.Pipe;
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    public boolean canPipeConnect(class_4538 world, class_2338 pos, class_2680 state, class_2350 dir) {
        return this.checkModelDirection(state, dir);
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new PipeModel(initialBlockState);
    }

    public abstract EnumSet<class_2350> getFlowDirections(class_2680 var1);

    public abstract boolean checkModelDirection(class_2680 var1, class_2350 var2);

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return PipeBlockEntity::tick;
    }

    @Override
    public Collection<BlockNode> createPipeNodes(class_2680 state, class_3218 world, class_2338 pos) {
        return List.of(new SelectiveSideNode(this.getFlowDirections(state)));
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_27119.method_9564();
    }

    public static class PipeModel
    extends BlockModel {
        private final ItemDisplayElement pipe = ItemDisplayElementUtil.createSimple();
        private class_2680 state;

        public PipeModel(class_2680 state) {
            this.pipe.setViewRange(0.5f);
            this.pipe.setYaw(180.0f);
            this.state = state;
            this.updateModel();
            this.addElement((VirtualElement)this.pipe);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        protected void setState(class_2680 blockState) {
            this.state = blockState;
            this.updateModel();
        }

        protected void updateModel() {
            this.pipe.setItem(FactoryModels.PIPE.get(this.state, ((PipeBaseBlock)this.state.method_26204())::checkModelDirection));
            if (this.pipe.getHolder() == this) {
                this.pipe.tick();
            }
        }
    }
}

