/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.kneelawk.graphlib.api.graph.user.BlockNode;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.factorytools.api.virtualentity.LodItemDisplayElement;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.mechanical.AxleBlock;
import eu.pb4.polyfactory.block.mechanical.ChainDriveBlockEntity;
import eu.pb4.polyfactory.entity.ChainLiftEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.models.ChainItemDisplayElement;
import eu.pb4.polyfactory.models.RotationAwareModel;
import eu.pb4.polyfactory.nodes.generic.AxisWithDirectNode;
import eu.pb4.polyfactory.nodes.generic.SimpleAxisNode;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.InteractionElement;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class ChainDriveBlock
extends AxleBlock
implements class_2343 {
    public static final float RADIUS = 0.5625f;
    public static final boolean CLICKABLE_CHAINS = false;

    public ChainDriveBlock(class_4970.class_2251 settings) {
        super(settings);
    }

    public static int getChainCost(class_2338 start, class_2338 end, class_2350.class_2351 startAxis, class_2350.class_2351 endAxis) {
        float dist;
        class_243 pos1 = class_243.method_24953((class_2382)start);
        class_243 pos2 = class_243.method_24953((class_2382)end);
        double squaredDistance = pos1.method_1025(pos2);
        float maxAngle = 0.57595867f;
        boolean isCone = false;
        double axisDist = Math.abs(pos1.method_18043(startAxis) - pos2.method_18043(startAxis));
        double angle = Math.atan2(axisDist, dist = class_3532.method_15355((float)((float)(squaredDistance - axisDist * axisDist))));
        if (Math.abs(angle) > (double)maxAngle) {
            isCone = true;
        }
        if (Math.abs(angle = Math.atan2(axisDist = Math.abs(pos1.method_18043(endAxis) - pos2.method_18043(endAxis)), dist = class_3532.method_15355((float)((float)(squaredDistance - axisDist * axisDist))))) > (double)maxAngle) {
            isCone = true;
        }
        if (isCone) {
            return -1;
        }
        if (squaredDistance > 1024.0) {
            return -2;
        }
        return class_3532.method_15384((double)(Math.sqrt(squaredDistance) * 2.0));
    }

    public static void showPreview(class_3222 player, class_1937 world, class_2338 start, class_2338 target) {
        ChainDriveBlockEntity be2;
        ChainDriveBlockEntity be;
        block9: {
            block8: {
                class_2586 class_25862;
                if (player.field_6012 % 5 == 0 || start.equals((Object)target) || !((class_25862 = world.method_8321(target)) instanceof ChainDriveBlockEntity)) break block8;
                be = (ChainDriveBlockEntity)class_25862;
                class_25862 = world.method_8321(start);
                if (!(class_25862 instanceof ChainDriveBlockEntity)) break block8;
                be2 = (ChainDriveBlockEntity)class_25862;
                if (!be.hasConnection(start) && !be2.hasConnection(target)) break block9;
            }
            return;
        }
        int cost = ChainDriveBlock.getChainCost(start, target, (class_2350.class_2351)be2.method_11010().method_11654(AXIS), (class_2350.class_2351)be.method_11010().method_11654(AXIS));
        class_1799 stack = player.method_6047().method_31574(class_1802.field_23983) ? player.method_6047() : player.method_6079();
        boolean hasEnoughChains = player.method_68878() || stack.method_7947() >= cost;
        class_243 origin = class_243.method_24953((class_2382)start);
        class_243 offset = class_243.method_24953((class_2382)target).method_1020(origin);
        Route entry = Route.create((class_2350.class_2351)be2.method_11010().method_11654(AXIS), offset, (class_2350.class_2351)be.method_11010().method_11654(AXIS));
        int color = cost > 0 ? (hasEnoughChains ? 60928 : 0xFFAA00) : 0xEE0000;
        class_2390 particle = new class_2390(color, 1.0f);
        double delta = 0.5 / entry.distance;
        player.method_7353((class_2561)(switch (cost) {
            case -2 -> class_2561.method_43471((String)"block.polyfactory.chain_drive.invalid_too_far");
            case -1 -> class_2561.method_43471((String)"block.polyfactory.chain_drive.invalid_angle");
            default -> class_2561.method_43469((String)"block.polyfactory.chain_drive.required_chains", (Object[])new Object[]{cost, stack.method_7964()});
        }).method_54663(color), true);
        for (double x = 0.0; x < 1.0; x += delta) {
            class_243 particle1 = origin.method_1019(entry.startPos.method_35590(entry.startOffset, x));
            class_243 particle2 = origin.method_1019(entry.endOffset.method_35590(entry.endPos, x));
            player.field_13987.method_14364((class_2596)new class_2675((class_2394)particle, false, false, particle1.field_1352, particle1.field_1351, particle1.field_1350, 0.0f, 0.0f, 0.0f, 0.0f, 0));
            player.field_13987.method_14364((class_2596)new class_2675((class_2394)particle, false, false, particle2.field_1352, particle2.field_1351, particle2.field_1350, 0.0f, 0.0f, 0.0f, 0.0f, 0));
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
    }

    @Override
    public boolean placesLikeAxle() {
        return false;
    }

    protected boolean method_9616(class_2680 state, class_1750 context) {
        return false;
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return (class_2680)class_2246.field_10499.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)((Boolean)state.method_11654((class_2769)WATERLOGGED)));
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        class_2586 class_25863;
        ChainDriveHandler handler;
        block9: {
            block8: {
                if (stack.method_31574(FactoryItems.CHAIN_LIFT)) {
                    return ChainLiftEntity.attach(stack, state, world, pos, player, hand, hit);
                }
                if (!stack.method_31574(class_1802.field_23983) || !(player instanceof ChainDriveHandler)) break block8;
                handler = (ChainDriveHandler)player;
                class_25863 = world.method_8321(pos);
                if (class_25863 instanceof ChainDriveBlockEntity) break block9;
            }
            return super.method_55765(stack, state, world, pos, player, hand, hit);
        }
        ChainDriveBlockEntity be = (ChainDriveBlockEntity)class_25863;
        class_2338 start = handler.polyfactory$getCurrentChainStart();
        if (start == null || !((class_25862 = world.method_8321(start)) instanceof ChainDriveBlockEntity)) {
            handler.polyfactory$setCurrentChainStart(pos.method_10062());
            return class_1269.field_52422;
        }
        ChainDriveBlockEntity be2 = (ChainDriveBlockEntity)class_25862;
        if (be == be2) {
            return class_1269.field_52422;
        }
        class_2350.class_2351 selfAxis = (class_2350.class_2351)state.method_11654(AXIS);
        class_2350.class_2351 otherAxis = (class_2350.class_2351)be2.method_11010().method_11654(AXIS);
        int cost = ChainDriveBlock.getChainCost(start, pos, otherAxis, selfAxis);
        if (cost <= 0 || stack.method_7947() < cost && !player.method_68878()) {
            return class_1269.field_21466;
        }
        class_1799 result = player.method_68878() ? class_1799.field_8037 : stack.method_7971(cost);
        be.addConnection(start, otherAxis, result);
        be2.addConnection(pos, selfAxis, result.method_7972());
        handler.polyfactory$setCurrentChainStart(null);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.CHAIN_DRIVES_CONNECTED);
        }
        return class_1269.field_52422;
    }

    @Override
    protected void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        super.method_9615(state, world, pos, oldState, notify);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ChainDriveBlockEntity) {
            ChainDriveBlockEntity be = (ChainDriveBlockEntity)class_25862;
            be.method_31664(state);
            be.updateAxis(pos, (class_2350.class_2351)state.method_11654(AXIS));
            for (class_2338 block : be.connections()) {
                class_2586 class_25863 = world.method_8321(block);
                if (!(class_25863 instanceof ChainDriveBlockEntity)) continue;
                ChainDriveBlockEntity be2 = (ChainDriveBlockEntity)class_25863;
                be2.updateAxis(pos, (class_2350.class_2351)state.method_11654(AXIS));
            }
        }
    }

    @Override
    public Collection<BlockNode> createRotationalNodes(class_2680 state, class_3218 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ChainDriveBlockEntity) {
            ChainDriveBlockEntity be = (ChainDriveBlockEntity)class_25862;
            return List.of(new AxisWithDirectNode((class_2350.class_2351)state.method_11654(AXIS), List.copyOf(be.connections())));
        }
        return List.of(new SimpleAxisNode((class_2350.class_2351)state.method_11654(AXIS)));
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return class_259.method_1077();
    }

    @Override
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, initialBlockState, pos);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ChainDriveBlockEntity(pos, state);
    }

    public record Route(Quaternionf rot, Quaternionf rot2, class_243 startPos, class_243 endPos, class_243 startOffset, class_243 endOffset, double doubleDistance, double distance, Quaternionf facingRotFrom, Quaternionf facingRotTo) {
        public static Route create(class_2350.class_2351 selfAxis, class_2338 selfPos, class_2350.class_2351 targetAxis, class_2338 targetPos) {
            return Route.create(selfAxis, class_243.method_24954((class_2382)targetPos.method_10059((class_2382)selfPos)), targetAxis);
        }

        public static Route create(class_2350.class_2351 selfAxis, class_243 selfPos, class_2350.class_2351 targetAxis, class_243 targetPos) {
            return Route.create(selfAxis, targetPos.method_1020(selfPos), targetAxis);
        }

        public static Route create(class_2350.class_2351 selfAxis, class_243 offset, class_2350.class_2351 targetAxis) {
            Quaternionf facingRotTo;
            Quaternionf facingRotFrom;
            Vector3f vec = offset.method_1029().method_46409();
            switch (selfAxis) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_11052: {
                    Quaternionf quaternionf = class_2350.field_11036.method_23224().rotateY((float)Math.atan2(vec.x, vec.z) - 1.5707964f);
                    break;
                }
                case field_11048: {
                    Quaternionf quaternionf = class_2350.field_11034.method_23224().rotateY((float)Math.atan2(vec.y, -vec.z));
                    break;
                }
                case field_11051: {
                    Quaternionf quaternionf = facingRotFrom = class_2350.field_11035.method_23224().rotateY((float)Math.atan2(vec.y, vec.x));
                }
            }
            if (!facingRotFrom.isFinite()) {
                facingRotFrom = new Quaternionf();
            }
            class_243 startPos = new class_243(new Vector3f(0.0f, 0.0f, 0.5625f).rotate((Quaternionfc)facingRotFrom));
            class_243 endPos = new class_243(new Vector3f(0.0f, 0.0f, -0.5625f).rotate((Quaternionfc)facingRotFrom));
            if (selfAxis == targetAxis) {
                v1 = facingRotFrom;
            } else {
                switch (targetAxis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case field_11052: {
                        v1 = class_2350.field_11036.method_23224().rotateY((float)Math.atan2(vec.x, vec.z) - 1.5707964f);
                        break;
                    }
                    case field_11048: {
                        v1 = class_2350.field_11034.method_23224().rotateY((float)Math.atan2(vec.y, -vec.z));
                        break;
                    }
                    case field_11051: {
                        v1 = facingRotTo = class_2350.field_11035.method_23224().rotateY((float)Math.atan2(vec.y, vec.x));
                    }
                }
            }
            if (!facingRotTo.isFinite()) {
                facingRotTo = new Quaternionf();
            }
            Vector3f offsetOuterStart = new Vector3f(0.0f, 0.0f, 0.5625f).rotate((Quaternionfc)facingRotTo);
            Vector3f offsetOuterEnd = new Vector3f(0.0f, 0.0f, -0.5625f).rotate((Quaternionfc)facingRotTo);
            class_243 startOffset = offset.method_1031((double)offsetOuterStart.x, (double)offsetOuterStart.y, (double)offsetOuterStart.z);
            class_243 endOffset = offset.method_1031((double)offsetOuterEnd.x, (double)offsetOuterEnd.y, (double)offsetOuterEnd.z);
            vec.set((Vector3fc)startPos.method_46409());
            Quaternionf rot = new Quaternionf().rotateTo((Vector3fc)class_2350.field_11036.method_23955(), (Vector3fc)startOffset.method_1020(startPos).method_1029().method_46409());
            Quaternionf rot2 = new Quaternionf().rotateTo((Vector3fc)class_2350.field_11036.method_23955(), (Vector3fc)endPos.method_1020(endOffset).method_1029().method_46409());
            double l = offset.method_1033();
            return new Route(rot, rot2, startPos, endPos, startOffset, endOffset, l * 2.0, l, facingRotFrom, facingRotTo);
        }
    }

    public static interface ChainDriveHandler {
        public class_2338 polyfactory$getCurrentChainStart();

        public void polyfactory$setCurrentChainStart(class_2338 var1);
    }

    public static final class Model
    extends RotationAwareModel {
        private static final class_1799 CHAIN = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/chain_drive_chain"));
        private static final class_1799 CHAIN_1 = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/chain_drive_chain_1"));
        private static final class_1799 CHAIN_2 = ItemDisplayElementUtil.getModel((class_2960)FactoryUtil.id("block/chain_drive_chain_2"));
        private final ItemDisplayElement mainElement;
        private final Map<class_2338, Entry> entries = new HashMap<class_2338, Entry>();
        private float lastRotation = 0.0f;

        private Model(class_3218 world, class_2680 state, class_2338 pos) {
            this.mainElement = LodItemDisplayElement.createSimple((class_1799)ItemDisplayElementUtil.getModel((class_1792)state.method_26204().method_8389()), (int)this.getUpdateRate(), (float)0.3f, (float)0.6f);
            this.mainElement.setViewRange(0.7f);
            this.updateAnimation(0.0f, (class_2350.class_2351)state.method_11654(AxleBlock.AXIS), pos);
            this.addElement((VirtualElement)this.mainElement);
        }

        private void updateAnimation(float rotation, class_2350.class_2351 axis, class_2338 pos) {
            Matrix4f mat = Model.mat();
            switch (axis) {
                case field_11048: {
                    mat.rotate((Quaternionfc)class_2350.field_11034.method_23224());
                    break;
                }
                case field_11051: {
                    mat.rotate((Quaternionfc)class_2350.field_11035.method_23224());
                }
            }
            mat.rotateY(rotation);
            mat.scale(2.0f, 2.0f, 2.0f);
            this.mainElement.setTransformation(mat);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                // empty if block
            }
        }

        protected void onTick() {
            long tick = this.getAttachment().getWorld().method_8510();
            if (tick % (long)this.getUpdateRate() == 0L) {
                this.updateAnimation(this.getRotation(), (class_2350.class_2351)this.blockAware().getBlockState().method_11654(AxleBlock.AXIS), this.blockPos());
                this.mainElement.startInterpolationIfDirty();
            }
            if (tick % 4L != 0L) {
                return;
            }
            float dist = this.getRotationData().speedRadians() * 4.0f * 0.5625f;
            float rotMax = 0.6108552f;
            this.lastRotation = Math.abs(dist) > rotMax ? (this.lastRotation += rotMax * Math.signum(dist)) : (this.lastRotation += dist);
            for (Map.Entry<class_2338, Entry> pair : this.entries.entrySet()) {
                this.updateChains(pair.getValue());
            }
        }

        private void updateChains(Entry entry) {
            Route route = entry.route;
            double x = (double)this.lastRotation % route.doubleDistance;
            if (x < 0.0) {
                x += route.doubleDistance;
            }
            for (ChainItemDisplayElement item : entry.displays) {
                item.setTeleportDuration(4);
                if (x < route.distance) {
                    item.setLeftRotation((Quaternionfc)route.rot);
                    item.setOffset(route.startPos.method_35590(route.startOffset, x / route.distance));
                } else {
                    item.setLeftRotation((Quaternionfc)route.rot2);
                    item.setOffset(route.endOffset.method_35590(route.endPos, x / route.distance - 1.0));
                }
                item.forceSync();
                x = (x + 0.5) % route.doubleDistance;
            }
        }

        public void setConnections(Map<class_2338, Route> routes) {
            for (class_2338 class_23382 : List.copyOf(this.entries.keySet())) {
                this.removeConnection(class_23382);
            }
            for (Map.Entry entry : routes.entrySet()) {
                this.addConnection((class_2338)entry.getKey(), (Route)entry.getValue());
            }
        }

        public void addConnection(class_2338 pos, Route route) {
            class_243 otherPos = class_243.method_24953((class_2382)pos);
            if (otherPos.method_1027() > this.getPos().method_1027()) {
                return;
            }
            ArrayList<ChainItemDisplayElement> list = new ArrayList<ChainItemDisplayElement>();
            ArrayList<InteractionElement> interactions = new ArrayList<InteractionElement>();
            class_243 offset = otherPos.method_1020(this.getPos());
            double distance = offset.method_1033();
            double doubleDistance = distance * 2.0;
            class_243 middle = otherPos.method_35590(this.getPos(), 0.5);
            int i = 0;
            for (double x = 0.0; x <= doubleDistance; x += 0.5) {
                ChainItemDisplayElement item = ChainItemDisplayElement.create(i++ % 2 == 0 ? CHAIN_1 : CHAIN_2, 4, this.getPos(), middle, otherPos);
                item.setViewRange(0.65f);
                item.setScale((Vector3fc)new Vector3f(2.0f));
                list.add(item);
            }
            Entry entry = new Entry(list, interactions, route);
            this.updateChains(entry);
            list.forEach(arg_0 -> ((Model)this).addElement(arg_0));
            this.entries.put(pos.method_10062(), entry);
        }

        public void removeConnection(class_2338 pos) {
            Entry old = this.entries.remove(pos);
            if (old != null) {
                old.displays.forEach(arg_0 -> ((Model)this).removeElement(arg_0));
            }
        }

        private record Entry(List<ChainItemDisplayElement> displays, List<InteractionElement> interactions, Route route) {
        }
    }
}

