/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import eu.pb4.factorytools.api.block.BlockEntityExtraListener;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.ChainDriveBlock;
import eu.pb4.polyfactory.block.network.NetworkComponent;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class ChainDriveBlockEntity
extends class_2586
implements BlockEntityExtraListener {
    private final Map<class_2338, Entry> connectedBlockPos = new HashMap<class_2338, Entry>();
    private final Map<class_2338, ChainDriveBlock.Route> routes = new HashMap<class_2338, ChainDriveBlock.Route>();
    @Nullable
    private ChainDriveBlock.Model model;

    public ChainDriveBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CHAIN_DRIVE, pos, state);
    }

    public boolean hasConnection(class_2338 pos) {
        return this.connectedBlockPos.containsKey(pos);
    }

    public ChainDriveBlock.Route getRoute(class_2338 pos) {
        return this.routes.get(pos);
    }

    public Collection<class_2338> connections() {
        return this.connectedBlockPos.keySet();
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            for (Entry connection : List.copyOf(this.connectedBlockPos.values())) {
                class_2586 class_25862 = this.field_11863.method_8321(connection.pos);
                if (!(class_25862 instanceof ChainDriveBlockEntity)) continue;
                ChainDriveBlockEntity be = (ChainDriveBlockEntity)class_25862;
                be.removeConnection(pos);
                class_1264.method_5449((class_1937)this.field_11863, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)connection.stack);
            }
            this.connectedBlockPos.clear();
        }
    }

    public void removeConnection(class_2338 pos) {
        this.connectedBlockPos.remove(pos);
        this.routes.remove(pos);
        NetworkComponent.Rotational.updateRotationalAt((class_4538)this.field_11863, this.method_11016());
        this.method_5431();
        if (this.model != null) {
            this.model.removeConnection(pos);
        }
    }

    public boolean addConnection(class_2338 pos, class_2350.class_2351 axis, class_1799 stack) {
        return this.addConnection(new Entry(pos, axis, stack));
    }

    private boolean addConnection(Entry entry) {
        if (this.connectedBlockPos.containsKey(entry.pos) || entry.pos.equals((Object)this.method_11016())) {
            return false;
        }
        this.connectedBlockPos.put(entry.pos, entry);
        ChainDriveBlock.Route route = this.updateRoute(entry);
        this.connectedBlockPos.put(entry.pos, entry);
        NetworkComponent.Rotational.updateRotationalAt((class_4538)this.field_11863, this.method_11016());
        this.method_5431();
        if (this.model != null) {
            this.model.addConnection(entry.pos, route);
        }
        return true;
    }

    private ChainDriveBlock.Route updateRoute(Entry entry) {
        ChainDriveBlock.Route route = ChainDriveBlock.Route.create((class_2350.class_2351)this.method_11010().method_11654(ChainDriveBlock.AXIS), this.method_11016(), entry.axis, entry.pos);
        this.routes.put(entry.pos, route);
        return route;
    }

    public void updateAxis(class_2338 pos, class_2350.class_2351 axis) {
        if (pos.equals((Object)this.method_11016()) && this.model != null) {
            for (Entry val : List.copyOf(this.connectedBlockPos.values())) {
                if (ChainDriveBlock.getChainCost(pos, val.pos, axis, val.axis) >= 0) continue;
                this.removeConnection(val.pos);
                class_2586 class_25862 = this.field_11863.method_8321(val.pos);
                if (!(class_25862 instanceof ChainDriveBlockEntity)) continue;
                ChainDriveBlockEntity be = (ChainDriveBlockEntity)class_25862;
                be.removeConnection(pos);
                class_1264.method_5449((class_1937)this.field_11863, (double)((double)pos.method_10263() + 0.5), (double)((double)pos.method_10264() + 0.5), (double)((double)pos.method_10260() + 0.5), (class_1799)val.stack);
            }
            this.connectedBlockPos.values().forEach(this::updateRoute);
            this.model.setConnections(this.routes);
            return;
        }
        Entry entry = this.connectedBlockPos.get(pos);
        if (entry == null) {
            return;
        }
        entry = new Entry(pos, axis, entry.stack);
        this.connectedBlockPos.put(pos.method_10062(), entry);
        ChainDriveBlock.Route route = this.updateRoute(entry);
        if (this.model != null) {
            this.model.removeConnection(pos);
            this.model.addConnection(entry.pos, route);
        }
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71468("connection", Entry.COLLECTION_CODEC, this.connectedBlockPos.values());
    }

    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.connectedBlockPos.clear();
        this.routes.clear();
        view.method_71426("connection", Entry.COLLECTION_CODEC).ifPresent(x -> x.forEach(this::addConnection));
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("connection");
    }

    public void onListenerUpdate(class_2818 worldChunk) {
        this.model = (ChainDriveBlock.Model)BlockAwareAttachment.get((class_2818)worldChunk, (class_2338)this.field_11867).holder();
        this.model.setConnections(this.routes);
    }

    public record Entry(class_2338 pos, class_2350.class_2351 axis, class_1799 stack) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Entry::pos), (App)class_2350.class_2351.field_25065.fieldOf("axis").forGetter(Entry::axis), (App)class_1799.field_49266.fieldOf("item").forGetter(Entry::stack)).apply((Applicative)instance, Entry::new));
        public static final Codec<Collection<Entry>> COLLECTION_CODEC = CODEC.listOf().xmap(Function.identity(), List::copyOf);
    }
}

