/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.util.WorldPointer;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.FactoryBlockTags;
import eu.pb4.polyfactory.block.FactoryBlocks;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.conveyor.ConveyorBlock;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.ContainerHolder;
import eu.pb4.polyfactory.util.movingitem.InventoryContainerHolderProvider;
import eu.pb4.polyfactory.util.movingitem.MovingItem;
import eu.pb4.polyfactory.util.movingitem.MovingItemProvider;
import eu.pb4.polyfactory.util.movingitem.RedirectingContainerHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public class ConveyorBlockEntity
extends class_2586
implements InventoryContainerHolderProvider,
class_1278,
RedirectingContainerHolder {
    public double delta;
    @Nullable
    private ConveyorBlock.Model model;
    private MovingItem holdStack = null;

    public ConveyorBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.CONVEYOR, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        ConveyorBlockEntity self = (ConveyorBlockEntity)t;
        ConveyorBlock.DirectionValue vert = (ConveyorBlock.DirectionValue)((Object)state.method_11654(ConveyorBlock.VERTICAL));
        class_2350 dir = (class_2350)state.method_11654(ConveyorBlock.DIRECTION);
        if (self.model == null) {
            self.model = (ConveyorBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.model.updateDelta(-20.0, self.delta);
            self.model.setContainer(self.holdStack);
        }
        double speed = Math.min(RotationUser.getRotation((class_1937)((class_3218)world), pos).speed() * 0.01745329238474369 * 0.7, 128.0);
        boolean itemChanged = self.model.updateSpeed(speed);
        if (self.isContainerEmpty() && speed != 0.0) {
            MovingItemProvider provider;
            WorldPointer pointer;
            class_2248 class_22482;
            if (((Boolean)state.method_11654((class_2769)ConveyorBlock.HAS_OUTPUT_TOP)).booleanValue() && (class_22482 = (pointer = new WorldPointer(world, pos.method_10084())).getBlockState().method_26204()) instanceof MovingItemProvider) {
                provider = (MovingItemProvider)class_22482;
                provider.getItemFrom(pointer, dir, class_2350.field_11033, pos, self);
            }
            if (self.isContainerEmpty() && (class_22482 = (pointer = new WorldPointer(world, pos.method_10093(dir.method_10153()))).getBlockState().method_26204()) instanceof MovingItemProvider) {
                provider = (MovingItemProvider)class_22482;
                provider.getItemFrom(pointer, dir, dir, pos, self);
            }
            if (self.isContainerEmpty()) {
                return;
            }
        }
        if (self.holdStack != null && self.holdStack.method_32327().method_7960()) {
            self.clearContainer();
            return;
        }
        if (vert != ConveyorBlock.DirectionValue.NONE && !vert.stack) {
            speed /= (double)class_3532.field_15724;
        }
        double currentDelta = self.delta;
        if (((Boolean)state.method_11654((class_2769)ConveyorBlock.HAS_OUTPUT_TOP)).booleanValue() && !vert.stack) {
            self.delta += speed;
            if (self.tryInserting(world, pos.method_10093(class_2350.field_11036), class_2350.field_11036, FactoryBlockTags.CONVEYOR_TOP_OUTPUT)) {
                if (self.isContainerEmpty()) {
                    self.setDelta(0.0);
                }
                return;
            }
            self.delta -= speed;
        }
        if (currentDelta + speed >= 1.0) {
            boolean block = false;
            self.delta += speed;
            if (!vert.stack) {
                block = self.tryInserting(world, pos.method_10093(dir), dir, FactoryBlockTags.CONVEYOR_SIDE_OUTPUT);
            }
            if (!block && !(block = self.tryMovingConveyor(world, pos, state, vert, dir))) {
                class_2338 blockerPos = pos.method_10093(dir).method_10084();
                block = world.method_8320(blockerPos).method_26206((class_1922)world, blockerPos, dir.method_10153());
            }
            if (block) {
                self.delta -= speed;
                if (self.isContainerEmpty()) {
                    self.setDelta(0.0);
                }
                return;
            }
            class_1799 stack = self.method_5438(0);
            self.clearContainer();
            class_243 moveVec = class_243.field_1353.method_43206(dir, 0.5).method_1031(0.0, (double)vert.value * 0.6, 0.0);
            class_243 vec = class_243.method_24953((class_2382)pos).method_1019(moveVec).method_1031(0.0, vert == ConveyorBlock.DirectionValue.NONE ? 0.5 : 0.0, 0.0);
            moveVec = moveVec.method_1021(0.5);
            class_1542 itemEntity = new class_1542(world, vec.field_1352, vec.field_1351, vec.field_1350, stack, moveVec.field_1352, moveVec.field_1351, moveVec.field_1350);
            itemEntity.field_6012 = -20;
            world.method_8649((class_1297)itemEntity);
            self.delta -= speed;
        } else {
            self.setDelta(currentDelta + speed);
        }
    }

    private boolean tryMovingConveyor(class_1937 world, class_2338 pos, class_2680 state, ConveyorBlock.DirectionValue vert, class_2350 dir) {
        ConveyorBlockEntity conveyorBlock;
        ConveyorBlockEntity nextConveyor;
        class_2586 possibleNext2;
        class_2338 next;
        if (vert.stack) {
            class_2338 maybeNext;
            class_2680 possibleNext;
            next = pos.method_10086(vert.value);
            if (vert.value == -1 && (possibleNext = world.method_8320(maybeNext = next.method_10093(dir))).method_26164(FactoryBlockTags.CONVEYORS)) {
                next = maybeNext;
            }
        } else if (vert.value == 0 || vert.value == 1) {
            next = pos.method_10093(dir);
            possibleNext = world.method_8320(next);
            if (possibleNext.method_26164(FactoryBlockTags.CONVEYORS) && (possibleNext2 = world.method_8320(maybeNext = next.method_10084())).method_26164(FactoryBlockTags.CONVEYORS) && ((ConveyorBlock.DirectionValue)((Object)possibleNext2.method_11654(ConveyorBlock.VERTICAL))).value == 1) {
                next = maybeNext;
            }
        } else if (vert.value == -1) {
            next = pos.method_10074();
            possibleNext = world.method_8320(next);
            if (possibleNext.method_26164(FactoryBlockTags.CONVEYORS) && (possibleNext2 = world.method_8320(maybeNext = next.method_10093(dir))).method_26164(FactoryBlockTags.CONVEYORS)) {
                next = maybeNext;
            }
        } else {
            return false;
        }
        ConveyorBlockEntity conveyorBlockEntity = nextConveyor = (possibleNext2 = world.method_8321(next)) instanceof ConveyorBlockEntity ? (conveyorBlock = (ConveyorBlockEntity)possibleNext2) : null;
        if (nextConveyor == null) {
            return false;
        }
        if (!nextConveyor.isContainerEmpty()) {
            return true;
        }
        class_2680 nextState = nextConveyor.method_11010();
        ConveyorBlock.DirectionValue nextVert = (ConveyorBlock.DirectionValue)((Object)nextState.method_11654(ConveyorBlock.VERTICAL));
        if (((ConveyorBlock.DirectionValue)((Object)nextState.method_11654(ConveyorBlock.VERTICAL))).stack && !nextState.method_27852((class_2248)FactoryBlocks.STICKY_CONVEYOR)) {
            return nextVert.value == 1;
        }
        class_2350 nextDir = (class_2350)nextState.method_11654(ConveyorBlock.DIRECTION);
        if (nextDir == dir) {
            nextConveyor.setDelta(0.0);
        } else if (nextDir.method_10160().method_10166() == dir.method_10166()) {
            nextConveyor.setDelta(0.5);
        } else if (nextDir.method_10153() == dir) {
            nextConveyor.setDelta(0.8);
        }
        MovingItem x = this.pullAndRemove();
        if (x != null) {
            nextConveyor.pushAndAttach(x);
        }
        return true;
    }

    private boolean tryInserting(class_1937 world, class_2338 pos, class_2350 dir, class_6862<class_2248> requiredTag) {
        FactoryUtil.MovableResult x = FactoryUtil.tryInsertingMovable(this, world, this.method_11016(), pos, dir, (class_2350)this.method_11010().method_11654(ConveyorBlock.DIRECTION), requiredTag);
        if (this.holdStack == null || this.holdStack.method_32327().method_7960()) {
            this.clearContainer();
            this.setDelta(0.0);
        }
        return x != FactoryUtil.MovableResult.FAILURE;
    }

    protected void method_11007(class_11372 view) {
        if (this.holdStack != null && !this.holdStack.method_32327().method_7960()) {
            view.method_71468("HeldStack", class_1799.field_49266, (Object)this.holdStack.method_32327());
        }
        view.method_71463("Delta", this.delta);
    }

    public void method_11014(class_11368 view) {
        Optional stack = view.method_71426("HeldStack", class_1799.field_49266);
        if (stack.isPresent()) {
            if (this.holdStack != null) {
                this.holdStack.method_32332((class_1799)stack.get());
            } else {
                this.setContainer(new MovingItem((class_1799)stack.get()));
            }
        }
        this.delta = view.method_71422("Delta", 0.0);
    }

    public boolean tryAdding(class_1799 stack) {
        if (this.isContainerEmpty()) {
            this.pushNew(stack);
            this.setDelta(0.0);
            return true;
        }
        return false;
    }

    public int method_5444() {
        return 16;
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void setDelta(double delta) {
        if (this.model != null) {
            this.model.updateDelta(this.delta, delta);
        }
        this.delta = delta;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return this.isContainerEmpty();
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        InventoryContainerHolderProvider.super.method_5447(slot, stack);
        this.setDelta(0.5);
    }

    @Override
    public MovingItem getContainer() {
        return this.holdStack;
    }

    @Override
    public double movementDelta() {
        return this.delta;
    }

    @Override
    public void setMovementPosition(double pos) {
        this.setDelta(pos);
    }

    @Override
    public void setContainerLocal(MovingItem container) {
        this.holdStack = container;
        if (this.field_11863 != null) {
            this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
            this.method_5431();
        }
    }

    @Override
    @Nullable
    public ContainerHolder getRedirect() {
        return this.model;
    }

    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.holdStack == null || this.holdStack.method_32327().method_7960() || this.holdStack.method_32327().method_7947() + stack.method_7947() <= this.getMaxStackCount(stack);
    }

    @Override
    public int getMaxStackCount(class_1799 stack) {
        return Math.max(stack.method_7914() / 4, 1);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return true;
    }

    @Override
    public ContainerHolder getContainerHolder(int slot) {
        return this;
    }

    public void method_5448() {
        this.clearContainer();
    }
}

