/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.conveyor;

import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.conveyor.FunnelBlock;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.filter.FilterData;
import eu.pb4.polyfactory.util.inventory.MinimalInventory;
import eu.pb4.polyfactory.util.storage.FilteredRedirectedSlottedStorage;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSets;
import java.util.Arrays;
import java.util.Objects;
import java.util.SequencedSet;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_10712;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5244;
import net.minecraft.class_9334;

public class SlotAwareFunnelBlockEntity
extends LockableBlockEntity {
    public static final int TARGET_SLOT_COUNT = 9;
    final class_2371<FilterData> filter = class_2371.method_10213((int)9, (Object)FilterData.EMPTY_FALSE);
    final int[] slotTargets = new int[9];
    private final class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private final Storage<ItemVariant> storage = new FilteredRedirectedSlottedStorage<ItemVariant>(ItemStorage.SIDED, () -> ((SlotAwareFunnelBlockEntity)this).method_10997(), () -> ((SlotAwareFunnelBlockEntity)this).method_11016(), () -> (class_2350)this.method_11010().method_11654(FunnelBlock.FACING), ItemVariant.blank(), this.slotTargets, (i, res) -> ((FilterData)this.filter.get(i)).test(res.toStack()));

    public SlotAwareFunnelBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.SLOT_AWARE_FUNNEL, pos, state);
        Arrays.fill(this.slotTargets, -1);
    }

    protected void method_11007(class_11372 view) {
        class_1262.method_5426((class_11372)view, this.items);
        view.method_71473("targets", (int[])this.slotTargets.clone());
    }

    public void method_11014(class_11368 view) {
        class_1262.method_5429((class_11368)view, this.items);
        for (int i = 0; i < this.items.size(); ++i) {
            this.filter.set(i, (Object)FilterData.of((class_1799)this.items.get(i), false));
        }
        int[] targets = view.method_71442("targets").orElseGet(() -> new int[this.slotTargets.length]);
        System.arraycopy(targets, 0, this.slotTargets, 0, Math.min(targets.length, this.slotTargets.length));
    }

    private void updateSlot(int i) {
        this.filter.set(i, (Object)FilterData.of((class_1799)this.items.get(i), false));
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity, this);
    }

    public class_1263 asInventory() {
        return MinimalInventory.createMaxOne(this.items, () -> ((SlotAwareFunnelBlockEntity)this).method_5431(), this::updateSlot);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null) {
            class_1264.method_5451((class_1937)this.field_11863, (class_2338)pos, (class_1263)this.asInventory());
        }
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((self, dir) -> self.storage, FactoryBlockEntities.SLOT_AWARE_FUNNEL);
    }

    public static class Gui
    extends SimpleGui {
        private final SlotAwareFunnelBlockEntity be;

        public Gui(final class_3222 player, final SlotAwareFunnelBlockEntity be) {
            super(class_3917.field_18665, player, false);
            this.be = be;
            class_1263 pseudoInv = be.asInventory();
            this.setTitle(GuiTextures.SLOT_AWARE_FUNNEL.apply((class_2561)be.method_11010().method_26204().method_9518()));
            for (int i = 0; i < 9; ++i) {
                this.setSlotRedirect(i, new class_1735(pseudoInv, i, 0, 0));
                final int index = i;
                this.setSlot(9 + i, new GuiElementInterface(){

                    public class_1799 getItemStack() {
                        return (be.slotTargets[index] < 0 ? GuiTextures.NUMBERED_BUTTONS_DISABLED : GuiTextures.NUMBERED_BUTTONS[Math.min(be.slotTargets[index], 99)]).get().hideTooltip().asStack();
                    }

                    public GuiElementInterface.ClickCallback getGuiCallback() {
                        return (i1, clickType, slotActionType, slotGuiInterface) -> {
                            new SetSlotGui(player, this, index);
                            player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_61058, 0.5f, 1.0f);
                        };
                    }
                });
            }
            this.open();
        }

        public void onTick() {
            if (this.be.method_11015() || this.player.method_73189().method_1025(class_243.method_24953((class_2382)this.be.field_11867)) > 324.0) {
                this.close();
            }
            super.onTick();
        }
    }

    private static class SetSlotGui
    extends AnvilInputGui {
        private final Gui gui;
        private final int slot;

        public SetSlotGui(class_3222 player, Gui gui, int slot) {
            super(player, false);
            this.gui = gui;
            this.slot = slot;
            this.setTitle(GuiTextures.INPUT.apply((class_2561)class_2561.method_43469((String)"block.polyfactory.slot_aware_funnel.set_slot_title", (Object[])new Object[]{slot})));
            this.setDefaultInputValue(gui.be.slotTargets[slot] == -1 ? "" : String.valueOf(gui.be.slotTargets[slot]));
            this.updateDone();
            this.setSlot(2, GuiTextures.BUTTON_CLOSE.get().setName(class_5244.field_24339).setCallback(x -> {
                player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_61058, 0.5f, 1.0f);
                this.close(true);
                this.gui.open();
            }));
            this.open();
        }

        public void onInput(String input) {
            super.onInput(input);
            this.updateDone();
            if (this.screenHandler != null) {
                this.screenHandler.method_34245(2, class_1799.field_8037);
            }
        }

        private void updateDone() {
            int targetSlot = -2;
            if (this.getInput().isEmpty()) {
                targetSlot = -1;
            }
            try {
                targetSlot = Integer.parseInt(this.getInput());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (targetSlot > -2 && targetSlot < 100) {
                int finalTargetSlot = targetSlot;
                this.setSlot(1, GuiTextures.BUTTON_DONE.get().setName(class_5244.field_24334).setCallback(x -> {
                    this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_61058, 0.5f, 1.0f);
                    this.gui.be.slotTargets[this.slot] = finalTargetSlot;
                    this.close(true);
                    this.gui.open();
                }));
            } else {
                this.setSlot(1, (GuiElementBuilderInterface)GuiTextures.BUTTON_DONE_BLOCKED.get().setName((class_2561)class_2561.method_43473().method_10852(class_5244.field_24334).method_27692(class_124.field_1080)));
            }
        }

        public void setDefaultInputValue(String input) {
            super.setDefaultInputValue(input);
            if (this.gui != null) {
                this.updateDone();
            }
            class_1799 itemStack = GuiTextures.EMPTY.getItemStack().method_7972();
            itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)input));
            itemStack.method_57379(class_9334.field_56400, (Object)new class_10712(true, (SequencedSet)ReferenceSortedSets.emptySet()));
            this.setSlot(0, itemStack, Objects.requireNonNull(this.getSlot(0)).getGuiCallback());
        }

        public void onTick() {
            if (this.gui.be.method_11015() || this.player.method_73189().method_1025(class_243.method_24953((class_2382)this.gui.be.method_11016())) > 324.0) {
                this.close();
                return;
            }
            super.onTick();
        }
    }
}

