/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.block.OwnedBlockEntity;
import eu.pb4.factorytools.api.block.entity.LockableBlockEntity;
import eu.pb4.factorytools.api.util.FactoryPlayer;
import eu.pb4.factorytools.api.util.LegacyNbtHelper;
import eu.pb4.factorytools.api.util.VirtualDestroyStage;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.MinerBlock;
import eu.pb4.polyfactory.item.FactoryItemTags;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.TagLimitedSlot;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.SingleStackInventory;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.gui.SimpleGui;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5552;
import net.minecraft.class_5630;
import net.minecraft.class_5699;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class MinerBlockEntity
extends LockableBlockEntity
implements SingleStackInventory,
class_1278,
OwnedBlockEntity {
    private class_1799 currentTool = class_1799.field_8037;
    private class_2680 targetState = class_2246.field_10124.method_9564();
    protected GameProfile owner = null;
    protected MinerPlayer player = null;
    protected double process = 0.0;
    private float stress = 0.0f;
    private float lastAttackedTicks = 0.0f;
    private MinerBlock.Model model;
    private float attackCooldownPerTick = 1.0f;
    private int reach = 2;

    public MinerBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.MINER, pos, state);
    }

    protected void method_11007(class_11372 view) {
        if (!this.currentTool.method_7960()) {
            view.method_71468("tool", class_1799.field_49266, (Object)this.currentTool);
        }
        view.method_71463("progress", this.process);
        view.method_71468("block_state", class_5699.field_60980, (Object)class_2512.method_10686((class_2680)this.targetState));
        if (this.owner != null) {
            view.method_71468("owner", class_5699.field_60980, (Object)LegacyNbtHelper.writeGameProfile((class_2487)new class_2487(), (GameProfile)this.owner));
        }
        view.method_71464("last_attacked_ticks", this.lastAttackedTicks);
        view.method_71465("reach", this.reach);
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.currentTool = view.method_71426("tool", class_1799.field_49266).orElse(class_1799.field_8037);
        this.process = view.method_71422("progress", 0.0);
        view.method_71426("owner", class_2487.field_25128).ifPresent(x -> {
            this.owner = LegacyNbtHelper.toGameProfile((class_2487)x);
        });
        this.targetState = class_2512.method_10681((class_7871)class_7923.field_41175, (class_2487)view.method_71426("block_state", class_2487.field_25128).orElse(new class_2487()));
        this.lastAttackedTicks = view.method_71423("last_attacked_ticks", -1.0f);
        this.reach = view.method_71424("reach", 1);
        super.method_11014(view);
        this.updateAttackCooldownPerTick();
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile profile) {
        this.owner = profile;
        this.method_5431();
    }

    @Override
    public class_1799 getStack() {
        return this.currentTool;
    }

    @Override
    public void setStack(class_1799 stack) {
        this.currentTool = stack;
        this.lastAttackedTicks = 0.0f;
        this.updateAttackCooldownPerTick();
        if (this.model != null) {
            this.model.setItem(stack);
        }
        this.method_5431();
    }

    private void updateAttackCooldownPerTick() {
        Double baseSpeed;
        AtomicReference<Double> attackSpeed = new AtomicReference<Double>(4.0);
        DoubleArrayList multiplier = new DoubleArrayList();
        DoubleArrayList multiplier2 = new DoubleArrayList();
        this.getStack().method_57354(class_1304.field_6173, (entityAttributeRegistryEntry, value) -> {
            if (entityAttributeRegistryEntry == class_5134.field_23723) {
                switch (value.comp_2450()) {
                    case field_6328: {
                        attackSpeed.updateAndGet(v -> v + value.comp_2449());
                        break;
                    }
                    case field_6330: {
                        multiplier.add(value.comp_2449());
                        break;
                    }
                    case field_6331: {
                        multiplier2.add(value.comp_2449());
                    }
                }
            }
        });
        Double out = baseSpeed = attackSpeed.get();
        for (Double val : multiplier) {
            out = out + baseSpeed * val;
        }
        for (Double val : multiplier2) {
            out = out * (1.0 + val);
        }
        this.attackCooldownPerTick = (float)(1.0 / out * 20.0);
    }

    public float getAttackCooldownProgress() {
        return class_3532.method_15363((float)((this.lastAttackedTicks + 0.5f) / this.attackCooldownPerTick), (float)0.0f, (float)1.0f);
    }

    public MinerPlayer getFakePlayer() {
        if (this.player == null) {
            GameProfile profile = this.owner == null ? FactoryUtil.GENERIC_PROFILE : this.owner;
            this.player = new MinerPlayer(class_5630.method_32328((class_1263)this, (int)0), (class_3218)this.field_11863, this.field_11867, new GameProfile(profile.id(), "Miner (" + profile.name() + ")"));
            this.player.method_23327((double)this.field_11867.method_10263() + 0.5, (float)this.field_11867.method_10264() + 0.5f, (float)this.field_11867.method_10260() + 0.5f);
        }
        return this.player;
    }

    public int method_5444() {
        return 1;
    }

    public int reach() {
        return this.reach;
    }

    public void setReach(int reach) {
        this.reach = reach;
        this.method_5431();
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.currentTool.method_7960() && stack.method_31573(FactoryItemTags.ALLOWED_IN_MINER);
    }

    protected void createGui(class_3222 playerEntity) {
        new Gui(playerEntity);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        MinerBlockEntity self = (MinerBlockEntity)t;
        if (self.model == null) {
            self.model = (MinerBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.model.setItem(self.currentTool);
        }
        class_2338 blockPos = pos;
        class_2680 stateFront = class_2246.field_10124.method_9564();
        int reach = self.reach;
        while (stateFront.method_26215() && reach-- > 0) {
            blockPos = blockPos.method_10093((class_2350)state.method_11654(MinerBlock.FACING));
            stateFront = world.method_8320(blockPos);
        }
        class_243 centered = pos.method_46558();
        List entities = world.method_8390(class_1297.class, class_238.method_54784((class_2338)pos, (class_2338)blockPos), class_1297::method_5863);
        entities.sort(Comparator.comparingDouble(x -> x.method_73189().method_1025(centered)));
        if (!entities.isEmpty()) {
            double speed = Math.abs(RotationUser.getRotation(world, pos).speed()) * 0.01745329238474369 * 3.0;
            self.process = 0.0;
            world.method_8517(self.getFakePlayer().method_5628(), blockPos, -1);
            VirtualDestroyStage.updateState((class_3222)self.getFakePlayer(), (class_2338)blockPos, (class_2680)stateFront, (int)-1);
            if (self.getAttackCooldownProgress() != 1.0f) {
                self.lastAttackedTicks = (float)((double)self.lastAttackedTicks + speed);
                self.stress = 15.0f;
                self.model.rotate((float)speed / 3.0f);
                return;
            }
            MinerPlayer player = self.getFakePlayer();
            player.setLastAttackedTicks(9999999);
            class_5131 attr = player.method_6127();
            class_1324 dmg = player.method_6127().method_45329(class_5134.field_23721);
            if (dmg != null) {
                dmg.method_6192(0.0);
                dmg.method_6203();
                self.getStack().method_57354(class_1304.field_6173, (type, value) -> {
                    if (type == class_5134.field_23721) {
                        dmg.method_26835(value);
                    }
                });
            }
            player.method_7324((class_1297)entities.getFirst());
            self.lastAttackedTicks = 0.0f;
            return;
        }
        if (stateFront != self.targetState) {
            self.process = 0.0;
            self.targetState = stateFront;
            world.method_8517(self.getFakePlayer().method_5628(), blockPos, -1);
            VirtualDestroyStage.updateState((class_3222)self.getFakePlayer(), (class_2338)blockPos, (class_2680)stateFront, (int)-1);
            return;
        }
        MinerPlayer player = self.getFakePlayer();
        if (self.currentTool.method_7960() || !self.currentTool.method_7909().method_7885(self.currentTool, stateFront, world, blockPos, (class_1309)player)) {
            self.stress = 0.0f;
            return;
        }
        if (!CommonProtection.canBreakBlock((class_1937)world, (class_2338)blockPos, (GameProfile)(self.owner == null ? FactoryUtil.GENERIC_PROFILE : self.owner), null)) {
            self.stress = 0.0f;
            return;
        }
        float delta = stateFront.method_26165((class_1657)player, (class_1922)self.field_11863, blockPos);
        if (delta < 0.0f) {
            delta = 0.0f;
        }
        double speed = Math.abs(RotationUser.getRotation((class_1937)((class_3218)world), pos).speed()) * 0.01745329238474369 * 2.5;
        if (stateFront.method_26215() || stateFront.method_26218((class_1922)world, blockPos).method_1110()) {
            self.stress = 0.0f;
            self.model.rotate((float)speed);
            return;
        }
        self.stress = Math.min(0.2f / delta, player.method_7305(stateFront) ? 20.0f : 99999.0f);
        if (speed == 0.0) {
            return;
        }
        self.process += (double)delta * speed;
        self.model.rotate((float)speed);
        int value2 = (int)(self.process * 10.0);
        world.method_8517(player.method_5628(), blockPos, value2);
        VirtualDestroyStage.updateState((class_3222)player, (class_2338)blockPos, (class_2680)stateFront, (int)value2);
        if (self.process >= 1.0) {
            self.process = 0.0;
            self.stress = 0.0f;
            class_2586 blockEntity = world.method_8321(blockPos);
            if (!(stateFront.method_26204() instanceof class_5552) && !player.method_21701(world, blockPos, class_1934.field_9215)) {
                stateFront.method_26204().method_9576(world, blockPos, stateFront, (class_1657)player);
                boolean bl = world.method_8650(blockPos, false);
                if (bl) {
                    stateFront.method_26204().method_9585((class_1936)world, blockPos, stateFront);
                }
                class_1799 itemStack2 = self.currentTool.method_7972();
                boolean bl2 = player.method_7305(stateFront);
                self.currentTool.method_7952(world, stateFront, blockPos, (class_1657)player);
                if (bl && bl2) {
                    class_1657 class_16572;
                    stateFront.method_26204().method_9556(world, (class_1657)player, blockPos, stateFront, blockEntity, itemStack2);
                    if (self.owner != null && (class_16572 = world.method_18470(self.owner.id())) instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)class_16572;
                        TriggerCriterion.trigger((class_3222)serverPlayer, (class_2960)FactoryTriggers.MINER_MINES);
                    }
                }
            }
            self.method_5431();
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.player != null) {
            VirtualDestroyStage.destroy((class_3222)this.player);
        }
    }

    public float getStress() {
        return this.stress;
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
    }

    public static class MinerPlayer
    extends FactoryPlayer {
        public MinerPlayer(class_5630 toolReference, class_3218 world, class_2338 pos, GameProfile gameProfile) {
            super(toolReference, world, pos, gameProfile);
        }

        public void setLastAttackedTicks(int tick) {
            this.field_6273 = tick;
        }
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17337, player, false);
            this.setTitle(GuiTextures.CENTER_SLOT_GENERIC.apply((class_2561)MinerBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlotRedirect(2, new TagLimitedSlot((class_1263)MinerBlockEntity.this, 0, FactoryItemTags.ALLOWED_IN_MINER));
            this.open();
        }

        public void onClose() {
            super.onClose();
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)MinerBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            super.onTick();
        }
    }
}

