/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines.crafting;

import eu.pb4.factorytools.api.advancement.TriggerCriterion;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.advancement.FactoryTriggers;
import eu.pb4.polyfactory.block.BlockHeat;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.FluidInputOutput;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlockEntity;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.MixerBlock;
import eu.pb4.polyfactory.fluid.FluidContainer;
import eu.pb4.polyfactory.fluid.FluidContainerImpl;
import eu.pb4.polyfactory.fluid.FluidContainerUtil;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.item.FactoryDataComponents;
import eu.pb4.polyfactory.item.component.FluidComponent;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.input.FluidContainerInput;
import eu.pb4.polyfactory.recipe.input.FluidInputStack;
import eu.pb4.polyfactory.recipe.input.MixingInput;
import eu.pb4.polyfactory.recipe.mixing.MixingRecipe;
import eu.pb4.polyfactory.ui.FluidTextures;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.ui.UiResourceCreator;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.inventory.InventoryList;
import eu.pb4.polyfactory.util.movingitem.SimpleContainer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class MixerBlockEntity
extends TallItemMachineBlockEntity
implements FluidInputOutput.ContainerBased {
    public static final int OUTPUT_FIRST = 6;
    public static final int INPUT_FIRST = 0;
    public static final int SIZE = 9;
    public static final long FLUID_CAPACITY = 162000L;
    private static final int[] OUTPUT_SLOTS = new int[]{6, 7, 8};
    private static final int[] INPUT_SLOTS = new int[]{0, 1, 2, 3, 4, 5};
    protected double process = 0.0;
    protected float temperature = 0.0f;
    @Nullable
    protected class_8786<MixingRecipe> currentRecipe = null;
    private boolean active;
    private final SimpleContainer[] containers = SimpleContainer.createArray(9, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1));
    private final List<class_1799> stacks = new InventoryList(this, 0, 6);
    private final FluidContainerImpl fluidContainer = new FluidContainerImpl(162000L, this::method_5431);
    private MixerBlock.Model model;
    private boolean inventoryChanged = false;
    private double speedScale;

    public MixerBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.MIXER, pos, state);
    }

    @Override
    protected void updatePosition(int id) {
        SimpleContainer c = this.containers[id];
        if (!c.isContainerEmpty()) {
            class_243 base = id >= 6 ? class_243.method_24953((class_2382)this.field_11867).method_1031((double)(((float)((id -= 6) >> 1) - 0.5f) * 0.12f), (double)(-id) * 0.005, ((double)(id % 2) - 0.5) * 0.2) : class_243.method_24953((class_2382)this.field_11867).method_1031((double)(((float)(id >> 1) - 0.5f) * 0.15f), -0.15 - (double)id * 0.005, ((double)(id % 2) - 0.5) * 0.2);
            c.getContainer().setPos(base);
            c.getContainer().scale(0.5f);
        }
    }

    protected void method_11007(class_11372 view) {
        this.writeInventoryView(view);
        view.method_71463("Progress", this.process);
        this.fluidContainer.writeData(view, "fluid");
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.readInventoryView(view);
        this.process = view.method_71422("Progress", 0.0);
        this.fluidContainer.readData(view, "fluid");
        this.inventoryChanged = true;
        super.method_11014(view);
    }

    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        FluidComponent f = (FluidComponent)components.method_58694(FactoryDataComponents.FLUID);
        if (f != null) {
            this.fluidContainer.clear();
            f.extractTo(this.fluidContainer);
        }
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(FactoryDataComponents.FLUID, (Object)FluidComponent.copyFrom(this.fluidContainer));
    }

    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("fluid");
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(MixerBlock.INPUT_FACING);
        return facing.method_10153() == side || side == class_2350.field_11033 ? OUTPUT_SLOTS : INPUT_SLOTS;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot < 6;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return slot >= 6;
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        MixerBlockEntity self = (MixerBlockEntity)t;
        if (self.model == null) {
            self.model = (MixerBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            for (int i = 0; i < self.containers.length; ++i) {
                self.updatePosition(i);
                self.containers[i].maybeAdd((ElementHolder)self.model);
            }
        }
        self.state = null;
        self.temperature = BlockHeat.getReceived(world, pos) + self.fluidContainer.fluidTemperature();
        FluidContainerUtil.tick((FluidContainer)self.fluidContainer, (class_3218)world, pos, self.temperature, self::addToOutputOrDrop);
        self.model.setFluid(self.fluidContainer.topFluid(), self.fluidContainer.getFilledPercentage());
        if (self.isInputEmpty() && self.fluidContainer.isEmpty()) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.active = false;
            self.model.setActive(false);
            self.model.tick();
            return;
        }
        if (self.currentRecipe == null && !self.inventoryChanged) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.active = false;
            self.model.setActive(false);
            self.model.tick();
            self.state = INCORRECT_ITEMS_TEXT;
            return;
        }
        MixingInput input = new MixingInput(self.stacks, FluidContainerInput.of(self.fluidContainer), world);
        if (self.inventoryChanged && (self.currentRecipe == null || !((MixingRecipe)self.currentRecipe.comp_1933()).method_8115(input, world))) {
            self.process = 0.0;
            self.speedScale = 0.0;
            self.currentRecipe = ((class_3218)world).method_64577().method_8132(FactoryRecipeTypes.MIXER, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.active = false;
                self.model.setActive(false);
                self.model.tick();
                self.inventoryChanged = false;
                self.state = INCORRECT_ITEMS_TEXT;
                return;
            }
        }
        self.inventoryChanged = false;
        if (self.temperature < ((MixingRecipe)self.currentRecipe.comp_1933()).minimumTemperature(input) || self.temperature > ((MixingRecipe)self.currentRecipe.comp_1933()).maxTemperature(input)) {
            self.active = false;
            self.state = self.temperature < ((MixingRecipe)self.currentRecipe.comp_1933()).minimumTemperature(input) ? TOO_COLD_TEXT : TOO_HOT_TEXT;
            self.model.setActive(false);
            self.model.tick();
            return;
        }
        self.active = true;
        self.model.setActive(true);
        RotationData rot = RotationUser.getRotation((class_1937)((class_3218)world), pos.method_10084());
        double fullSpeed = rot.speed();
        self.model.rotate((float)fullSpeed);
        self.model.tick();
        if (self.process >= ((MixingRecipe)self.currentRecipe.comp_1933()).time(input)) {
            class_1799 output = ((MixingRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)world.method_30349());
            List<FluidStack<?>> outFluid = ((MixingRecipe)self.currentRecipe.comp_1933()).fluidOutput(input);
            long emptyFluids = self.fluidContainer.empty();
            for (FluidInputStack fluidInputStack : ((MixingRecipe)self.currentRecipe.comp_1933()).fluidInput(input)) {
                emptyFluids -= fluidInputStack.used();
            }
            for (FluidStack fluidStack : outFluid) {
                emptyFluids -= fluidStack.amount();
            }
            if (emptyFluids < 0L) {
                self.state = OUTPUT_FULL_TEXT;
                return;
            }
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            items.add(output.method_7972());
            for (class_1799 x : ((MixingRecipe)self.currentRecipe.comp_1933()).remainders(input)) {
                items.add(x.method_7972());
            }
            class_1277 class_12772 = new class_1277(3);
            for (int i = 0; i < 3; ++i) {
                class_12772.method_5447(i, self.method_5438(6 + i).method_7972());
            }
            for (class_1799 item : items) {
                FactoryUtil.tryInsertingInv((class_1263)class_12772, item, null);
                if (item.method_7960()) continue;
                self.state = OUTPUT_FULL_TEXT;
                return;
            }
            ((MixingRecipe)self.currentRecipe.comp_1933()).applyRecipeUse(self, world);
            self.process = 0.0;
            class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0);
            if (class_16572 instanceof class_3222) {
                class_3222 player = (class_3222)class_16572;
                class_174.field_44587.method_51350(player, self.currentRecipe.comp_1932(), self.asCraftingRecipeInput().method_59989());
                TriggerCriterion.trigger((class_3222)player, (class_2960)FactoryTriggers.MIXER_CRAFTS);
            }
            FactoryUtil.insertBetween(self, 6, self.method_5439(), output);
            for (class_1799 class_17992 : ((MixingRecipe)self.currentRecipe.comp_1933()).remainders(input)) {
                FactoryUtil.insertBetween(self, 6, self.method_5439(), class_17992);
            }
            for (FluidStack fluidStack : outFluid) {
                self.fluidContainer.insert(fluidStack, false);
            }
            self.method_5431();
        } else {
            double speed;
            double d = Math.max(((MixingRecipe)self.currentRecipe.comp_1933()).optimalSpeed(input) - ((MixingRecipe)self.currentRecipe.comp_1933()).minimumSpeed(input), 1.0);
            self.speedScale = speed = Math.min(Math.max(Math.abs(fullSpeed) - ((MixingRecipe)self.currentRecipe.comp_1933()).minimumSpeed(input), 0.0), d) / d / 20.0;
            if (speed > 0.0) {
                self.process += speed;
                MixerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)self.method_11010());
                class_1799 stack = self.method_5438(world.field_9229.method_39332(0, 6));
                if (!stack.method_7960()) {
                    ((class_3218)world).method_65096((class_2394)new class_2392(class_2398.field_11218, stack.method_7972()), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.8, (Math.random() - 0.5) * 0.2, 2.0);
                    ((class_3218)world).method_65096((class_2394)new class_2392(class_2398.field_11218, stack.method_7972()), (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2, 2.0);
                }
                return;
            }
            if (world.method_8510() % 5L == 0L) {
                ((class_3218)world).method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 2), (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.04, (Math.random() - 0.5) * 0.2, 0.3);
            }
            self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
        }
    }

    @Override
    public class_1269 onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 stack = player.method_6047();
        class_1799 copy = stack.method_7972();
        class_1799 x = FluidContainerUtil.interactWith(this.fluidContainer, (class_3222)player, player.method_6047());
        if (x == null) {
            return super.onUse(state, world, pos, player, hit);
        }
        if (stack.method_7960() && class_1799.method_7973((class_1799)stack, (class_1799)copy)) {
            return class_1269.field_5814;
        }
        if (stack.method_7960()) {
            player.method_6122(class_1268.field_5808, x);
        } else if (!x.method_7960()) {
            if (player.method_68878()) {
                if (!player.method_31548().method_7379(x)) {
                    player.method_31548().method_7394(x);
                }
            } else {
                player.method_31548().method_7398(x);
            }
        }
        return class_1269.field_52422;
    }

    private void addToOutputOrDrop(class_1799 stack) {
        FactoryUtil.insertBetween(this, 6, this.method_5439(), stack);
        if (!stack.method_7960()) {
            assert (this.field_11863 != null);
            class_1264.method_5449((class_1937)this.field_11863, (double)((double)this.field_11867.method_10263() + 0.5), (double)((double)this.field_11867.method_10264() + 0.5), (double)((double)this.field_11867.method_10260() + 0.5), (class_1799)stack);
        }
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < 6; ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getStress() {
        if (this.active) {
            MixingInput input = new MixingInput(this.stacks, FluidContainerInput.of(this.fluidContainer), this.field_11863);
            return this.currentRecipe != null ? class_3532.method_15350((double)(((MixingRecipe)this.currentRecipe.comp_1933()).optimalSpeed(input) * 0.6 * this.speedScale), (double)(((MixingRecipe)this.currentRecipe.comp_1933()).minimumSpeed(input) * 0.6), (double)(((MixingRecipe)this.currentRecipe.comp_1933()).optimalSpeed(input) * 0.6)) : 1.0;
        }
        return 0.0;
    }

    public void method_5431() {
        super.method_5431();
        this.inventoryChanged = true;
    }

    @Override
    public SimpleContainer[] getContainers() {
        return this.containers;
    }

    @Override
    @Nullable
    public BlockModel getModel() {
        return this.model;
    }

    public class_9694 asCraftingRecipeInput() {
        ArrayList<class_1799> l = new ArrayList<class_1799>();
        for (int i = 0; i < 6; ++i) {
            l.add(this.method_5438(i));
        }
        return class_9694.method_59986((int)2, (int)3, l);
    }

    public float temperature() {
        return this.temperature;
    }

    public FluidContainer getFluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public FluidContainer getFluidContainer(class_2350 direction) {
        return this.fluidContainer;
    }

    @Override
    @Nullable
    public FluidContainer getMainFluidContainer() {
        return this.fluidContainer;
    }

    @Override
    public class_2561 getFilledStateText() {
        return null;
    }

    private class Gui
    extends SimpleGui {
        private static final class_2561 CURRENT_HEAT = class_2561.method_43471((String)"text.polyfactory.current_heat").method_27694(x -> x.method_10978(Boolean.valueOf(false)));
        private int lastFluidUpdate;
        private int delayTick;

        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.lastFluidUpdate = -1;
            this.delayTick = -1;
            this.updateTitleAndFluid();
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.MIXER));
            GuiElementInterface fluidSlot = FluidContainerUtil.guiElement(MixerBlockEntity.this.fluidContainer, true);
            this.setSlot(1, fluidSlot);
            this.setSlot(10, fluidSlot);
            this.setSlot(19, fluidSlot);
            this.setSlotRedirect(2, new class_1735((class_1263)MixerBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(3, new class_1735((class_1263)MixerBlockEntity.this, 1, 1, 0));
            this.setSlotRedirect(11, new class_1735((class_1263)MixerBlockEntity.this, 2, 2, 0));
            this.setSlotRedirect(12, new class_1735((class_1263)MixerBlockEntity.this, 3, 3, 0));
            this.setSlotRedirect(20, new class_1735((class_1263)MixerBlockEntity.this, 4, 4, 0));
            this.setSlotRedirect(21, new class_1735((class_1263)MixerBlockEntity.this, 5, 5, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            this.setSlot(22, GuiTextures.TEMPERATURE_OFFSET_RIGHT.getNamed(class_3532.method_15363((float)MixerBlockEntity.this.temperature, (float)-1.0f, (float)1.0f), CURRENT_HEAT));
            this.setSlot(23, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GuiTextures.EMPTY.getItemStack()).setName(CURRENT_HEAT));
            this.setSlotRedirect(6, (class_1735)new class_1719((class_1657)player, (class_1263)MixerBlockEntity.this, 6, 3, 0));
            this.setSlotRedirect(15, (class_1735)new class_1719((class_1657)player, (class_1263)MixerBlockEntity.this, 7, 3, 0));
            this.setSlotRedirect(24, (class_1735)new class_1719((class_1657)player, (class_1263)MixerBlockEntity.this, 8, 3, 0));
            this.open();
        }

        private void updateTitleAndFluid() {
            class_2561 text = GuiTextures.MIXER.apply((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MIXER_FLUID_OFFSET)).method_10862(UiResourceCreator.STYLE)).method_10852(FluidTextures.MIXER.render(MixerBlockEntity.this.fluidContainer::provideRender)).method_10852((class_2561)class_2561.method_43470((String)("" + GuiTextures.MIXER_FLUID_OFFSET_N)).method_10862(UiResourceCreator.STYLE)).method_10852((class_2561)MixerBlockEntity.this.method_11010().method_26204().method_9518()));
            if (!text.equals((Object)this.getTitle())) {
                this.setTitle(text);
            }
            this.lastFluidUpdate = MixerBlockEntity.this.fluidContainer.updateId();
        }

        private float progress() {
            return MixerBlockEntity.this.currentRecipe != null ? (float)class_3532.method_15350((double)(MixerBlockEntity.this.process / ((MixingRecipe)MixerBlockEntity.this.currentRecipe.comp_1933()).time(new MixingInput(MixerBlockEntity.this.stacks, FluidContainerInput.of(MixerBlockEntity.this.fluidContainer), MixerBlockEntity.this.field_11863))), (double)0.0, (double)1.0) : 0.0f;
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)MixerBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            if (MixerBlockEntity.this.fluidContainer.updateId() != this.lastFluidUpdate && this.delayTick < 0) {
                this.delayTick = 3;
            }
            if (this.delayTick-- == 0) {
                this.updateTitleAndFluid();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_HORIZONTAL_OFFSET_RIGHT.get(this.progress()));
            this.setSlot(22, GuiTextures.TEMPERATURE_OFFSET_RIGHT.getNamed(class_3532.method_15363((float)MixerBlockEntity.this.temperature, (float)-1.0f, (float)1.0f), CURRENT_HEAT));
            super.onTick();
        }
    }
}

