/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.mechanical.machines.crafting;

import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.polyfactory.block.FactoryBlockEntities;
import eu.pb4.polyfactory.block.fluids.DrainBlockEntity;
import eu.pb4.polyfactory.block.mechanical.RotationUser;
import eu.pb4.polyfactory.block.mechanical.machines.TallItemMachineBlockEntity;
import eu.pb4.polyfactory.block.mechanical.machines.crafting.PressBlock;
import eu.pb4.polyfactory.fluid.FluidStack;
import eu.pb4.polyfactory.nodes.mechanical.RotationData;
import eu.pb4.polyfactory.other.FactorySoundEvents;
import eu.pb4.polyfactory.polydex.PolydexCompat;
import eu.pb4.polyfactory.recipe.FactoryRecipeTypes;
import eu.pb4.polyfactory.recipe.input.PressInput;
import eu.pb4.polyfactory.recipe.press.PressRecipe;
import eu.pb4.polyfactory.ui.GuiTextures;
import eu.pb4.polyfactory.util.FactoryUtil;
import eu.pb4.polyfactory.util.movingitem.SimpleContainer;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1719;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class PressBlockEntity
extends TallItemMachineBlockEntity {
    public static final int INPUT_SLOT = 0;
    public static final int INPUT_2_SLOT = 1;
    public static final int OUTPUT_SLOT = 2;
    private static final int[] INPUT_SLOTS = new int[]{0};
    private static final int[] INPUT_2_SLOTS = new int[]{1};
    private static final int[] OUTPUT_SLOTS = new int[]{2};
    private final SimpleContainer[] containers = new SimpleContainer[]{new SimpleContainer(0, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1)), new SimpleContainer(), new SimpleContainer(2, (x$0, x$1, x$2) -> this.addMoving(x$0, x$1, x$2), (x$0, x$1) -> this.removeMoving(x$0, x$1))};
    protected double process = 0.0;
    @Nullable
    protected class_8786<PressRecipe> currentRecipe = null;
    @Nullable
    protected class_1792 currentItem = null;
    protected int currentItemCount = -1;
    private PressBlock.Model model;
    private boolean active;
    private class_1792 currentItem2;
    private int currentItemCount2;
    @Nullable
    private class_1799 delayedOutput;
    private boolean playedSound;

    public PressBlockEntity(class_2338 pos, class_2680 state) {
        super(FactoryBlockEntities.PRESS, pos, state);
    }

    public static <T extends class_2586> void ticker(class_1937 world, class_2338 pos, class_2680 state, T t) {
        PressBlockEntity self = (PressBlockEntity)t;
        if (self.model == null) {
            self.model = (PressBlock.Model)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.updatePosition(0);
            self.updatePosition(2);
            self.containers[0].maybeAdd((ElementHolder)self.model);
            self.containers[2].maybeAdd((ElementHolder)self.model);
        }
        SimpleContainer stack = self.containers[0];
        SimpleContainer stack2 = self.containers[1];
        self.state = null;
        if (self.process < 0.0 && stack.isContainerEmpty()) {
            double speed = Math.max(Math.abs(RotationUser.getRotation((class_1937)((class_3218)world), pos.method_10084()).speed()), 0.0);
            self.process += speed / 120.0;
            self.model.updatePiston(self.process);
            self.active = true;
            self.delayedOutput = null;
            self.model.tick();
            return;
        }
        if (stack.isContainerEmpty()) {
            if (self.process != 0.0) {
                self.model.updatePiston(0.0);
            }
            self.process = 0.0;
            self.active = false;
            self.delayedOutput = null;
            self.model.tick();
            return;
        }
        if (self.currentRecipe == null && self.currentItem != null && stack.getStack().method_31574(self.currentItem) && stack.getStack().method_7947() == self.currentItemCount && stack2.getStack().method_31574(self.currentItem2) && stack2.getStack().method_7947() == self.currentItemCount2) {
            if (self.process != 0.0) {
                self.model.updatePiston(0.0);
            }
            self.process = 0.0;
            self.model.tick();
            self.delayedOutput = null;
            self.active = false;
            self.state = INCORRECT_ITEMS_TEXT;
            return;
        }
        PressInput input = new PressInput(stack.getStack(), stack2.getStack());
        if (self.currentRecipe == null || !((PressRecipe)self.currentRecipe.comp_1933()).method_8115(input, world)) {
            if (self.process != 0.0) {
                self.model.updatePiston(0.0);
            }
            self.process = 0.0;
            self.delayedOutput = null;
            self.currentItem = stack.getStack().method_7909();
            self.currentItem2 = stack2.getStack().method_7909();
            self.currentItemCount = stack.getStack().method_7947();
            self.currentItemCount2 = stack2.getStack().method_7947();
            self.currentRecipe = ((class_3218)world).method_64577().method_8132(FactoryRecipeTypes.PRESS, (class_9695)input, world).orElse(null);
            if (self.currentRecipe == null) {
                self.model.tick();
                self.active = false;
                self.state = INCORRECT_ITEMS_TEXT;
                return;
            }
        }
        self.active = true;
        if (self.process >= 1.0 || self.delayedOutput != null) {
            class_1799 nextOut = self.delayedOutput != null ? self.delayedOutput : ((PressRecipe)self.currentRecipe.comp_1933()).method_8116(input, (class_7225.class_7874)self.field_11863.method_30349());
            class_1799 currentOut = self.method_5438(2);
            boolean success = false;
            if (currentOut.method_7960()) {
                success = true;
                self.method_5447(2, nextOut);
            } else if (class_1799.method_31577((class_1799)currentOut, (class_1799)nextOut) && currentOut.method_7947() + nextOut.method_7947() <= currentOut.method_7914()) {
                success = true;
                currentOut.method_7933(nextOut.method_7947());
            }
            if (success) {
                List<FluidStack<?>> fluids;
                class_1657 class_16572 = FactoryUtil.getClosestPlayer(world, pos, 32.0);
                if (class_16572 instanceof class_3222) {
                    class_3222 player = (class_3222)class_16572;
                    class_174.field_44587.method_51350(player, self.currentRecipe.comp_1932(), List.of(stack.getStack(), stack2.getStack()));
                }
                if (!(fluids = ((PressRecipe)self.currentRecipe.comp_1933()).outputFluids(input)).isEmpty()) {
                    ArrayList copy = new ArrayList(fluids);
                    for (class_2350 dir : class_2350.class_2353.field_11062) {
                        class_2586 class_25862 = world.method_8321(pos.method_10093(dir));
                        if (!(class_25862 instanceof DrainBlockEntity)) continue;
                        DrainBlockEntity be = (DrainBlockEntity)class_25862;
                        for (int i = 0; i < copy.size(); ++i) {
                            FluidStack<?> fluid = copy.get(i);
                            if (fluid.isEmpty()) continue;
                            long leftover = be.insertFluid(fluid.instance(), fluid.amount(), dir.method_10153());
                            copy.set(i, fluid.withAmount(leftover));
                        }
                    }
                    for (FluidStack<?> fluid : copy) {
                        if (fluid.isEmpty()) continue;
                        for (int i = 0; i < 5; ++i) {
                            ((class_3218)world).method_65096(fluid.instance().particle(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.05, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.01, (Math.random() - 0.5) * 0.2, 0.3);
                        }
                    }
                    for (FluidStack<?> fluid : fluids) {
                        ((class_3218)world).method_65096(fluid.instance().particle(), (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.05, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2, 0.2);
                    }
                }
                self.process = -0.6;
                self.model.updatePiston(self.process);
                ((class_3218)world).method_65096((class_2394)class_2398.field_11204, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.9, (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.0, (Math.random() - 0.5) * 0.2, 0.2);
                ((PressRecipe)self.currentRecipe.comp_1933()).applyRecipeUse(self, world);
                self.delayedOutput = null;
                self.playedSound = false;
            } else {
                self.delayedOutput = nextOut;
            }
        } else {
            RotationData rot = RotationUser.getRotation((class_1937)((class_3218)world), pos.method_10086(1));
            double speed = Math.max(Math.abs(rot.speed()), 0.0);
            if (speed >= ((PressRecipe)self.currentRecipe.comp_1933()).minimumSpeed()) {
                self.process += speed / 100.0;
                self.model.updatePiston(self.process);
                if (self.process >= 0.4 && !self.playedSound) {
                    world.method_8396(null, pos, FactorySoundEvents.BLOCK_PRESS_CRAFT, class_3419.field_15245, 0.1f, 1.2f);
                    self.playedSound = true;
                }
            } else if (world.method_8510() % 5L == 0L) {
                ((class_3218)world).method_65096((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 2), (double)pos.method_10260() + 0.5, 0, (Math.random() - 0.5) * 0.2, 0.04, (Math.random() - 0.5) * 0.2, 0.3);
                self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
            } else {
                self.state = rot.getStateTextOrElse(TOO_SLOW_TEXT);
            }
        }
        self.model.tick();
    }

    @Override
    @Nullable
    public BlockModel getModel() {
        return this.model;
    }

    @Override
    public double getStress() {
        if (this.active) {
            return this.currentRecipe != null ? ((PressRecipe)this.currentRecipe.comp_1933()).minimumSpeed() * 0.8 : 4.0;
        }
        return 0.0;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (slot == 1 && this.model != null) {
            this.model.setItem(stack.method_46651(1));
        }
    }

    protected void method_11007(class_11372 view) {
        this.writeInventoryView(view);
        view.method_71463("Progress", this.process);
        if (this.delayedOutput != null && !this.delayedOutput.method_7960()) {
            view.method_71468("DelayedOutput", class_1799.field_49266, (Object)this.delayedOutput);
        }
        super.method_11007(view);
    }

    public void method_11014(class_11368 view) {
        this.readInventoryView(view);
        this.process = view.method_71422("Progress", 0.0);
        this.delayedOutput = view.method_71426("DelayedOutput", class_1799.field_49266).orElse(class_1799.field_8037);
        if (this.delayedOutput.method_7960()) {
            this.delayedOutput = null;
        }
        this.currentItem = null;
        this.currentItem2 = null;
        super.method_11014(view);
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(PressBlock.INPUT_FACING);
        if (facing == side) {
            return INPUT_SLOTS;
        }
        if (facing.method_10153() == side || side == class_2350.field_11033) {
            return OUTPUT_SLOTS;
        }
        if (facing.method_10170().method_10166() == side.method_10166()) {
            return INPUT_2_SLOTS;
        }
        return new int[0];
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return slot == 0 && (dir == null || this.method_11010().method_11654(PressBlock.INPUT_FACING) == dir) || slot == 1 && dir == null || ((class_2350)this.method_11010().method_11654(PressBlock.INPUT_FACING)).method_10170().method_10166() == dir.method_10166();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(PressBlock.INPUT_FACING);
        return slot == 0 && facing == dir || slot != 0 && (facing.method_10153() == dir || dir == class_2350.field_11033);
    }

    public void createGui(class_3222 player) {
        new Gui(player);
    }

    @Override
    protected void updatePosition(int id) {
        SimpleContainer c = this.containers[id];
        if (!c.isContainerEmpty()) {
            class_243 base = class_243.method_24953((class_2382)this.field_11867).method_1031(0.0, 0.4, 0.0);
            if (id == 2) {
                base = base.method_43206((class_2350)this.method_11010().method_11654(PressBlock.INPUT_FACING), -0.3);
            }
            c.getContainer().setPos(base);
            c.getContainer().scale(1.0f);
        }
    }

    @Override
    public SimpleContainer[] getContainers() {
        return this.containers;
    }

    private class Gui
    extends SimpleGui {
        public Gui(class_3222 player) {
            super(class_3917.field_17326, player, false);
            this.setTitle(GuiTextures.PRESS.apply((class_2561)PressBlockEntity.this.method_11010().method_26204().method_9518()));
            this.setSlot(9, (GuiElementInterface)PolydexCompat.getButton(FactoryRecipeTypes.PRESS));
            this.setSlotRedirect(3, new class_1735((class_1263)PressBlockEntity.this, 0, 0, 0));
            this.setSlotRedirect(5, new class_1735((class_1263)PressBlockEntity.this, 1, 0, 0));
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_VERTICAL.get(this.progress()));
            this.setSlotRedirect(22, (class_1735)new class_1719((class_1657)player, (class_1263)PressBlockEntity.this, 2, 1, 0));
            this.open();
        }

        private float progress() {
            return (float)class_3532.method_15350((double)PressBlockEntity.this.process, (double)0.0, (double)1.0);
        }

        public void onTick() {
            if (this.player.method_73189().method_1025(class_243.method_24953((class_2382)PressBlockEntity.this.field_11867)) > 324.0) {
                this.close();
            }
            this.setSlot(13, (GuiElementInterface)GuiTextures.PROGRESS_VERTICAL.get(this.progress()));
            super.onTick();
        }
    }
}

