/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.block.other;

import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polyfactory.ModInit;
import eu.pb4.polyfactory.block.other.ColorableBlockEntity;
import eu.pb4.polyfactory.item.FactoryItems;
import eu.pb4.polyfactory.item.util.ColoredItem;
import eu.pb4.polyfactory.util.BlockStateNameProvider;
import eu.pb4.polyfactory.util.ColorProvider;
import eu.pb4.polyfactory.util.DyeColorExtra;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_2453;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xyz.nucleoid.packettweaker.PacketContext;

public class LampBlock
extends class_2453
implements FactoryBlock,
class_2343,
BlockStateNameProvider {
    private final boolean inverted;

    public LampBlock(class_4970.class_2251 settings, boolean inverted) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)field_11413, (Comparable)Boolean.valueOf(false)));
        this.inverted = inverted;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        ColorableBlockEntity be;
        class_1799 stack = super.method_9574(world, pos, state, includeData);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorableBlockEntity && !(be = (ColorableBlockEntity)class_25862).isDefaultColor()) {
            ColoredItem.setColor(stack, be.getColor());
        }
        return stack;
    }

    public boolean setColor(class_1937 world, class_2338 pos, int color) {
        ColorProvider provider;
        color = FactoryItems.LAMP.downSampleColor(color);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorProvider && (provider = (ColorProvider)class_25862).getColor() != color) {
            provider.setColor(color);
            return true;
        }
        return false;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof ColorableBlockEntity) {
            ColorableBlockEntity be = (ColorableBlockEntity)class_25862;
            be.setColor(FactoryItems.LAMP.getItemColor(itemStack));
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(pos, initialBlockState, this.inverted);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new ColorableBlockEntity(pos, state);
    }

    @Override
    public class_2561 getName(class_3218 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        ColorableBlockEntity be;
        if (blockEntity instanceof ColorableBlockEntity && !(be = (ColorableBlockEntity)blockEntity).isDefaultColor()) {
            if (!DyeColorExtra.hasLang(be.getColor())) {
                return class_2561.method_43469((String)(this.method_63499() + ".colored.full"), (Object[])new Object[]{ColoredItem.getColorName(be.getColor()), ColoredItem.getHexName(be.getColor())});
            }
            return class_2561.method_43469((String)(this.method_63499() + ".colored"), (Object[])new Object[]{ColoredItem.getColorName(be.getColor())});
        }
        return this.method_9518();
    }

    public boolean forceLightUpdates(class_2680 blockState) {
        return true;
    }

    protected boolean method_9579(class_2680 state) {
        return true;
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10033.method_9564();
    }

    public static final class Model
    extends BlockModel
    implements ColorProvider.Consumer {
        private final ItemDisplayElement main = ItemDisplayElementUtil.createSimple();
        private final boolean inverted;
        private int color = -2;
        private class_2680 state;

        private Model(class_2338 pos, class_2680 state, boolean inverted) {
            this.main.setScale((Vector3fc)new Vector3f(2.0f + (float)(pos.method_19455((class_2382)class_2338.field_10980) % 2) * 0.001f));
            this.main.setViewRange(0.8f);
            this.state = state;
            this.inverted = inverted;
            this.addElement((VirtualElement)this.main);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                this.setState(this.blockState());
            }
        }

        private void setState(class_2680 blockState) {
            this.state = blockState;
            if (this.color != -2) {
                this.updateModel();
            }
        }

        private void updateModel() {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8450);
            stack.method_57379(class_9334.field_54199, (Object)((Boolean)this.state.method_11654((class_2769)class_2453.field_11413) == this.inverted ? ModInit.id("colored_lamp") : ModInit.id("inverted_colored_lamp")));
            stack.method_57379(class_9334.field_49637, (Object)new class_9280(List.of(), List.of(), List.of(), (List)IntList.of((int)this.color)));
            this.main.setItem(stack);
            this.tick();
        }

        @Override
        public void setColor(int color) {
            this.color = color;
            if (color != -2) {
                this.updateModel();
            }
        }
    }
}

