/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polyfactory.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import eu.pb4.polyfactory.data.BoolData;
import eu.pb4.polyfactory.data.DataType;
import eu.pb4.polyfactory.data.DoubleData;
import eu.pb4.polyfactory.data.EmptyData;
import eu.pb4.polyfactory.data.LongData;
import eu.pb4.polyfactory.data.ProgressData;
import eu.pb4.polyfactory.data.RedstoneData;
import eu.pb4.polyfactory.data.StringData;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_9299;
import net.minecraft.class_9473;

public interface DataContainer
extends Comparable<DataContainer>,
class_9299 {
    public static final MapCodec<DataContainer> MAP_CODEC = MapCodec.recursive((String)"data_container", x -> DataType.CODEC.dispatchMap("type", DataContainer::type, DataType::codec));
    public static final Codec<DataContainer> CODEC = MAP_CODEC.codec();
    public static final List<String> GENERIC_EXTRACTS = List.of("decimal", "integer", "string", "boolean", "redstone", "progress");

    public static DataContainer of(long count) {
        return new LongData(count);
    }

    public static DataContainer of(boolean count) {
        return count ? BoolData.TRUE : BoolData.FALSE;
    }

    public static DataContainer empty() {
        return EmptyData.INSTANCE;
    }

    public DataType<? extends DataContainer> type();

    public String asString();

    public long asLong();

    public double asDouble();

    default public float asProgress() {
        return (float)(this.asDouble() / 100.0);
    }

    default public boolean isEmpty() {
        return false;
    }

    default public int asRedstoneOutput() {
        return (int)class_3532.method_53062((long)Math.abs(this.asLong()), (long)0L, (long)15L);
    }

    default public char padding() {
        return ' ';
    }

    default public boolean forceRight() {
        return false;
    }

    default public DataContainer extract(String field) {
        return switch (field) {
            case "decimal" -> new DoubleData(this.asDouble());
            case "integer" -> new LongData(this.asLong());
            case "redstone" -> new RedstoneData(this.asRedstoneOutput());
            case "string" -> new StringData(this.asString());
            case "boolean" -> BoolData.of(this.isTrue());
            case "progress" -> new ProgressData(this.asProgress());
            case "" -> this;
            default -> DataContainer.empty();
        };
    }

    default public boolean isTrue() {
        return this.asLong() != 0L;
    }

    @Override
    default public int compareTo(DataContainer other) {
        return Long.compare(this.asLong(), other.asLong());
    }

    default public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
        textConsumer.accept((class_2561)class_2564.method_10885((class_2561)class_2561.method_43471((String)"block.polyfactory.data_memory.tooltip.stored_data").method_27692(class_124.field_1054)).method_27692(class_124.field_1063));
        textConsumer.accept((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)"block.polyfactory.data_memory.tooltip.type", (Object[])new Object[]{class_2561.method_43471((String)("data_type.polyfactory." + this.type().id()))}).method_27692(class_124.field_1080)));
        textConsumer.accept((class_2561)class_5244.method_48320().method_10852((class_2561)class_2561.method_43469((String)"block.polyfactory.data_memory.tooltip.value", (Object[])new Object[]{this.asString()}).method_27692(class_124.field_1080)));
    }
}

